/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.base;

import com.l2jserver.Config;
import com.l2jserver.gameserver.enums.PcRace;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.base.ClassInfo;
import com.l2jserver.gameserver.model.base.ClassLevel;
import com.l2jserver.gameserver.model.base.ClassType;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Set;

public enum PlayerClass {
    HumanFighter(PcRace.Human, ClassType.Fighter, ClassLevel.First),
    Warrior(PcRace.Human, ClassType.Fighter, ClassLevel.Second),
    Gladiator(PcRace.Human, ClassType.Fighter, ClassLevel.Third),
    Warlord(PcRace.Human, ClassType.Fighter, ClassLevel.Third),
    HumanKnight(PcRace.Human, ClassType.Fighter, ClassLevel.Second),
    Paladin(PcRace.Human, ClassType.Fighter, ClassLevel.Third),
    DarkAvenger(PcRace.Human, ClassType.Fighter, ClassLevel.Third),
    Rogue(PcRace.Human, ClassType.Fighter, ClassLevel.Second),
    TreasureHunter(PcRace.Human, ClassType.Fighter, ClassLevel.Third),
    Hawkeye(PcRace.Human, ClassType.Fighter, ClassLevel.Third),
    HumanMystic(PcRace.Human, ClassType.Mystic, ClassLevel.First),
    HumanWizard(PcRace.Human, ClassType.Mystic, ClassLevel.Second),
    Sorceror(PcRace.Human, ClassType.Mystic, ClassLevel.Third),
    Necromancer(PcRace.Human, ClassType.Mystic, ClassLevel.Third),
    Warlock(PcRace.Human, ClassType.Mystic, ClassLevel.Third),
    Cleric(PcRace.Human, ClassType.Priest, ClassLevel.Second),
    Bishop(PcRace.Human, ClassType.Priest, ClassLevel.Third),
    Prophet(PcRace.Human, ClassType.Priest, ClassLevel.Third),
    ElvenFighter(PcRace.Elf, ClassType.Fighter, ClassLevel.First),
    ElvenKnight(PcRace.Elf, ClassType.Fighter, ClassLevel.Second),
    TempleKnight(PcRace.Elf, ClassType.Fighter, ClassLevel.Third),
    Swordsinger(PcRace.Elf, ClassType.Fighter, ClassLevel.Third),
    ElvenScout(PcRace.Elf, ClassType.Fighter, ClassLevel.Second),
    Plainswalker(PcRace.Elf, ClassType.Fighter, ClassLevel.Third),
    SilverRanger(PcRace.Elf, ClassType.Fighter, ClassLevel.Third),
    ElvenMystic(PcRace.Elf, ClassType.Mystic, ClassLevel.First),
    ElvenWizard(PcRace.Elf, ClassType.Mystic, ClassLevel.Second),
    Spellsinger(PcRace.Elf, ClassType.Mystic, ClassLevel.Third),
    ElementalSummoner(PcRace.Elf, ClassType.Mystic, ClassLevel.Third),
    ElvenOracle(PcRace.Elf, ClassType.Priest, ClassLevel.Second),
    ElvenElder(PcRace.Elf, ClassType.Priest, ClassLevel.Third),
    DarkElvenFighter(PcRace.DarkElf, ClassType.Fighter, ClassLevel.First),
    PalusKnight(PcRace.DarkElf, ClassType.Fighter, ClassLevel.Second),
    ShillienKnight(PcRace.DarkElf, ClassType.Fighter, ClassLevel.Third),
    Bladedancer(PcRace.DarkElf, ClassType.Fighter, ClassLevel.Third),
    Assassin(PcRace.DarkElf, ClassType.Fighter, ClassLevel.Second),
    AbyssWalker(PcRace.DarkElf, ClassType.Fighter, ClassLevel.Third),
    PhantomRanger(PcRace.DarkElf, ClassType.Fighter, ClassLevel.Third),
    DarkElvenMystic(PcRace.DarkElf, ClassType.Mystic, ClassLevel.First),
    DarkElvenWizard(PcRace.DarkElf, ClassType.Mystic, ClassLevel.Second),
    Spellhowler(PcRace.DarkElf, ClassType.Mystic, ClassLevel.Third),
    PhantomSummoner(PcRace.DarkElf, ClassType.Mystic, ClassLevel.Third),
    ShillienOracle(PcRace.DarkElf, ClassType.Priest, ClassLevel.Second),
    ShillienElder(PcRace.DarkElf, ClassType.Priest, ClassLevel.Third),
    OrcFighter(PcRace.Orc, ClassType.Fighter, ClassLevel.First),
    OrcRaider(PcRace.Orc, ClassType.Fighter, ClassLevel.Second),
    Destroyer(PcRace.Orc, ClassType.Fighter, ClassLevel.Third),
    OrcMonk(PcRace.Orc, ClassType.Fighter, ClassLevel.Second),
    Tyrant(PcRace.Orc, ClassType.Fighter, ClassLevel.Third),
    OrcMystic(PcRace.Orc, ClassType.Mystic, ClassLevel.First),
    OrcShaman(PcRace.Orc, ClassType.Mystic, ClassLevel.Second),
    Overlord(PcRace.Orc, ClassType.Mystic, ClassLevel.Third),
    Warcryer(PcRace.Orc, ClassType.Mystic, ClassLevel.Third),
    DwarvenFighter(PcRace.Dwarf, ClassType.Fighter, ClassLevel.First),
    DwarvenScavenger(PcRace.Dwarf, ClassType.Fighter, ClassLevel.Second),
    BountyHunter(PcRace.Dwarf, ClassType.Fighter, ClassLevel.Third),
    DwarvenArtisan(PcRace.Dwarf, ClassType.Fighter, ClassLevel.Second),
    Warsmith(PcRace.Dwarf, ClassType.Fighter, ClassLevel.Third),
    dummyEntry1(null, null, null),
    dummyEntry2(null, null, null),
    dummyEntry3(null, null, null),
    dummyEntry4(null, null, null),
    dummyEntry5(null, null, null),
    dummyEntry6(null, null, null),
    dummyEntry7(null, null, null),
    dummyEntry8(null, null, null),
    dummyEntry9(null, null, null),
    dummyEntry10(null, null, null),
    dummyEntry11(null, null, null),
    dummyEntry12(null, null, null),
    dummyEntry13(null, null, null),
    dummyEntry14(null, null, null),
    dummyEntry15(null, null, null),
    dummyEntry16(null, null, null),
    dummyEntry17(null, null, null),
    dummyEntry18(null, null, null),
    dummyEntry19(null, null, null),
    dummyEntry20(null, null, null),
    dummyEntry21(null, null, null),
    dummyEntry22(null, null, null),
    dummyEntry23(null, null, null),
    dummyEntry24(null, null, null),
    dummyEntry25(null, null, null),
    dummyEntry26(null, null, null),
    dummyEntry27(null, null, null),
    dummyEntry28(null, null, null),
    dummyEntry29(null, null, null),
    dummyEntry30(null, null, null),
    duelist(PcRace.Human, ClassType.Fighter, ClassLevel.Fourth),
    dreadnought(PcRace.Human, ClassType.Fighter, ClassLevel.Fourth),
    phoenixKnight(PcRace.Human, ClassType.Fighter, ClassLevel.Fourth),
    hellKnight(PcRace.Human, ClassType.Fighter, ClassLevel.Fourth),
    sagittarius(PcRace.Human, ClassType.Fighter, ClassLevel.Fourth),
    adventurer(PcRace.Human, ClassType.Fighter, ClassLevel.Fourth),
    archmage(PcRace.Human, ClassType.Mystic, ClassLevel.Fourth),
    soultaker(PcRace.Human, ClassType.Mystic, ClassLevel.Fourth),
    arcanaLord(PcRace.Human, ClassType.Mystic, ClassLevel.Fourth),
    cardinal(PcRace.Human, ClassType.Priest, ClassLevel.Fourth),
    hierophant(PcRace.Human, ClassType.Priest, ClassLevel.Fourth),
    evaTemplar(PcRace.Elf, ClassType.Fighter, ClassLevel.Fourth),
    swordMuse(PcRace.Elf, ClassType.Fighter, ClassLevel.Fourth),
    windRider(PcRace.Elf, ClassType.Fighter, ClassLevel.Fourth),
    moonlightSentinel(PcRace.Elf, ClassType.Fighter, ClassLevel.Fourth),
    mysticMuse(PcRace.Elf, ClassType.Mystic, ClassLevel.Fourth),
    elementalMaster(PcRace.Elf, ClassType.Mystic, ClassLevel.Fourth),
    evaSaint(PcRace.Elf, ClassType.Priest, ClassLevel.Fourth),
    shillienTemplar(PcRace.DarkElf, ClassType.Fighter, ClassLevel.Fourth),
    spectralDancer(PcRace.DarkElf, ClassType.Fighter, ClassLevel.Fourth),
    ghostHunter(PcRace.DarkElf, ClassType.Fighter, ClassLevel.Fourth),
    ghostSentinel(PcRace.DarkElf, ClassType.Fighter, ClassLevel.Fourth),
    stormScreamer(PcRace.DarkElf, ClassType.Mystic, ClassLevel.Fourth),
    spectralMaster(PcRace.DarkElf, ClassType.Mystic, ClassLevel.Fourth),
    shillienSaint(PcRace.DarkElf, ClassType.Priest, ClassLevel.Fourth),
    titan(PcRace.Orc, ClassType.Fighter, ClassLevel.Fourth),
    grandKhavatari(PcRace.Orc, ClassType.Fighter, ClassLevel.Fourth),
    dominator(PcRace.Orc, ClassType.Mystic, ClassLevel.Fourth),
    doomcryer(PcRace.Orc, ClassType.Mystic, ClassLevel.Fourth),
    fortuneSeeker(PcRace.Dwarf, ClassType.Fighter, ClassLevel.Fourth),
    maestro(PcRace.Dwarf, ClassType.Fighter, ClassLevel.Fourth),
    dummyEntry31(null, null, null),
    dummyEntry32(null, null, null),
    dummyEntry33(null, null, null),
    dummyEntry34(null, null, null),
    maleSoldier(PcRace.Kamael, ClassType.Fighter, ClassLevel.First),
    femaleSoldier(PcRace.Kamael, ClassType.Fighter, ClassLevel.First),
    trooper(PcRace.Kamael, ClassType.Fighter, ClassLevel.Second),
    warder(PcRace.Kamael, ClassType.Fighter, ClassLevel.Second),
    berserker(PcRace.Kamael, ClassType.Fighter, ClassLevel.Third),
    maleSoulbreaker(PcRace.Kamael, ClassType.Fighter, ClassLevel.Third),
    femaleSoulbreaker(PcRace.Kamael, ClassType.Fighter, ClassLevel.Third),
    arbalester(PcRace.Kamael, ClassType.Fighter, ClassLevel.Third),
    doombringer(PcRace.Kamael, ClassType.Fighter, ClassLevel.Fourth),
    maleSoulhound(PcRace.Kamael, ClassType.Fighter, ClassLevel.Fourth),
    femaleSoulhound(PcRace.Kamael, ClassType.Fighter, ClassLevel.Fourth),
    trickster(PcRace.Kamael, ClassType.Fighter, ClassLevel.Fourth),
    inspector(PcRace.Kamael, ClassType.Fighter, ClassLevel.Third),
    judicator(PcRace.Kamael, ClassType.Fighter, ClassLevel.Fourth);

    private PcRace _race;
    private ClassLevel _level;
    private ClassType _type;
    private static final Set<PlayerClass> mainSubclassSet;
    private static final Set<PlayerClass> neverSubclassed;
    private static final Set<PlayerClass> subclasseSet1;
    private static final Set<PlayerClass> subclasseSet2;
    private static final Set<PlayerClass> subclasseSet3;
    private static final Set<PlayerClass> subclasseSet4;
    private static final Set<PlayerClass> subclasseSet5;
    private static final EnumMap<PlayerClass, Set<PlayerClass>> subclassSetMap;

    private PlayerClass(PcRace pRace, ClassType pType, ClassLevel pLevel) {
        this._race = pRace;
        this._level = pLevel;
        this._type = pType;
    }

    public final Set<PlayerClass> getAvailableSubclasses(L2PcInstance player) {
        EnumSet<PlayerClass> subclasses = null;
        if (this._level == ClassLevel.Third) {
            if (player.getRace() != PcRace.Kamael) {
                subclasses = EnumSet.copyOf(mainSubclassSet);
                subclasses.remove((Object)this);
                switch (player.getRace()) {
                    case Elf: {
                        subclasses.removeAll(PlayerClass.getSet(PcRace.DarkElf, ClassLevel.Third));
                        break;
                    }
                    case DarkElf: {
                        subclasses.removeAll(PlayerClass.getSet(PcRace.Elf, ClassLevel.Third));
                    }
                }
                subclasses.removeAll(PlayerClass.getSet(PcRace.Kamael, ClassLevel.Third));
                Set<PlayerClass> unavailableClasses = subclassSetMap.get((Object)this);
                if (unavailableClasses != null) {
                    subclasses.removeAll(unavailableClasses);
                }
            } else {
                subclasses = PlayerClass.getSet(PcRace.Kamael, ClassLevel.Third);
                subclasses.remove((Object)this);
                if (Config.MAX_SUBCLASS <= 3) {
                    if (player.getAppearance().getSex()) {
                        subclasses.removeAll(EnumSet.of(femaleSoulbreaker));
                    } else {
                        subclasses.removeAll(EnumSet.of(maleSoulbreaker));
                    }
                }
                if (!player.getSubClasses().containsKey(2) || player.getSubClasses().get(2).getLevel() < 75) {
                    subclasses.removeAll(EnumSet.of(inspector));
                }
            }
        }
        return subclasses;
    }

    public static final EnumSet<PlayerClass> getSet(PcRace race, ClassLevel level) {
        EnumSet<PlayerClass> allOf = EnumSet.noneOf(PlayerClass.class);
        for (PlayerClass playerClass : EnumSet.allOf(PlayerClass.class)) {
            if (race != null && !playerClass.isOfRace(race) || level != null && !playerClass.isOfLevel(level)) continue;
            allOf.add(playerClass);
        }
        return allOf;
    }

    public final boolean isOfRace(PcRace pRace) {
        return this._race == pRace;
    }

    public final boolean isOfType(ClassType pType) {
        return this._type == pType;
    }

    public final boolean isOfLevel(ClassLevel pLevel) {
        return this._level == pLevel;
    }

    public final ClassLevel getLevel() {
        return this._level;
    }

    public final int getId() {
        return this.ordinal();
    }

    public String getClassName() {
        return ClassInfo.getClassName(this.getId());
    }

    public String toHtm() {
        return ClassInfo.toHtm(this.getId());
    }

    public String toHtmW() {
        return ClassInfo.toHtmW(this.getId());
    }

    public String toHtmN() {
        return ClassInfo.toHtmN(this.getId());
    }

    static {
        neverSubclassed = EnumSet.of(Overlord, Warsmith);
        subclasseSet1 = EnumSet.of(DarkAvenger, Paladin, TempleKnight, ShillienKnight);
        subclasseSet2 = EnumSet.of(TreasureHunter, AbyssWalker, Plainswalker);
        subclasseSet3 = EnumSet.of(Hawkeye, SilverRanger, PhantomRanger);
        subclasseSet4 = EnumSet.of(Warlock, ElementalSummoner, PhantomSummoner);
        subclasseSet5 = EnumSet.of(Sorceror, Spellsinger, Spellhowler);
        subclassSetMap = new EnumMap(PlayerClass.class);
        EnumSet<PlayerClass> subclasses = PlayerClass.getSet(null, ClassLevel.Third);
        subclasses.removeAll(neverSubclassed);
        mainSubclassSet = subclasses;
        subclassSetMap.put(DarkAvenger, subclasseSet1);
        subclassSetMap.put(Paladin, subclasseSet1);
        subclassSetMap.put(TempleKnight, subclasseSet1);
        subclassSetMap.put(ShillienKnight, subclasseSet1);
        subclassSetMap.put(TreasureHunter, subclasseSet2);
        subclassSetMap.put(AbyssWalker, subclasseSet2);
        subclassSetMap.put(Plainswalker, subclasseSet2);
        subclassSetMap.put(Hawkeye, subclasseSet3);
        subclassSetMap.put(SilverRanger, subclasseSet3);
        subclassSetMap.put(PhantomRanger, subclasseSet3);
        subclassSetMap.put(Warlock, subclasseSet4);
        subclassSetMap.put(ElementalSummoner, subclasseSet4);
        subclassSetMap.put(PhantomSummoner, subclasseSet4);
        subclassSetMap.put(Sorceror, subclasseSet5);
        subclassSetMap.put(Spellsinger, subclasseSet5);
        subclassSetMap.put(Spellhowler, subclasseSet5);
    }
}

