/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.conditions;

import com.l2jserver.Config;
import com.l2jserver.gameserver.datatables.CharSummonTable;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.conditions.Condition;
import com.l2jserver.gameserver.model.stats.Env;
import com.l2jserver.gameserver.network.SystemMessageId;

public class ConditionPlayerCanSummon
extends Condition {
    private final boolean _val;

    public ConditionPlayerCanSummon(boolean val) {
        this._val = val;
    }

    @Override
    public boolean testImpl(Env env) {
        L2PcInstance player = env.getPlayer();
        if (player == null) {
            return false;
        }
        boolean canSummon = true;
        if (Config.RESTORE_SERVITOR_ON_RECONNECT && CharSummonTable.getInstance().getServitors().containsKey(player.getObjectId())) {
            player.sendPacket(SystemMessageId.SUMMON_ONLY_ONE);
            canSummon = false;
        } else if (Config.RESTORE_PET_ON_RECONNECT && CharSummonTable.getInstance().getPets().containsKey(player.getObjectId())) {
            player.sendPacket(SystemMessageId.SUMMON_ONLY_ONE);
            canSummon = false;
        } else if (player.hasSummon()) {
            player.sendPacket(SystemMessageId.SUMMON_ONLY_ONE);
            canSummon = false;
        } else if (player.isFlyingMounted() || player.isMounted()) {
            canSummon = false;
        }
        return this._val == canSummon;
    }
}

