/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.conditions;

import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.conditions.Condition;
import com.l2jserver.gameserver.model.stats.Env;
import com.l2jserver.gameserver.util.Util;

public class ConditionPlayerRangeFromNpc
extends Condition {
    private final int[] _npcIds;
    private final int _radius;
    private final boolean _val;

    public ConditionPlayerRangeFromNpc(int[] npcIds, int radius, boolean val) {
        this._npcIds = npcIds;
        this._radius = radius;
        this._val = val;
    }

    @Override
    public boolean testImpl(Env env) {
        if (this._npcIds != null && this._npcIds.length > 0 && this._radius > 0) {
            L2Character player = env.getCharacter();
            for (L2Object obj : player.getKnownList().getKnownObjects().values()) {
                if (!obj.isNpc() || !Util.contains(this._npcIds, ((L2Npc)obj).getId()) || !Util.checkIfInRange(this._radius, player, obj, true)) continue;
                return this._val;
            }
        }
        return !this._val;
    }
}

