/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.drops;

import com.l2jserver.gameserver.model.drops.CorpseDropItem;
import com.l2jserver.gameserver.model.drops.DeathDropItem;
import com.l2jserver.gameserver.model.drops.GeneralDropItem;
import com.l2jserver.gameserver.model.drops.GroupedCorpseDropItem;
import com.l2jserver.gameserver.model.drops.GroupedDeathDropItem;
import com.l2jserver.gameserver.model.drops.GroupedGeneralDropItem;
import com.l2jserver.gameserver.model.drops.IDropItem;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import java.util.logging.Logger;

public enum DropListScope {
    DEATH(DeathDropItem.class, GroupedDeathDropItem.class),
    CORPSE(CorpseDropItem.class, GroupedCorpseDropItem.class);

    private static final Logger _log;
    private final Class<? extends GeneralDropItem> _dropItemClass;
    private final Class<? extends GroupedGeneralDropItem> _groupedDropItemClass;

    private DropListScope(Class<? extends GeneralDropItem> dropItemClass, Class<? extends GroupedGeneralDropItem> groupedDropItemClass) {
        this._dropItemClass = dropItemClass;
        this._groupedDropItemClass = groupedDropItemClass;
    }

    public IDropItem newDropItem(int itemId, long min, long max, double chance) {
        Constructor<? extends GeneralDropItem> constructor;
        try {
            constructor = this._dropItemClass.getConstructor(Integer.TYPE, Long.TYPE, Long.TYPE, Double.TYPE);
        }
        catch (NoSuchMethodException | SecurityException e) {
            _log.log(Level.SEVERE, "Constructor(int, long, long, double) not found for " + this._dropItemClass.getSimpleName(), e);
            return null;
        }
        try {
            return constructor.newInstance(itemId, min, max, chance);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            _log.log(Level.SEVERE, "", e);
            return null;
        }
    }

    public GroupedGeneralDropItem newGroupedDropItem(double chance) {
        Constructor<? extends GroupedGeneralDropItem> constructor;
        try {
            constructor = this._groupedDropItemClass.getConstructor(Double.TYPE);
        }
        catch (NoSuchMethodException | SecurityException e) {
            _log.log(Level.SEVERE, "Constructor(double) not found for " + this._groupedDropItemClass.getSimpleName(), e);
            return null;
        }
        try {
            return constructor.newInstance(chance);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            _log.log(Level.SEVERE, "", e);
            return null;
        }
    }

    static {
        _log = Logger.getLogger(DropListScope.class.getName());
    }
}

