/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.holders;

import com.l2jserver.gameserver.datatables.SkillTreesData;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.interfaces.ISkillsHolder;
import com.l2jserver.gameserver.model.skills.Skill;
import jp.sf.l2j.troja.FastIntObjectMap;
import jp.sf.l2j.troja.IntObjectMap;

public class PlayerSkillHolder
implements ISkillsHolder {
    private final IntObjectMap<Skill> _skills = new FastIntObjectMap();

    public PlayerSkillHolder(L2PcInstance player) {
        for (Skill skill : player.getSkills().values()) {
            if (!SkillTreesData.getInstance().isSkillAllowed(player, skill)) continue;
            this.addSkill(skill);
        }
    }

    @Override
    public IntObjectMap<Skill> getSkills() {
        return this._skills;
    }

    @Override
    public Skill addSkill(Skill skill) {
        return (Skill)this._skills.put(skill.getId(), (Object)skill);
    }

    @Override
    public int getSkillLevel(int skillId) {
        Skill skill = this.getKnownSkill(skillId);
        return skill == null ? -1 : skill.getLevel();
    }

    @Override
    public Skill getKnownSkill(int skillId) {
        return (Skill)this._skills.get(skillId);
    }
}

