/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.quest;

import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.quest.Quest;
import com.l2jserver.gameserver.model.quest.QuestState;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class QuestTimer {
    protected static final Logger _log = Logger.getLogger(QuestTimer.class.getName());
    private boolean _isActive = true;
    private final String _name;
    private final Quest _quest;
    private final L2Npc _npc;
    private final L2PcInstance _player;
    private final boolean _isRepeating;
    private ScheduledFuture<?> _schedular;
    private int _instanceId;

    public QuestTimer(Quest quest, String name, long time, L2Npc npc, L2PcInstance player, boolean repeating, boolean withFixedDelay) {
        this._name = name;
        this._quest = quest;
        this._player = player;
        this._npc = npc;
        this._isRepeating = repeating;
        if (npc != null) {
            this._instanceId = npc.getInstanceId();
        } else if (player != null) {
            this._instanceId = player.getInstanceId();
        }
        this._schedular = repeating ? (withFixedDelay ? ThreadPoolManager.getInstance().scheduleGeneralWithFixedDelay(new ScheduleTimerTask(), time, time) : ThreadPoolManager.getInstance().scheduleGeneralAtFixedRate(new ScheduleTimerTask(), time, time)) : ThreadPoolManager.getInstance().scheduleGeneral(new ScheduleTimerTask(), time);
    }

    public QuestTimer(Quest quest, String name, long time, L2Npc npc, L2PcInstance player) {
        this(quest, name, time, npc, player, false, false);
    }

    public QuestTimer(QuestState qs, String name, long time) {
        this(qs.getQuest(), name, time, null, qs.getPlayer(), false, false);
    }

    public void cancel() {
        this._isActive = false;
        if (this._schedular != null) {
            this._schedular.cancel(false);
        }
    }

    public void cancelAndRemove() {
        this.cancel();
        this._quest.removeQuestTimer(this);
    }

    public boolean isMatch(Quest quest, String name, L2Npc npc, L2PcInstance player) {
        if (quest == null || name == null) {
            return false;
        }
        if (quest != this._quest || !name.equalsIgnoreCase(this.getName())) {
            return false;
        }
        return npc == this._npc && player == this._player;
    }

    public final boolean getIsActive() {
        return this._isActive;
    }

    public final boolean getIsRepeating() {
        return this._isRepeating;
    }

    public final Quest getQuest() {
        return this._quest;
    }

    public final String getName() {
        return this._name;
    }

    public final L2Npc getNpc() {
        return this._npc;
    }

    public final L2PcInstance getPlayer() {
        return this._player;
    }

    public final int getInstanceId() {
        return this._instanceId;
    }

    public final long getRemainDelay() {
        return this._schedular == null ? 0L : this._schedular.getDelay(TimeUnit.MILLISECONDS);
    }

    public final String toString() {
        return this._name;
    }

    public class ScheduleTimerTask
    implements Runnable {
        @Override
        public void run() {
            if (!QuestTimer.this.getIsActive()) {
                return;
            }
            try {
                if (!QuestTimer.this.getIsRepeating()) {
                    QuestTimer.this.cancelAndRemove();
                }
                QuestTimer.this.getQuest().notifyEvent(QuestTimer.this.getName(), QuestTimer.this.getNpc(), QuestTimer.this.getPlayer());
            }
            catch (Exception e) {
                _log.log(Level.SEVERE, "", e);
            }
        }
    }
}

