/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.zone.type;

import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.zone.L2ZoneType;
import com.l2jserver.gameserver.model.zone.ZoneId;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;

public class L2MotherTreeZone
extends L2ZoneType {
    private int _enterMsg;
    private int _leaveMsg;
    private int _mpRegen;
    private int _hpRegen;

    public L2MotherTreeZone(int id) {
        super(id);
    }

    @Override
    public void setParameter(String name, String value) {
        if (name.equals("enterMsgId")) {
            this._enterMsg = Integer.parseInt(value);
        } else if (name.equals("leaveMsgId")) {
            this._leaveMsg = Integer.parseInt(value);
        } else if (name.equals("MpRegenBonus")) {
            this._mpRegen = Integer.parseInt(value);
        } else if (name.equals("HpRegenBonus")) {
            this._hpRegen = Integer.parseInt(value);
        } else {
            super.setParameter(name, value);
        }
    }

    @Override
    protected void onEnter(L2Character character) {
        if (character.isPlayer()) {
            L2PcInstance player = character.getActingPlayer();
            character.setInsideZone(ZoneId.MOTHER_TREE, true);
            if (this._enterMsg != 0) {
                player.sendPacket(SystemMessage.getSystemMessage(this._enterMsg));
            }
        }
    }

    @Override
    protected void onExit(L2Character character) {
        if (character.isPlayer()) {
            L2PcInstance player = character.getActingPlayer();
            player.setInsideZone(ZoneId.MOTHER_TREE, false);
            if (this._leaveMsg != 0) {
                player.sendPacket(SystemMessage.getSystemMessage(this._leaveMsg));
            }
        }
    }

    public int getMpRegenBonus() {
        return this._mpRegen;
    }

    public int getHpRegenBonus() {
        return this._hpRegen;
    }
}

