/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.Config;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.CharDeleteFail;
import com.l2jserver.gameserver.network.serverpackets.CharDeleteSuccess;
import com.l2jserver.gameserver.network.serverpackets.CharSelectionInfo;
import com.l2jserver.gameserver.scripting.scriptengine.events.PlayerEvent;
import com.l2jserver.gameserver.scripting.scriptengine.listeners.player.PlayerListener;
import java.util.List;
import java.util.logging.Level;
import javolution.util.FastList;

public final class CharacterDelete
extends L2GameClientPacket {
    private static final String _C__0C_CHARACTERDELETE = "[C] 0D CharacterDelete";
    private static final List<PlayerListener> _listeners = new FastList().shared();
    private int _charSlot;

    @Override
    protected void readImpl() {
        this._charSlot = this.readD();
    }

    @Override
    protected void runImpl() {
        if (!((L2GameClient)this.getClient()).getFloodProtectors().getCharacterSelect().tryPerformAction("CharacterDelete")) {
            this.sendPacket(new CharDeleteFail(1));
            return;
        }
        if (Config.DEBUG) {
            _log.fine("deleting slot:" + this._charSlot);
        }
        try {
            byte answer = ((L2GameClient)this.getClient()).markToDeleteChar(this._charSlot);
            switch (answer) {
                default: {
                    break;
                }
                case 0: {
                    this.sendPacket(new CharDeleteSuccess());
                    PlayerEvent event = new PlayerEvent();
                    event.setClient((L2GameClient)this.getClient());
                    event.setObjectId(((L2GameClient)this.getClient()).getCharSelection(this._charSlot).getObjectId());
                    event.setName(((L2GameClient)this.getClient()).getCharSelection(this._charSlot).getName());
                    this.firePlayerListener(event);
                    break;
                }
                case 1: {
                    this.sendPacket(new CharDeleteFail(2));
                    break;
                }
                case 2: {
                    this.sendPacket(new CharDeleteFail(3));
                    break;
                }
            }
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Error:", e);
        }
        CharSelectionInfo cl = new CharSelectionInfo(((L2GameClient)this.getClient()).getAccountName(), ((L2GameClient)this.getClient()).getSessionId().playOkID1, 0);
        this.sendPacket(cl);
        ((L2GameClient)this.getClient()).setCharSelection(cl.getCharInfo());
    }

    private void firePlayerListener(PlayerEvent event) {
        for (PlayerListener listener : _listeners) {
            listener.onCharDelete(event);
        }
    }

    public static void addPlayerListener(PlayerListener listener) {
        if (!_listeners.contains(listener)) {
            _listeners.add(listener);
        }
    }

    public static void removePlayerListener(PlayerListener listener) {
        _listeners.remove(listener);
    }

    @Override
    public String getType() {
        return _C__0C_CHARACTERDELETE;
    }
}

