/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.Config;
import com.l2jserver.gameserver.datatables.AdminTable;
import com.l2jserver.gameserver.enums.PlayerAction;
import com.l2jserver.gameserver.handler.AdminCommandHandler;
import com.l2jserver.gameserver.handler.IAdminCommandHandler;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.holders.DoorRequestHolder;
import com.l2jserver.gameserver.model.holders.SummonRequestHolder;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.util.GMAudit;

public final class DlgAnswer
extends L2GameClientPacket {
    private static final String _C__C6_DLGANSWER = "[C] C6 DlgAnswer";
    private int _messageId;
    private int _answer;
    private int _requesterId;

    @Override
    protected void readImpl() {
        this._messageId = this.readD();
        this._answer = this.readD();
        this._requesterId = this.readD();
    }

    @Override
    public void runImpl() {
        DoorRequestHolder holder;
        L2PcInstance activeChar = ((L2GameClient)this.getClient()).getActiveChar();
        if (activeChar == null) {
            return;
        }
        if (!activeChar.getEvents().onDlgAnswer(this._messageId, this._answer, this._requesterId)) {
            return;
        }
        if (this._messageId == SystemMessageId.S1.getId()) {
            if (activeChar.removeAction(PlayerAction.USER_ENGAGE)) {
                if (Config.L2JMOD_ALLOW_WEDDING) {
                    activeChar.engageAnswer(this._answer);
                }
            } else if (activeChar.removeAction(PlayerAction.ADMIN_COMMAND)) {
                String cmd = activeChar.getAdminConfirmCmd();
                activeChar.setAdminConfirmCmd(null);
                if (this._answer == 0) {
                    return;
                }
                String command = cmd.split(" ")[0];
                IAdminCommandHandler ach = AdminCommandHandler.getInstance().getHandler(command);
                if (AdminTable.getInstance().hasAccess(command, activeChar.getAccessLevel())) {
                    if (Config.GMAUDIT) {
                        GMAudit.auditGMAction(activeChar.getName() + " [" + activeChar.getObjectId() + "]", cmd, activeChar.getTarget() != null ? activeChar.getTarget().getName() : "no-target");
                    }
                    ach.useAdminCommand(cmd, activeChar);
                }
            }
        } else if (this._messageId == SystemMessageId.RESURRECTION_REQUEST_BY_C1_FOR_S2_XP.getId() || this._messageId == SystemMessageId.RESURRECT_USING_CHARM_OF_COURAGE.getId()) {
            activeChar.reviveAnswer(this._answer);
        } else if (this._messageId == SystemMessageId.C1_WISHES_TO_SUMMON_YOU_FROM_S2_DO_YOU_ACCEPT.getId()) {
            SummonRequestHolder holder2 = activeChar.removeScript(SummonRequestHolder.class);
            if (this._answer == 1 && holder2 != null && holder2.getTarget().getObjectId() == this._requesterId) {
                activeChar.teleToLocation(holder2.getTarget().getPosition(), true);
            }
        } else if (this._messageId == SystemMessageId.WOULD_YOU_LIKE_TO_OPEN_THE_GATE.getId()) {
            DoorRequestHolder holder3 = activeChar.removeScript(DoorRequestHolder.class);
            if (holder3 != null && holder3.getDoor() == activeChar.getTarget() && this._answer == 1) {
                holder3.getDoor().openMe();
            }
        } else if (this._messageId == SystemMessageId.WOULD_YOU_LIKE_TO_CLOSE_THE_GATE.getId() && (holder = activeChar.removeScript(DoorRequestHolder.class)) != null && holder.getDoor() == activeChar.getTarget() && this._answer == 1) {
            holder.getDoor().closeMe();
        }
    }

    @Override
    public String getType() {
        return _C__C6_DLGANSWER;
    }
}

