/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.Config;
import com.l2jserver.gameserver.enums.PrivateStoreType;
import com.l2jserver.gameserver.model.Elementals;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.ExAttributeEnchantResult;
import com.l2jserver.gameserver.network.serverpackets.ExBrExtraUserInfo;
import com.l2jserver.gameserver.network.serverpackets.InventoryUpdate;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.network.serverpackets.UserInfo;
import com.l2jserver.gameserver.util.Util;
import com.l2jserver.util.Rnd;

public class RequestExEnchantItemAttribute
extends L2GameClientPacket {
    private static final String _C__D0_35_REQUESTEXENCHANTITEMATTRIBUTE = "[C] D0:35 RequestExEnchantItemAttribute";
    private int _objectId;

    @Override
    protected void readImpl() {
        this._objectId = this.readD();
    }

    @Override
    protected void runImpl() {
        int newPower;
        L2PcInstance player = this.getActiveChar();
        if (player == null) {
            return;
        }
        if (this._objectId == -1) {
            player.setActiveEnchantAttrItemId(-1);
            player.sendPacket(SystemMessageId.ELEMENTAL_ENHANCE_CANCELED);
            return;
        }
        if (!player.isOnline()) {
            player.setActiveEnchantAttrItemId(-1);
            return;
        }
        if (player.getPrivateStoreType() != PrivateStoreType.NONE) {
            player.sendPacket(SystemMessageId.CANNOT_ADD_ELEMENTAL_POWER_WHILE_OPERATING_PRIVATE_STORE_OR_WORKSHOP);
            player.setActiveEnchantAttrItemId(-1);
            return;
        }
        if (player.getActiveRequester() != null) {
            player.cancelActiveTrade();
            player.setActiveEnchantAttrItemId(-1);
            player.sendMessage("You cannot add elemental power while trading.");
            return;
        }
        L2ItemInstance item = player.getInventory().getItemByObjectId(this._objectId);
        L2ItemInstance stone = player.getInventory().getItemByObjectId(player.getActiveEnchantAttrItemId());
        if (item == null || stone == null) {
            player.setActiveEnchantAttrItemId(-1);
            player.sendPacket(SystemMessageId.ELEMENTAL_ENHANCE_CANCELED);
            return;
        }
        if (!item.isElementable()) {
            player.sendPacket(SystemMessageId.ELEMENTAL_ENHANCE_REQUIREMENT_NOT_SUFFICIENT);
            player.setActiveEnchantAttrItemId(-1);
            return;
        }
        switch (item.getItemLocation()) {
            case INVENTORY: 
            case PAPERDOLL: {
                if (item.getOwnerId() == player.getObjectId()) break;
                player.setActiveEnchantAttrItemId(-1);
                return;
            }
            default: {
                player.setActiveEnchantAttrItemId(-1);
                Util.handleIllegalPlayerAction(player, "Player " + player.getName() + " tried to use enchant Exploit!", Config.DEFAULT_PUNISH);
                return;
            }
        }
        int stoneId = stone.getId();
        byte elementToAdd = Elementals.getItemElement(stoneId);
        if (item.isArmor()) {
            elementToAdd = Elementals.getOppositeElement(elementToAdd);
        }
        byte opositeElement = Elementals.getOppositeElement(elementToAdd);
        Elementals oldElement = item.getElemental(elementToAdd);
        int elementValue = oldElement == null ? 0 : oldElement.getValue();
        int limit = this.getLimit(item, stoneId);
        int powerToAdd = this.getPowerToAdd(stoneId, elementValue, item);
        if (item.isWeapon() && oldElement != null && oldElement.getElement() != elementToAdd && oldElement.getElement() != -2 || item.isArmor() && item.getElemental(elementToAdd) == null && item.getElementals() != null && item.getElementals().length >= 3) {
            player.sendPacket(SystemMessageId.ANOTHER_ELEMENTAL_POWER_ALREADY_ADDED);
            player.setActiveEnchantAttrItemId(-1);
            return;
        }
        if (item.isArmor() && item.getElementals() != null) {
            for (Elementals elm : item.getElementals()) {
                if (elm.getElement() != opositeElement) continue;
                player.setActiveEnchantAttrItemId(-1);
                Util.handleIllegalPlayerAction(player, "Player " + player.getName() + " tried to add oposite attribute to item!", Config.DEFAULT_PUNISH);
                return;
            }
        }
        if ((newPower = elementValue + powerToAdd) > limit) {
            newPower = limit;
            powerToAdd = limit - elementValue;
        }
        if (powerToAdd <= 0) {
            player.sendPacket(SystemMessageId.ELEMENTAL_ENHANCE_CANCELED);
            player.setActiveEnchantAttrItemId(-1);
            return;
        }
        if (!player.destroyItem("AttrEnchant", stone, 1L, (L2Object)player, true)) {
            player.sendPacket(SystemMessageId.NOT_ENOUGH_ITEMS);
            Util.handleIllegalPlayerAction(player, "Player " + player.getName() + " tried to attribute enchant with a stone he doesn't have", Config.DEFAULT_PUNISH);
            player.setActiveEnchantAttrItemId(-1);
            return;
        }
        boolean success = false;
        switch (Elementals.getItemElemental((int)stoneId)._type) {
            case Stone: 
            case Roughore: {
                success = (double)Rnd.get(100) < Config.ENCHANT_CHANCE_ELEMENT_STONE;
                break;
            }
            case Crystal: {
                success = (double)Rnd.get(100) < Config.ENCHANT_CHANCE_ELEMENT_CRYSTAL;
                break;
            }
            case Jewel: {
                success = (double)Rnd.get(100) < Config.ENCHANT_CHANCE_ELEMENT_JEWEL;
                break;
            }
            case Energy: {
                boolean bl = success = (double)Rnd.get(100) < Config.ENCHANT_CHANCE_ELEMENT_ENERGY;
            }
        }
        if (success) {
            SystemMessage sm;
            byte realElement;
            byte by = realElement = item.isArmor() ? opositeElement : elementToAdd;
            if (item.getEnchantLevel() == 0) {
                sm = item.isArmor() ? SystemMessage.getSystemMessage(SystemMessageId.THE_S2_ATTRIBUTE_WAS_SUCCESSFULLY_BESTOWED_ON_S1_RES_TO_S3_INCREASED) : SystemMessage.getSystemMessage(SystemMessageId.ELEMENTAL_POWER_S2_SUCCESSFULLY_ADDED_TO_S1);
                sm.addItemName(item);
                sm.addElemental(realElement);
                if (item.isArmor()) {
                    sm.addElemental(Elementals.getOppositeElement(realElement));
                }
            } else {
                sm = item.isArmor() ? SystemMessage.getSystemMessage(SystemMessageId.THE_S3_ATTRIBUTE_BESTOWED_ON_S1_S2_RESISTANCE_TO_S4_INCREASED) : SystemMessage.getSystemMessage(SystemMessageId.ELEMENTAL_POWER_S3_SUCCESSFULLY_ADDED_TO_S1_S2);
                sm.addInt(item.getEnchantLevel());
                sm.addItemName(item);
                sm.addElemental(realElement);
                if (item.isArmor()) {
                    sm.addElemental(Elementals.getOppositeElement(realElement));
                }
            }
            player.sendPacket(sm);
            item.setElementAttr(elementToAdd, newPower);
            if (item.isEquipped()) {
                item.updateElementAttrBonus(player);
            }
            InventoryUpdate iu = new InventoryUpdate();
            iu.addModifiedItem(item);
            player.sendPacket(iu);
        } else {
            player.sendPacket(SystemMessageId.FAILED_ADDING_ELEMENTAL_POWER);
        }
        player.sendPacket(new ExAttributeEnchantResult(powerToAdd));
        player.sendPacket(new UserInfo(player));
        player.sendPacket(new ExBrExtraUserInfo(player));
        player.setActiveEnchantAttrItemId(-1);
    }

    public int getLimit(L2ItemInstance item, int sotneId) {
        Elementals.ElementalItems elementItem = Elementals.getItemElemental(sotneId);
        if (elementItem == null) {
            return 0;
        }
        if (item.isWeapon()) {
            return Elementals.WEAPON_VALUES[elementItem._type._maxLevel];
        }
        return Elementals.ARMOR_VALUES[elementItem._type._maxLevel];
    }

    public int getPowerToAdd(int stoneId, int oldValue, L2ItemInstance item) {
        if (Elementals.getItemElement(stoneId) != -1) {
            if (item.isWeapon()) {
                if (oldValue == 0) {
                    return 20;
                }
                return 5;
            }
            if (item.isArmor()) {
                return 6;
            }
        }
        return 0;
    }

    @Override
    public String getType() {
        return _C__D0_35_REQUESTEXENCHANTITEMATTRIBUTE;
    }
}

