/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.gameserver.datatables.EnchantItemData;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.items.enchant.EnchantScroll;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.ExPutEnchantTargetItemResult;
import java.util.logging.Level;

public class RequestExTryToPutEnchantTargetItem
extends L2GameClientPacket {
    private static final String _C__D0_4C_REQUESTEXTRYTOPUTENCHANTTARGETITEM = "[C] D0:4C RequestExTryToPutEnchantTargetItem";
    private int _objectId;

    @Override
    protected void readImpl() {
        this._objectId = this.readD();
    }

    @Override
    protected void runImpl() {
        L2PcInstance activeChar = ((L2GameClient)this.getClient()).getActiveChar();
        if (this._objectId == 0 || activeChar == null) {
            return;
        }
        if (activeChar.isEnchanting()) {
            return;
        }
        L2ItemInstance item = activeChar.getInventory().getItemByObjectId(this._objectId);
        L2ItemInstance scroll = activeChar.getInventory().getItemByObjectId(activeChar.getActiveEnchantItemId());
        if (item == null || scroll == null) {
            return;
        }
        EnchantScroll scrollTemplate = EnchantItemData.getInstance().getEnchantScroll(scroll);
        if (scrollTemplate == null || !scrollTemplate.isValid(item, null)) {
            activeChar.sendPacket(SystemMessageId.DOES_NOT_FIT_SCROLL_CONDITIONS);
            activeChar.setActiveEnchantItemId(-1);
            activeChar.sendPacket(new ExPutEnchantTargetItemResult(0));
            if (scrollTemplate == null) {
                _log.log(Level.WARNING, ((Object)((Object)this)).getClass().getSimpleName() + ": Undefined scroll have been used id: " + scroll.getId());
            }
            return;
        }
        activeChar.setIsEnchanting(true);
        activeChar.setActiveEnchantTimestamp(System.currentTimeMillis());
        activeChar.sendPacket(new ExPutEnchantTargetItemResult(this._objectId));
    }

    @Override
    public String getType() {
        return _C__D0_4C_REQUESTEXTRYTOPUTENCHANTTARGETITEM;
    }
}

