/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.instancemanager.CHSiegeManager;
import com.l2jserver.gameserver.instancemanager.CastleManager;
import com.l2jserver.gameserver.instancemanager.ClanHallManager;
import com.l2jserver.gameserver.instancemanager.FortManager;
import com.l2jserver.gameserver.instancemanager.MapRegionManager;
import com.l2jserver.gameserver.instancemanager.TerritoryWarManager;
import com.l2jserver.gameserver.model.Location;
import com.l2jserver.gameserver.model.TeleportWhereType;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.entity.Castle;
import com.l2jserver.gameserver.model.interfaces.ILocational;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;

public final class RequestRestartPoint
extends L2GameClientPacket {
    private static final String _C__7D_REQUESTRESTARTPOINT = "[C] 7D RequestRestartPoint";
    protected int _requestedPointType;
    protected boolean _continuation;

    @Override
    protected void readImpl() {
        this._requestedPointType = this.readD();
    }

    @Override
    protected void runImpl() {
        L2PcInstance activeChar = ((L2GameClient)this.getClient()).getActiveChar();
        if (activeChar == null) {
            return;
        }
        if (!activeChar.canRevive()) {
            return;
        }
        if (activeChar.isFakeDeath()) {
            activeChar.stopFakeDeath(true);
            return;
        }
        if (!activeChar.isDead()) {
            _log.warning("Living player [" + activeChar.getName() + "] called RestartPointPacket! Ban this player!");
            return;
        }
        Castle castle = CastleManager.getInstance().getCastle(activeChar.getX(), activeChar.getY(), activeChar.getZ());
        if (castle != null && castle.getSiege().getIsInProgress() && activeChar.getClan() != null && castle.getSiege().checkIsAttacker(activeChar.getClan())) {
            ThreadPoolManager.getInstance().scheduleGeneral(new DeathTask(activeChar), castle.getSiege().getAttackerRespawnDelay());
            if (castle.getSiege().getAttackerRespawnDelay() > 0) {
                activeChar.sendMessage("You will be re-spawned in " + castle.getSiege().getAttackerRespawnDelay() / 1000 + " seconds");
            }
            return;
        }
        this.portPlayer(activeChar);
    }

    /*
     * Unable to fully structure code
     */
    protected final void portPlayer(L2PcInstance activeChar) {
        loc = null;
        castle = null;
        fort = null;
        hall = null;
        isInDefense = false;
        instanceId = 0;
        if (activeChar.isJailed()) {
            this._requestedPointType = 27;
        } else if (activeChar.isFestivalParticipant()) {
            this._requestedPointType = 5;
        }
        switch (this._requestedPointType) {
            case 1: {
                if (activeChar.getClan() == null || activeChar.getClan().getHideoutId() == 0) {
                    RequestRestartPoint._log.warning("Player [" + activeChar.getName() + "] called RestartPointPacket - To Clanhall and he doesn't have Clanhall!");
                    return;
                }
                loc = MapRegionManager.getInstance().getTeleToLocation(activeChar, TeleportWhereType.CLANHALL);
                if (ClanHallManager.getInstance().getClanHallByOwner(activeChar.getClan()) == null || ClanHallManager.getInstance().getClanHallByOwner(activeChar.getClan()).getFunction(5) == null) break;
                activeChar.restoreExp(ClanHallManager.getInstance().getClanHallByOwner(activeChar.getClan()).getFunction(5).getLvl());
                break;
            }
            case 2: {
                castle = CastleManager.getInstance().getCastle(activeChar);
                if (castle == null || !castle.getSiege().getIsInProgress()) ** GOTO lbl32
                if (castle.getSiege().checkIsDefender(activeChar.getClan())) {
                    loc = MapRegionManager.getInstance().getTeleToLocation(activeChar, TeleportWhereType.CASTLE);
                } else if (castle.getSiege().checkIsAttacker(activeChar.getClan())) {
                    loc = MapRegionManager.getInstance().getTeleToLocation(activeChar, TeleportWhereType.TOWN);
                } else {
                    RequestRestartPoint._log.warning("Player [" + activeChar.getName() + "] called RestartPointPacket - To Castle and he doesn't have Castle!");
                    return;
lbl32:
                    // 1 sources

                    if (activeChar.getClan() == null || activeChar.getClan().getCastleId() == 0) {
                        return;
                    }
                    loc = MapRegionManager.getInstance().getTeleToLocation(activeChar, TeleportWhereType.CASTLE);
                }
                if (CastleManager.getInstance().getCastleByOwner(activeChar.getClan()) == null || CastleManager.getInstance().getCastleByOwner(activeChar.getClan()).getFunction(4) == null) break;
                activeChar.restoreExp(CastleManager.getInstance().getCastleByOwner(activeChar.getClan()).getFunction(4).getLvl());
                break;
            }
            case 3: {
                if (!(activeChar.getClan() != null && activeChar.getClan().getFortId() != 0 || isInDefense)) {
                    RequestRestartPoint._log.warning("Player [" + activeChar.getName() + "] called RestartPointPacket - To Fortress and he doesn't have Fortress!");
                    return;
                }
                loc = MapRegionManager.getInstance().getTeleToLocation(activeChar, TeleportWhereType.FORTRESS);
                if (FortManager.getInstance().getFortByOwner(activeChar.getClan()) == null || FortManager.getInstance().getFortByOwner(activeChar.getClan()).getFunction(4) == null) break;
                activeChar.restoreExp(FortManager.getInstance().getFortByOwner(activeChar.getClan()).getFunction(4).getLvl());
                break;
            }
            case 4: {
                siegeClan = null;
                castle = CastleManager.getInstance().getCastle(activeChar);
                fort = FortManager.getInstance().getFort(activeChar);
                hall = CHSiegeManager.getInstance().getNearbyClanHall(activeChar);
                flag = TerritoryWarManager.getInstance().getFlagForClan(activeChar.getClan());
                if (castle != null && castle.getSiege().getIsInProgress()) {
                    siegeClan = castle.getSiege().getAttackerClan(activeChar.getClan());
                } else if (fort != null && fort.getSiege().getIsInProgress()) {
                    siegeClan = fort.getSiege().getAttackerClan(activeChar.getClan());
                } else if (hall != null && hall.isInSiege()) {
                    siegeClan = hall.getSiege().getAttackerClan(activeChar.getClan());
                }
                if ((siegeClan == null || siegeClan.getFlag().isEmpty()) && flag == null) {
                    if (hall != null && (loc = hall.getSiege().getInnerSpawnLoc(activeChar)) != null) break;
                    RequestRestartPoint._log.warning("Player [" + activeChar.getName() + "] called RestartPointPacket - To Siege HQ and he doesn't have Siege HQ!");
                    return;
                }
                loc = MapRegionManager.getInstance().getTeleToLocation(activeChar, TeleportWhereType.SIEGEFLAG);
                break;
            }
            case 5: {
                if (!activeChar.isGM() && !activeChar.isFestivalParticipant()) {
                    RequestRestartPoint._log.warning("Player [" + activeChar.getName() + "] called RestartPointPacket - Fixed and he isn't festival participant!");
                    return;
                }
                if (activeChar.isGM()) {
                    activeChar.doRevive(100.0);
                    break;
                }
                instanceId = activeChar.getInstanceId();
                loc = new Location(activeChar);
                break;
            }
            case 6: {
                break;
            }
            case 27: {
                if (!activeChar.isJailed()) {
                    return;
                }
                loc = new Location(-114356, -249645, -2984);
                break;
            }
            default: {
                loc = MapRegionManager.getInstance().getTeleToLocation(activeChar, TeleportWhereType.TOWN);
            }
        }
        if (loc != null) {
            activeChar.setInstanceId(instanceId);
            activeChar.setIsIn7sDungeon(false);
            activeChar.setIsPendingRevive(true);
            activeChar.teleToLocation((ILocational)loc, true);
        }
    }

    @Override
    public String getType() {
        return _C__7D_REQUESTRESTARTPOINT;
    }

    class DeathTask
    implements Runnable {
        final L2PcInstance activeChar;

        DeathTask(L2PcInstance _activeChar) {
            this.activeChar = _activeChar;
        }

        @Override
        public void run() {
            RequestRestartPoint.this.portPlayer(this.activeChar);
        }
    }
}

