/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.serverpackets;

import com.l2jserver.gameserver.model.itemauction.ItemAuction;
import com.l2jserver.gameserver.model.itemauction.ItemAuctionBid;
import com.l2jserver.gameserver.model.itemauction.ItemAuctionState;
import com.l2jserver.gameserver.network.serverpackets.AbstractItemPacket;

public final class ExItemAuctionInfoPacket
extends AbstractItemPacket {
    private final boolean _refresh;
    private final int _timeRemaining;
    private final ItemAuction _currentAuction;
    private final ItemAuction _nextAuction;

    public ExItemAuctionInfoPacket(boolean refresh, ItemAuction currentAuction, ItemAuction nextAuction) {
        if (currentAuction == null) {
            throw new NullPointerException();
        }
        this._timeRemaining = currentAuction.getAuctionState() != ItemAuctionState.STARTED ? 0 : (int)(currentAuction.getFinishingTimeRemaining() / 1000L);
        this._refresh = refresh;
        this._currentAuction = currentAuction;
        this._nextAuction = nextAuction;
    }

    @Override
    protected void writeImpl() {
        this.writeC(254);
        this.writeH(104);
        this.writeC(this._refresh ? 0 : 1);
        this.writeD(this._currentAuction.getInstanceId());
        ItemAuctionBid highestBid = this._currentAuction.getHighestBid();
        this.writeQ(highestBid != null ? highestBid.getLastBid() : this._currentAuction.getAuctionInitBid());
        this.writeD(this._timeRemaining);
        this.writeItem(this._currentAuction.getItemInfo());
        if (this._nextAuction != null) {
            this.writeQ(this._nextAuction.getAuctionInitBid());
            this.writeD((int)(this._nextAuction.getStartingTime() / 1000L));
            this.writeItem(this._nextAuction.getItemInfo());
        }
    }
}

