/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.serverpackets;

import com.l2jserver.Config;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.stats.Stats;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;

public class ExStorageMaxCount
extends L2GameServerPacket {
    private final int _inventory;
    private final int _warehouse;
    private final int _clan;
    private final int _privateSell;
    private final int _privateBuy;
    private final int _receipeD;
    private final int _recipe;
    private final int _inventoryExtraSlots;
    private final int _inventoryQuestItems;

    public ExStorageMaxCount(L2PcInstance activeChar) {
        this._inventory = activeChar.getInventoryLimit();
        this._warehouse = activeChar.getWareHouseLimit();
        this._privateSell = activeChar.getPrivateSellStoreLimit();
        this._privateBuy = activeChar.getPrivateBuyStoreLimit();
        this._clan = Config.WAREHOUSE_SLOTS_CLAN;
        this._receipeD = activeChar.getDwarfRecipeLimit();
        this._recipe = activeChar.getCommonRecipeLimit();
        this._inventoryExtraSlots = (int)activeChar.getStat().calcStat(Stats.INV_LIM, 0.0, null, null);
        this._inventoryQuestItems = Config.INVENTORY_MAXIMUM_QUEST_ITEMS;
    }

    @Override
    protected void writeImpl() {
        this.writeC(254);
        this.writeH(47);
        this.writeD(this._inventory);
        this.writeD(this._warehouse);
        this.writeD(this._clan);
        this.writeD(this._privateSell);
        this.writeD(this._privateBuy);
        this.writeD(this._receipeD);
        this.writeD(this._recipe);
        this.writeD(this._inventoryExtraSlots);
        this.writeD(this._inventoryQuestItems);
    }
}

