/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.serverpackets;

import com.l2jserver.gameserver.datatables.CharNameTable;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import java.util.List;
import javolution.util.FastList;

public class FriendList
extends L2GameServerPacket {
    private final List<FriendInfo> _info;

    public FriendList(L2PcInstance player) {
        this._info = new FastList(player.getFriendList().size());
        for (int objId : player.getFriendList()) {
            String name = CharNameTable.getInstance().getNameById(objId);
            L2PcInstance player1 = L2World.getInstance().getPlayer(objId);
            boolean online = false;
            if (player1 != null && player1.isOnline()) {
                online = true;
            }
            this._info.add(new FriendInfo(objId, name, online));
        }
    }

    @Override
    protected final void writeImpl() {
        this.writeC(117);
        this.writeD(this._info.size());
        for (FriendInfo info : this._info) {
            this.writeD(info._objId);
            this.writeS(info._name);
            this.writeD(info._online ? 1 : 0);
            this.writeD(info._online ? info._objId : 0);
        }
    }

    private static class FriendInfo {
        int _objId;
        String _name;
        boolean _online;

        public FriendInfo(int objId, String name, boolean online) {
            this._objId = objId;
            this._name = name;
            this._online = online;
        }
    }
}

