/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.scripting;

import com.l2jserver.Config;
import com.l2jserver.gameserver.scripting.L2ScriptEngineManager;
import com.l2jserver.gameserver.scripting.ScriptManager;
import java.io.File;
import javax.script.ScriptException;

public abstract class ManagedScript {
    private final File _scriptFile = L2ScriptEngineManager.getInstance().getCurrentLoadingScript();
    private long _lastLoadTime;
    private boolean _isActive;

    public ManagedScript() {
        this.setLastLoadTime(System.currentTimeMillis());
    }

    public boolean reload() {
        try {
            L2ScriptEngineManager.getInstance().executeScript(this.getScriptFile());
            return true;
        }
        catch (ScriptException e) {
            return false;
        }
    }

    public abstract boolean unload();

    public void setActive(boolean status) {
        this._isActive = status;
    }

    public boolean isActive() {
        return this._isActive;
    }

    public File getScriptFile() {
        return this._scriptFile;
    }

    public String getScriptDirectory() {
        return this._scriptFile.getPath().substring(0, this._scriptFile.getPath().lastIndexOf(File.separatorChar) + 1).substring(Config.DATAPACK_ROOT.getPath().length() + 1).replace('\\', '/');
    }

    protected void setLastLoadTime(long lastLoadTime) {
        this._lastLoadTime = lastLoadTime;
    }

    protected long getLastLoadTime() {
        return this._lastLoadTime;
    }

    public abstract String getScriptName();

    public abstract ScriptManager<?> getScriptManager();
}

