/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.scripting;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.Formatter;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Native2Ascii {
    private final String _encoding;
    private final Pattern _patternCoding = Pattern.compile("coding[=:]\\s*[\"']?([-\\w.]+)");
    private StringBuilder asciiBuffer = new StringBuilder(4096);
    private final FileFilter _fileFilter = new FileFilter(){

        @Override
        public boolean accept(File file) {
            String fileName = file.getName();
            char c0 = fileName.charAt(0);
            if (c0 == '.' || c0 == '#') {
                return false;
            }
            if (file.isDirectory()) {
                return true;
            }
            return fileName.endsWith(".java") || fileName.endsWith(".js") || fileName.endsWith(".py");
        }
    };

    public Native2Ascii(File scriptsDirectory, String encoding) {
        this._encoding = encoding;
        this.run(scriptsDirectory);
    }

    private void run(File scriptsDirectory) {
        File[] files = scriptsDirectory.listFiles(this._fileFilter);
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (file.isDirectory()) {
                this.run(file);
                continue;
            }
            if (!file.isFile()) continue;
            String encoding = this._encoding;
            try {
                FileInputStream fis = new FileInputStream(file);
                byte[] byteBuffer = new byte[fis.available()];
                fis.read(byteBuffer);
                fis.close();
                if (byteBuffer.length >= 3 && byteBuffer[0] == -17 && byteBuffer[1] == -69 && byteBuffer[2] == -65) {
                    encoding = "UTF-8";
                } else {
                    Matcher m = this._patternCoding.matcher(new String(byteBuffer, StandardCharsets.ISO_8859_1));
                    if (m.find()) {
                        encoding = m.group(1);
                    }
                }
                char[] unicodeBuffer = new String(byteBuffer, encoding).toCharArray();
                this.asciiBuffer.setLength(0);
                Formatter fm = new Formatter(this.asciiBuffer);
                boolean modify = false;
                int i = 0;
                int length = unicodeBuffer.length;
                if (file.getPath().endsWith(".java") && unicodeBuffer[i] == '\ufeff') {
                    ++i;
                    modify = true;
                }
                while (i < length) {
                    char unicode;
                    if ((unicode = unicodeBuffer[i++]) >= '\u0080') {
                        fm.format("\\u%04x", unicode);
                        modify = true;
                        continue;
                    }
                    this.asciiBuffer.append(unicode);
                }
                if (!modify) continue;
                if (file.getPath().endsWith(".py")) {
                    this.jythonInsertU();
                }
                String asciiString = this.asciiBuffer.toString();
                long mtime = file.lastModified();
                OutputStreamWriter osw = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.US_ASCII);
                osw.write(asciiString);
                osw.close();
                file.setLastModified(mtime);
            }
            catch (IOException e) {
                Logger.getLogger("Native2Ascii").warning(file.getAbsoluteFile() + " [" + encoding + "] - " + e.toString());
                e.printStackTrace();
            }
        }
    }

    private void jythonInsertU() {
        int length = this.asciiBuffer.length();
        char[] ca = new char[length];
        this.asciiBuffer.getChars(0, length, ca, 0);
        this.asciiBuffer.setLength(0);
        int i = 0;
        block0: while (i < length) {
            char ch;
            if ((ch = ca[i++]) == '#') {
                this.asciiBuffer.append(ch);
                while (i < length) {
                    if ((ch = ca[i++]) == '\r' || ch == '\n') {
                        --i;
                        break;
                    }
                    this.asciiBuffer.append(ch);
                }
                while (i < length) {
                    if ((ch = ca[i++]) != '\r' && ch != '\n') {
                        --i;
                        continue block0;
                    }
                    this.asciiBuffer.append(ch);
                }
                continue;
            }
            if (ch == '\"' || ch == '\'') {
                char quote = ch;
                int start = this.asciiBuffer.length();
                boolean hasUnicodeEscape = false;
                this.asciiBuffer.append(ch);
                while (i < length) {
                    if ((ch = ca[i++]) == '\\') {
                        if (i + 4 < length && ca[i] == 'u' && this.isHex(ca[i + 1]) && this.isHex(ca[i + 2]) && this.isHex(ca[i + 3]) && this.isHex(ca[i + 4])) {
                            hasUnicodeEscape = true;
                        }
                        this.asciiBuffer.append(ch).append(ca[i++]);
                        continue;
                    }
                    if (ch == quote) {
                        this.asciiBuffer.append(ch);
                        if (!hasUnicodeEscape || this.asciiBuffer.charAt(start - 1) == 'u') continue block0;
                        this.asciiBuffer.insert(start, 'u');
                        continue block0;
                    }
                    this.asciiBuffer.append(ch);
                }
                continue;
            }
            this.asciiBuffer.append(ch);
        }
    }

    private boolean isHex(char c) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F';
    }
}

