/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.scripting.scriptengine.impl;

import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Playable;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.quest.Quest;
import com.l2jserver.gameserver.model.skills.Skill;
import com.l2jserver.gameserver.scripting.scriptengine.events.AddToInventoryEvent;
import com.l2jserver.gameserver.scripting.scriptengine.events.AttackEvent;
import com.l2jserver.gameserver.scripting.scriptengine.events.AugmentEvent;
import com.l2jserver.gameserver.scripting.scriptengine.events.ChatEvent;
import com.l2jserver.gameserver.scripting.scriptengine.events.ClanCreationEvent;
import com.l2jserver.gameserver.scripting.scriptengine.events.ClanJoinEvent;
import com.l2jserver.gameserver.scripting.scriptengine.events.ClanLeaderChangeEvent;
import com.l2jserver.gameserver.scripting.scriptengine.events.ClanLeaveEvent;
import com.l2jserver.gameserver.scripting.scriptengine.events.ClanLevelUpEvent;
import com.l2jserver.gameserver.scripting.scriptengine.events.ClanWarEvent;
import com.l2jserver.gameserver.scripting.scriptengine.events.ClanWarehouseAddItemEvent;
import com.l2jserver.gameserver.scripting.scriptengine.events.ClanWarehouseDeleteItemEvent;
import com.l2jserver.gameserver.scripting.scriptengine.events.ClanWarehouseTransferEvent;
import com.l2jserver.gameserver.scripting.scriptengine.events.DeathEvent;
import com.l2jserver.gameserver.scripting.scriptengine.events.DlgAnswerEvent;
import com.l2jserver.gameserver.scripting.scriptengine.events.EquipmentEvent;
import com.l2jserver.gameserver.scripting.scriptengine.events.FortSiegeEvent;
import com.l2jserver.gameserver.scripting.scriptengine.events.HennaEvent;
import com.l2jserver.gameserver.scripting.scriptengine.events.ItemCreateEvent;
import com.l2jserver.gameserver.scripting.scriptengine.events.ItemDestroyEvent;
import com.l2jserver.gameserver.scripting.scriptengine.events.ItemDropEvent;
import com.l2jserver.gameserver.scripting.scriptengine.events.ItemPickupEvent;
import com.l2jserver.gameserver.scripting.scriptengine.events.ItemTransferEvent;
import com.l2jserver.gameserver.scripting.scriptengine.events.PlayerEvent;
import com.l2jserver.gameserver.scripting.scriptengine.events.PlayerLevelChangeEvent;
import com.l2jserver.gameserver.scripting.scriptengine.events.ProfessionChangeEvent;
import com.l2jserver.gameserver.scripting.scriptengine.events.RequestBypassToServerEvent;
import com.l2jserver.gameserver.scripting.scriptengine.events.SiegeEvent;
import com.l2jserver.gameserver.scripting.scriptengine.events.SkillUseEvent;
import com.l2jserver.gameserver.scripting.scriptengine.events.TransformEvent;
import com.l2jserver.gameserver.scripting.scriptengine.events.TvtKillEvent;
import com.l2jserver.gameserver.scripting.scriptengine.events.impl.L2Event;
import com.l2jserver.gameserver.scripting.scriptengine.impl.L2JListener;
import com.l2jserver.gameserver.scripting.scriptengine.listeners.character.AttackListener;
import com.l2jserver.gameserver.scripting.scriptengine.listeners.character.DeathListener;
import com.l2jserver.gameserver.scripting.scriptengine.listeners.character.SkillUseListener;
import com.l2jserver.gameserver.scripting.scriptengine.listeners.clan.ClanCreationListener;
import com.l2jserver.gameserver.scripting.scriptengine.listeners.clan.ClanMembershipListener;
import com.l2jserver.gameserver.scripting.scriptengine.listeners.clan.ClanWarListener;
import com.l2jserver.gameserver.scripting.scriptengine.listeners.clan.ClanWarehouseListener;
import com.l2jserver.gameserver.scripting.scriptengine.listeners.events.FortSiegeListener;
import com.l2jserver.gameserver.scripting.scriptengine.listeners.events.SiegeListener;
import com.l2jserver.gameserver.scripting.scriptengine.listeners.events.TvTListener;
import com.l2jserver.gameserver.scripting.scriptengine.listeners.player.AugmentListener;
import com.l2jserver.gameserver.scripting.scriptengine.listeners.player.DropListener;
import com.l2jserver.gameserver.scripting.scriptengine.listeners.player.EquipmentListener;
import com.l2jserver.gameserver.scripting.scriptengine.listeners.player.HennaListener;
import com.l2jserver.gameserver.scripting.scriptengine.listeners.player.ItemTracker;
import com.l2jserver.gameserver.scripting.scriptengine.listeners.player.NewItemListener;
import com.l2jserver.gameserver.scripting.scriptengine.listeners.player.PlayerDespawnListener;
import com.l2jserver.gameserver.scripting.scriptengine.listeners.player.PlayerLevelListener;
import com.l2jserver.gameserver.scripting.scriptengine.listeners.player.PlayerListener;
import com.l2jserver.gameserver.scripting.scriptengine.listeners.player.PlayerSpawnListener;
import com.l2jserver.gameserver.scripting.scriptengine.listeners.player.ProfessionChangeListener;
import com.l2jserver.gameserver.scripting.scriptengine.listeners.player.TransformListener;
import com.l2jserver.gameserver.scripting.scriptengine.listeners.talk.ChatFilterListener;
import com.l2jserver.gameserver.scripting.scriptengine.listeners.talk.ChatListener;
import com.l2jserver.gameserver.scripting.scriptengine.listeners.talk.DlgAnswerListener;
import com.l2jserver.gameserver.scripting.scriptengine.listeners.talk.RequestBypassToServerListener;
import java.util.ArrayList;
import java.util.List;

public abstract class L2Script
extends Quest {
    private final List<L2JListener> _listeners = new ArrayList<L2JListener>();

    public L2Script(String name, String descr) {
        super(-1, name, descr);
    }

    public L2Script(int questId, String name, String descr) {
        super(questId, name, descr);
    }

    @Override
    public boolean unload() {
        for (L2JListener listener : this._listeners) {
            listener.unregister();
        }
        this._listeners.clear();
        return super.unload();
    }

    private void removeListeners(List<L2JListener> removeList) {
        for (L2JListener listener : removeList) {
            listener.unregister();
            this._listeners.remove(listener);
        }
    }

    public void addDeathNotify(L2Character character) {
        DeathListener listener = new DeathListener(character){

            @Override
            public boolean onDeath(L2Character attacker, L2Character target) {
                DeathEvent event = new DeathEvent();
                event.setKiller(attacker);
                event.setVictim(target);
                return L2Script.this.onDeath(event);
            }
        };
        this._listeners.add(listener);
    }

    public void removeDeathNotify(L2Character character) {
        ArrayList<L2JListener> removeList = new ArrayList<L2JListener>();
        for (L2JListener listener : this._listeners) {
            if (!(listener instanceof DeathListener) || ((DeathListener)listener).getCharacter() != character) continue;
            removeList.add(listener);
        }
        this.removeListeners(removeList);
    }

    public void addLoginLogoutNotify() {
        PlayerSpawnListener spawn = new PlayerSpawnListener(){

            @Override
            public void onPlayerLogin(L2PcInstance player) {
                L2Script.this.onPlayerLogin(player);
            }
        };
        PlayerDespawnListener despawn = new PlayerDespawnListener(){

            @Override
            public void onPlayerLogout(L2PcInstance player) {
                L2Script.this.onPlayerLogout(player);
            }
        };
        this._listeners.add(spawn);
        this._listeners.add(despawn);
    }

    public void removeLoginLogoutNotify() {
        ArrayList<L2JListener> removeList = new ArrayList<L2JListener>();
        for (L2JListener listener : this._listeners) {
            if (!(listener instanceof PlayerSpawnListener) && !(listener instanceof PlayerDespawnListener)) continue;
            removeList.add(listener);
        }
        this.removeListeners(removeList);
    }

    public void addAttackNotify(L2Character character) {
        AttackListener listener = new AttackListener(character){

            @Override
            public boolean onAttack(L2Character attacker, L2Character target) {
                AttackEvent event = new AttackEvent();
                event.setAttacker(attacker);
                event.setTarget(target);
                return L2Script.this.onAttack(event);
            }
        };
        this._listeners.add(listener);
    }

    public void removeAttackNotify(L2Character character) {
        ArrayList<L2JListener> removeList = new ArrayList<L2JListener>();
        for (L2JListener listener : this._listeners) {
            if (!(listener instanceof AttackListener) || ((AttackListener)listener).getCharacter() != character) continue;
            removeList.add(listener);
        }
        this.removeListeners(removeList);
    }

    public void addSkillUseNotify(L2Character character) {
        SkillUseListener listener = new SkillUseListener(character){

            @Override
            public boolean onSkillUse(L2Character caster, Skill skill, boolean simultaneously, L2Character target, L2Object[] targets) {
                SkillUseEvent event = new SkillUseEvent();
                event.setCaster(caster);
                event.setSkill(skill);
                event.setTarget(target);
                event.setTargets(targets);
                return L2Script.this.onSkillUse(event);
            }
        };
        this._listeners.add(listener);
    }

    public void removeSkillUseNotify(L2Character character) {
        ArrayList<L2JListener> removeList = new ArrayList<L2JListener>();
        for (L2JListener listener : this._listeners) {
            if (!(listener instanceof SkillUseListener) || ((SkillUseListener)listener).getCharacter() != character) continue;
            removeList.add(listener);
        }
        this.removeListeners(removeList);
    }

    public void addClanCreationLevelUpNotify() {
        ClanCreationListener listener = new ClanCreationListener(){

            @Override
            public void onClanCreate(ClanCreationEvent event) {
                L2Script.this.onClanCreated(event);
            }

            @Override
            public boolean onClanLevelUp(ClanLevelUpEvent event) {
                return L2Script.this.onClanLeveledUp(event);
            }
        };
        this._listeners.add(listener);
    }

    public void removeClanCreationLevelUpNotify() {
        ArrayList<L2JListener> removeList = new ArrayList<L2JListener>();
        for (L2JListener listener : this._listeners) {
            if (!(listener instanceof ClanCreationListener)) continue;
            removeList.add(listener);
        }
        this.removeListeners(removeList);
    }

    public void addClanJoinLeaveNotify() {
        ClanMembershipListener listener = new ClanMembershipListener(){

            @Override
            public boolean onJoin(ClanJoinEvent event) {
                return L2Script.this.onClanJoin(event);
            }

            @Override
            public boolean onLeaderChange(ClanLeaderChangeEvent event) {
                return L2Script.this.onClanLeaderChange(event);
            }

            @Override
            public boolean onLeave(ClanLeaveEvent event) {
                return L2Script.this.onClanLeave(event);
            }
        };
        this._listeners.add(listener);
    }

    public void removeClanJoinLeaveNotify() {
        ArrayList<L2JListener> removeList = new ArrayList<L2JListener>();
        for (L2JListener listener : this._listeners) {
            if (!(listener instanceof ClanMembershipListener)) continue;
            removeList.add(listener);
        }
        this.removeListeners(removeList);
    }

    public void addClanWarehouseNotify(L2Clan clan) {
        if (clan != null) {
            ClanWarehouseListener listener = new ClanWarehouseListener(clan){

                @Override
                public boolean onAddItem(ClanWarehouseAddItemEvent event) {
                    return L2Script.this.onClanWarehouseAddItem(event);
                }

                @Override
                public boolean onDeleteItem(ClanWarehouseDeleteItemEvent event) {
                    return L2Script.this.onClanWarehouseDeleteItem(event);
                }

                @Override
                public boolean onTransferItem(ClanWarehouseTransferEvent event) {
                    return L2Script.this.onClanWarehouseTransferItem(event);
                }
            };
            this._listeners.add(listener);
        }
    }

    public void removeClanWarehouseNotify(L2Clan clan) {
        if (clan != null) {
            ArrayList<L2JListener> removeList = new ArrayList<L2JListener>();
            for (L2JListener listener : this._listeners) {
                if (!(listener instanceof ClanWarehouseListener) || ((ClanWarehouseListener)listener).getWarehouse() != clan.getWarehouse()) continue;
                removeList.add(listener);
            }
            this.removeListeners(removeList);
        }
    }

    public void addClanWarNotify() {
        ClanWarListener listener = new ClanWarListener(){

            @Override
            public boolean onWarStart(ClanWarEvent event) {
                event.setStage(EventStage.START);
                return L2Script.this.onClanWarEvent(event);
            }

            @Override
            public boolean onWarEnd(ClanWarEvent event) {
                event.setStage(EventStage.END);
                return L2Script.this.onClanWarEvent(event);
            }
        };
        this._listeners.add(listener);
    }

    public void removeClanWarNotify() {
        ArrayList<L2JListener> removeList = new ArrayList<L2JListener>();
        for (L2JListener listener : this._listeners) {
            if (!(listener instanceof ClanWarListener)) continue;
            removeList.add(listener);
        }
        this.removeListeners(removeList);
    }

    public void addFortSiegeNotify() {
        FortSiegeListener listener = new FortSiegeListener(){

            @Override
            public boolean onStart(FortSiegeEvent event) {
                event.setStage(EventStage.START);
                return L2Script.this.onFortSiegeEvent(event);
            }

            @Override
            public void onEnd(FortSiegeEvent event) {
                event.setStage(EventStage.END);
                L2Script.this.onFortSiegeEvent(event);
            }
        };
        this._listeners.add(listener);
    }

    public void removeFortSiegeNotify() {
        ArrayList<L2JListener> removeList = new ArrayList<L2JListener>();
        for (L2JListener listener : this._listeners) {
            if (!(listener instanceof FortSiegeListener)) continue;
            removeList.add(listener);
        }
        this.removeListeners(removeList);
    }

    public void addSiegeNotify() {
        SiegeListener listener = new SiegeListener(){

            @Override
            public boolean onStart(SiegeEvent event) {
                event.setStage(EventStage.START);
                return L2Script.this.onSiegeEvent(event);
            }

            @Override
            public void onEnd(SiegeEvent event) {
                event.setStage(EventStage.END);
                L2Script.this.onSiegeEvent(event);
            }

            @Override
            public void onControlChange(SiegeEvent event) {
                L2Script.this.onCastleControlChange(event);
            }
        };
        this._listeners.add(listener);
    }

    public void removeSiegeNotify() {
        ArrayList<L2JListener> removeList = new ArrayList<L2JListener>();
        for (L2JListener listener : this._listeners) {
            if (!(listener instanceof SiegeListener)) continue;
            removeList.add(listener);
        }
        this.removeListeners(removeList);
    }

    public void addTvTNotify() {
        TvTListener listener = new TvTListener(){

            @Override
            public void onBegin() {
                L2Script.this.onTvtEvent(EventStage.START);
            }

            @Override
            public void onKill(TvtKillEvent event) {
                L2Script.this.onTvtKill(event);
            }

            @Override
            public void onEnd() {
                L2Script.this.onTvtEvent(EventStage.END);
            }

            @Override
            public void onRegistrationStart() {
                L2Script.this.onTvtEvent(EventStage.REGISTRATION_BEGIN);
            }
        };
        this._listeners.add(listener);
    }

    public void removeTvtNotify() {
        ArrayList<L2JListener> removeList = new ArrayList<L2JListener>();
        for (L2JListener listener : this._listeners) {
            if (!(listener instanceof TvTListener)) continue;
            removeList.add(listener);
        }
        this.removeListeners(removeList);
    }

    public void addItemAugmentNotify() {
        AugmentListener listener = new AugmentListener(){

            @Override
            public boolean onAugment(AugmentEvent event) {
                return L2Script.this.onItemAugment(event);
            }

            @Override
            public boolean onRemoveAugment(AugmentEvent event) {
                return L2Script.this.onItemAugment(event);
            }
        };
        this._listeners.add(listener);
    }

    public void removeItemAugmentNotify() {
        ArrayList<L2JListener> removeList = new ArrayList<L2JListener>();
        for (L2JListener listener : this._listeners) {
            if (!(listener instanceof AugmentListener)) continue;
            removeList.add(listener);
        }
        this.removeListeners(removeList);
    }

    public void addItemDropPickupNotify() {
        DropListener listener = new DropListener(){

            @Override
            public boolean onDrop(ItemDropEvent event) {
                return L2Script.this.onItemDrop(event);
            }

            @Override
            public boolean onPickup(ItemPickupEvent event) {
                return L2Script.this.onItemPickup(event);
            }
        };
        this._listeners.add(listener);
    }

    public void removeItemDropPickupNotify() {
        ArrayList<L2JListener> removeList = new ArrayList<L2JListener>();
        for (L2JListener listener : this._listeners) {
            if (!(listener instanceof DropListener)) continue;
            removeList.add(listener);
        }
        this.removeListeners(removeList);
    }

    public void addPlayerLevelNotify(L2PcInstance player) {
        PlayerLevelListener listener = new PlayerLevelListener(player){

            @Override
            public boolean onLevelChange(L2Playable playable, byte levels) {
                PlayerLevelChangeEvent event = new PlayerLevelChangeEvent();
                event.setPlayer(playable.getActingPlayer());
                event.setOldLevel(playable.getLevel());
                event.setNewLevel(playable.getLevel() + levels);
                return L2Script.this.onLevelChange(event);
            }
        };
        this._listeners.add(listener);
    }

    public void removePlayerLevelNotify(L2PcInstance player) {
        ArrayList<L2JListener> removeList = new ArrayList<L2JListener>();
        for (L2JListener listener : this._listeners) {
            if (!(listener instanceof PlayerLevelListener) || listener.getPlayer() != player) continue;
            removeList.add(listener);
        }
        this.removeListeners(removeList);
    }

    public void addProfessionChangeNotify(L2PcInstance player) {
        ProfessionChangeListener listener = new ProfessionChangeListener(player){

            @Override
            public void professionChanged(ProfessionChangeEvent event) {
                L2Script.this.onProfessionChange(event);
            }
        };
        this._listeners.add(listener);
    }

    public void removeProfessionChangeNotify(L2PcInstance player) {
        ArrayList<L2JListener> removeList = new ArrayList<L2JListener>();
        for (L2JListener listener : this._listeners) {
            if (!(listener instanceof ProfessionChangeListener) || listener.getPlayer() != player) continue;
            removeList.add(listener);
        }
        this.removeListeners(removeList);
    }

    public void addEquipmentNotify(L2PcInstance player) {
        EquipmentListener listener = new EquipmentListener(player){

            @Override
            public boolean onEquip(EquipmentEvent event) {
                return L2Script.this.onItemEquip(event);
            }
        };
        this._listeners.add(listener);
    }

    public void removeEquipmentNotify(L2PcInstance player) {
        ArrayList<L2JListener> removeList = new ArrayList<L2JListener>();
        for (L2JListener listener : this._listeners) {
            if (!(listener instanceof EquipmentListener) || ((EquipmentListener)listener).getPlayer() != player) continue;
            removeList.add(listener);
        }
        this.removeListeners(removeList);
    }

    public void addHennaNotify() {
        HennaListener listener = new HennaListener(){

            @Override
            public boolean onAddHenna(HennaEvent event) {
                return L2Script.this.onHennaModify(event);
            }

            @Override
            public boolean onRemoveHenna(HennaEvent event) {
                return L2Script.this.onHennaModify(event);
            }
        };
        this._listeners.add(listener);
    }

    public void removeHennaNotify() {
        ArrayList<L2JListener> removeList = new ArrayList<L2JListener>();
        for (L2JListener listener : this._listeners) {
            if (!(listener instanceof HennaListener)) continue;
            removeList.add(listener);
        }
        this.removeListeners(removeList);
    }

    public void addItemTracker(List<Integer> itemIds) {
        if (itemIds != null) {
            ItemTracker listener = new ItemTracker(itemIds){

                @Override
                public void onDrop(ItemDropEvent event) {
                    L2Script.this.onItemTrackerEvent(event);
                }

                @Override
                public void onAddToInventory(AddToInventoryEvent event) {
                    L2Script.this.onItemTrackerEvent(event);
                }

                @Override
                public void onDestroy(ItemDestroyEvent event) {
                    L2Script.this.onItemTrackerEvent(event);
                }

                @Override
                public void onTransfer(ItemTransferEvent event) {
                    L2Script.this.onItemTrackerEvent(event);
                }
            };
            this._listeners.add(listener);
        }
    }

    public void removeItemTrackers() {
        ArrayList<L2JListener> removeList = new ArrayList<L2JListener>();
        for (L2JListener listener : this._listeners) {
            if (!(listener instanceof ItemTracker)) continue;
            removeList.add(listener);
        }
        this.removeListeners(removeList);
    }

    public void addNewItemNotify(List<Integer> itemIds) {
        if (itemIds != null) {
            NewItemListener listener = new NewItemListener(itemIds){

                @Override
                public boolean onCreate(ItemCreateEvent event) {
                    return L2Script.this.onItemCreate(event);
                }
            };
            this._listeners.add(listener);
        }
    }

    public void removeNewItemNotify() {
        ArrayList<L2JListener> removeList = new ArrayList<L2JListener>();
        for (L2JListener listener : this._listeners) {
            if (!(listener instanceof NewItemListener)) continue;
            removeList.add(listener);
        }
        this.removeListeners(removeList);
    }

    public void addTransformNotify(L2PcInstance player) {
        if (player != null) {
            TransformListener listener = new TransformListener(player){

                @Override
                public boolean onTransform(TransformEvent event) {
                    event.setTransforming(true);
                    return L2Script.this.onPlayerTransform(event);
                }

                @Override
                public boolean onUntransform(TransformEvent event) {
                    return L2Script.this.onPlayerTransform(event);
                }
            };
            this._listeners.add(listener);
        }
    }

    public void removeTransformNotify(L2PcInstance player) {
        if (player != null) {
            ArrayList<L2JListener> removeList = new ArrayList<L2JListener>();
            for (L2JListener listener : this._listeners) {
                if (!(listener instanceof TransformListener) || listener.getPlayer() != player) continue;
                removeList.add(listener);
            }
            this.removeListeners(removeList);
        }
    }

    public void addPlayerChatFilter() {
        ChatFilterListener listener = new ChatFilterListener(){

            @Override
            public String onTalk(ChatEvent event) {
                return L2Script.this.filterChat(event);
            }
        };
        this._listeners.add(listener);
    }

    public void removePlayerChatFilter() {
        ArrayList<L2JListener> removeList = new ArrayList<L2JListener>();
        for (L2JListener listener : this._listeners) {
            if (!(listener instanceof ChatFilterListener)) continue;
            removeList.add(listener);
        }
        this.removeListeners(removeList);
    }

    public void addPlayerTalkNotify() {
        ChatListener listener = new ChatListener(){

            @Override
            public void onTalk(ChatEvent event) {
                L2Script.this.onPlayerTalk(event);
            }
        };
        this._listeners.add(listener);
    }

    public void removePlayerTalkNotify() {
        ArrayList<L2JListener> removeList = new ArrayList<L2JListener>();
        for (L2JListener listener : this._listeners) {
            if (!(listener instanceof ChatListener)) continue;
            removeList.add(listener);
        }
        this.removeListeners(removeList);
    }

    public void addDlgAnswerNotify(L2PcInstance player) {
        DlgAnswerListener dlgAnswer = new DlgAnswerListener(player){

            @Override
            public boolean onDlgAnswer(L2PcInstance player, int messageId, int answer, int requesterId) {
                DlgAnswerEvent event = new DlgAnswerEvent();
                event.setActiveChar(player);
                event.setMessageId(messageId);
                event.setAnswer(answer);
                event.setRequesterId(requesterId);
                return L2Script.this.onDlgAnswer(event);
            }
        };
        this._listeners.add(dlgAnswer);
    }

    public void removeDlgAnswerNotify() {
        ArrayList<L2JListener> removeList = new ArrayList<L2JListener>();
        for (L2JListener listener : this._listeners) {
            if (!(listener instanceof DlgAnswerListener)) continue;
            removeList.add(listener);
        }
        this.removeListeners(removeList);
    }

    public void removeDlgAnswerNotify(L2PcInstance player) {
        ArrayList<L2JListener> removeList = new ArrayList<L2JListener>();
        for (L2JListener listener : this._listeners) {
            if (!(listener instanceof DlgAnswerListener) || ((DlgAnswerListener)listener).getPlayer() != player) continue;
            removeList.add(listener);
        }
        this.removeListeners(removeList);
    }

    public void addRequestBypassToServerNotify() {
        RequestBypassToServerListener bypass = new RequestBypassToServerListener(){

            @Override
            public void onRequestBypassToServer(RequestBypassToServerEvent event) {
                L2Script.this.onRequestBypassToServer(event);
            }
        };
        this._listeners.add(bypass);
    }

    public void removeRequestBypassToServerNotify() {
        ArrayList<L2JListener> removeList = new ArrayList<L2JListener>();
        for (L2JListener listener : this._listeners) {
            if (!(listener instanceof DlgAnswerListener)) continue;
            removeList.add(listener);
        }
        this.removeListeners(removeList);
    }

    public void addPlayerNotify() {
        PlayerListener bypass = new PlayerListener(){

            @Override
            public void onCharCreate(PlayerEvent event) {
                L2Script.this.onCharCreate(event);
            }

            @Override
            public void onCharDelete(PlayerEvent event) {
                L2Script.this.onCharDelete(event);
            }

            @Override
            public void onCharRestore(PlayerEvent event) {
                L2Script.this.onCharRestore(event);
            }

            @Override
            public void onCharSelect(PlayerEvent event) {
                L2Script.this.onCharSelect(event);
            }
        };
        this._listeners.add(bypass);
    }

    public void removePlayerNotify() {
        ArrayList<L2JListener> removeList = new ArrayList<L2JListener>();
        for (L2JListener listener : this._listeners) {
            if (!(listener instanceof PlayerListener)) continue;
            removeList.add(listener);
        }
        this.removeListeners(removeList);
    }

    public void onPlayerLogin(L2PcInstance player) {
    }

    public void onPlayerLogout(L2PcInstance player) {
    }

    public boolean onAttack(AttackEvent event) {
        return true;
    }

    public boolean onDeath(DeathEvent event) {
        return true;
    }

    public boolean onSkillUse(SkillUseEvent event) {
        return true;
    }

    public void onClanCreated(ClanCreationEvent event) {
    }

    public boolean onClanLeveledUp(ClanLevelUpEvent event) {
        return true;
    }

    public boolean onClanJoin(ClanJoinEvent event) {
        return true;
    }

    public boolean onClanLeave(ClanLeaveEvent event) {
        return true;
    }

    public boolean onClanLeaderChange(ClanLeaderChangeEvent event) {
        return true;
    }

    public boolean onClanWarehouseAddItem(ClanWarehouseAddItemEvent event) {
        return true;
    }

    public boolean onClanWarehouseDeleteItem(ClanWarehouseDeleteItemEvent event) {
        return true;
    }

    public boolean onClanWarehouseTransferItem(ClanWarehouseTransferEvent event) {
        return true;
    }

    public boolean onClanWarEvent(ClanWarEvent event) {
        return true;
    }

    public boolean onFortSiegeEvent(FortSiegeEvent event) {
        return true;
    }

    public boolean onSiegeEvent(SiegeEvent event) {
        return true;
    }

    public void onCastleControlChange(SiegeEvent event) {
    }

    public void onTvtEvent(EventStage stage) {
    }

    public void onTvtKill(TvtKillEvent event) {
    }

    public boolean onItemAugment(AugmentEvent event) {
        return true;
    }

    public boolean onItemDrop(ItemDropEvent event) {
        return true;
    }

    public boolean onItemPickup(ItemPickupEvent event) {
        return true;
    }

    public boolean onItemEquip(EquipmentEvent event) {
        return true;
    }

    public boolean onLevelChange(PlayerLevelChangeEvent event) {
        return true;
    }

    public void onProfessionChange(ProfessionChangeEvent event) {
    }

    public boolean onHennaModify(HennaEvent event) {
        return true;
    }

    public void onItemTrackerEvent(L2Event event) {
    }

    public boolean onItemCreate(ItemCreateEvent event) {
        return true;
    }

    public boolean onPlayerTransform(TransformEvent event) {
        return true;
    }

    public String filterChat(ChatEvent event) {
        return "";
    }

    public void onPlayerTalk(ChatEvent event) {
    }

    public boolean onDlgAnswer(DlgAnswerEvent event) {
        return true;
    }

    protected void onRequestBypassToServer(RequestBypassToServerEvent event) {
    }

    protected void onCharSelect(PlayerEvent event) {
    }

    protected void onCharCreate(PlayerEvent event) {
    }

    protected void onCharDelete(PlayerEvent event) {
    }

    protected void onCharRestore(PlayerEvent event) {
    }

    public static enum ItemTrackerEvent {
        DROP,
        ADD_TO_INVENTORY,
        DESTROY,
        TRANSFER;

    }

    public static enum EventStage {
        START,
        END,
        EVENT_STOPPED,
        REGISTRATION_BEGIN,
        CONTROL_CHANGE;

    }
}

