/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.util;

import com.l2jserver.Config;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.datatables.NpcData;
import com.l2jserver.gameserver.idfactory.IdFactory;
import com.l2jserver.gameserver.model.L2MinionData;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2MonsterInstance;
import com.l2jserver.gameserver.model.actor.templates.L2NpcTemplate;
import com.l2jserver.util.Rnd;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javolution.util.FastList;
import javolution.util.FastSet;

public class MinionList {
    private static Logger _log = Logger.getLogger(MinionList.class.getName());
    protected final L2MonsterInstance _master;
    private final List<L2MonsterInstance> _minionReferences;
    protected List<L2MonsterInstance> _reusedMinionReferences = null;

    public MinionList(L2MonsterInstance pMaster) {
        if (pMaster == null) {
            throw new NullPointerException("MinionList: master is null");
        }
        this._master = pMaster;
        this._minionReferences = new FastList().shared();
    }

    public List<L2MonsterInstance> getSpawnedMinions() {
        return this._minionReferences;
    }

    public final void spawnMinions() {
        if (this._master.isAlikeDead()) {
            return;
        }
        List<L2MinionData> minions = this._master.getTemplate().getMinionData();
        if (minions == null) {
            return;
        }
        for (L2MinionData minion : minions) {
            int minionId;
            int minionCount = minion.getAmount();
            int minionsToSpawn = minionCount - this.countSpawnedMinionsById(minionId = minion.getMinionId());
            if (minionsToSpawn <= 0) continue;
            for (int i = 0; i < minionsToSpawn; ++i) {
                this.spawnMinion(minionId);
            }
        }
        this.deleteReusedMinions();
    }

    public void deleteSpawnedMinions() {
        if (!this._minionReferences.isEmpty()) {
            for (L2MonsterInstance minion : this._minionReferences) {
                if (minion == null) continue;
                minion.setLeader(null);
                minion.deleteMe();
                if (this._reusedMinionReferences == null) continue;
                this._reusedMinionReferences.add(minion);
            }
            this._minionReferences.clear();
        }
    }

    public void deleteReusedMinions() {
        if (this._reusedMinionReferences != null) {
            this._reusedMinionReferences.clear();
        }
    }

    public void onMasterSpawn() {
        this.deleteSpawnedMinions();
        if (this._reusedMinionReferences == null && this._master.getTemplate().getMinionData() != null && this._master.getSpawn() != null && this._master.getSpawn().isRespawnEnabled()) {
            this._reusedMinionReferences = new FastList().shared();
        }
    }

    public void onMinionSpawn(L2MonsterInstance minion) {
        this._minionReferences.add(minion);
    }

    public void onMasterDie(boolean force) {
        if (this._master.isRaid() || force) {
            this.deleteSpawnedMinions();
        }
    }

    public void onMinionDie(L2MonsterInstance minion, int respawnTime) {
        int time;
        minion.setLeader(null);
        this._minionReferences.remove(minion);
        if (this._reusedMinionReferences != null) {
            this._reusedMinionReferences.add(minion);
        }
        int n = respawnTime >= 0 ? respawnTime : (time = this._master.isRaid() ? Config.RAID_MINION_RESPAWN_TIMER : 0);
        if (time > 0 && !this._master.isAlikeDead()) {
            ThreadPoolManager.getInstance().scheduleGeneral(new MinionRespawnTask(minion), time);
        }
    }

    public void onAssist(L2Character caller, L2Character attacker) {
        int aggro;
        if (attacker == null) {
            return;
        }
        if (!this._master.isAlikeDead() && !this._master.isInCombat()) {
            this._master.addDamageHate(attacker, 0, 1);
        }
        boolean callerIsMaster = caller == this._master;
        int n = aggro = callerIsMaster ? 10 : 1;
        if (this._master.isRaid()) {
            aggro *= 10;
        }
        for (L2MonsterInstance minion : this._minionReferences) {
            if (minion == null || minion.isDead() || !callerIsMaster && minion.isInCombat()) continue;
            minion.addDamageHate(attacker, 0, aggro);
        }
    }

    public void onMasterTeleported() {
        int offset = 200;
        int minRadius = (int)this._master.getCollisionRadius() + 30;
        for (L2MonsterInstance minion : this._minionReferences) {
            if (minion == null || minion.isDead() || minion.isMovementDisabled()) continue;
            double distance = Rnd.get(minRadius, 200);
            double angle = Rnd.nextDouble() * (Math.PI * 2);
            int newX = this._master.getX() + (int)(distance * Math.cos(angle));
            int newY = this._master.getY() + (int)(distance * Math.sin(angle));
            minion.teleToLocation(newX, newY, this._master.getZ());
        }
    }

    private final void spawnMinion(int minionId) {
        if (minionId == 0) {
            return;
        }
        if (this._reusedMinionReferences != null && !this._reusedMinionReferences.isEmpty()) {
            Iterator<L2MonsterInstance> iter = this._reusedMinionReferences.iterator();
            while (iter.hasNext()) {
                L2MonsterInstance minion = iter.next();
                if (minion == null || minion.getId() != minionId) continue;
                iter.remove();
                minion.refreshID();
                MinionList.initializeNpcInstance(this._master, minion);
                return;
            }
        }
        MinionList.spawnMinion(this._master, minionId);
    }

    public static final L2MonsterInstance spawnMinion(L2MonsterInstance master, int minionId) {
        L2NpcTemplate minionTemplate = NpcData.getInstance().getTemplate(minionId);
        if (minionTemplate == null) {
            return null;
        }
        L2MonsterInstance minion = new L2MonsterInstance(IdFactory.getInstance().getNextId(), minionTemplate);
        return MinionList.initializeNpcInstance(master, minion);
    }

    protected static final L2MonsterInstance initializeNpcInstance(L2MonsterInstance master, L2MonsterInstance minion) {
        minion.stopAllEffects();
        minion.setIsDead(false);
        minion.setDecayed(false);
        minion.setCurrentHpMp(minion.getMaxHp(), minion.getMaxMp());
        minion.setHeading(master.getHeading());
        minion.setLeader(master);
        minion.setInstanceId(master.getInstanceId());
        int offset = 200;
        int minRadius = (int)master.getCollisionRadius() + 30;
        double distance = Rnd.get(minRadius, 200);
        double angle = Rnd.nextDouble() * (Math.PI * 2);
        int newX = master.getX() + (int)(distance * Math.cos(angle));
        int newY = master.getY() + (int)(distance * Math.sin(angle));
        minion.spawnMe(newX, newY, master.getZ());
        if (Config.DEBUG) {
            _log.info("Spawned minion template " + minion.getId() + " with objid: " + minion.getObjectId() + " to boss " + master.getObjectId() + " ,at: " + minion.getX() + " x, " + minion.getY() + " y, " + minion.getZ() + " z");
        }
        return minion;
    }

    private final int countSpawnedMinionsById(int minionId) {
        int count = 0;
        for (L2MonsterInstance minion : this._minionReferences) {
            if (minion == null || minion.getId() != minionId) continue;
            ++count;
        }
        return count;
    }

    public final int countSpawnedMinions() {
        return this._minionReferences.size();
    }

    public final int lazyCountSpawnedMinionsGroups() {
        FastSet seenGroups = new FastSet();
        for (L2MonsterInstance minion : this._minionReferences) {
            if (minion == null) continue;
            seenGroups.add(minion.getId());
        }
        return seenGroups.size();
    }

    private final class MinionRespawnTask
    implements Runnable {
        private final L2MonsterInstance _minion;

        public MinionRespawnTask(L2MonsterInstance minion) {
            this._minion = minion;
        }

        @Override
        public void run() {
            if (!MinionList.this._master.isAlikeDead() && MinionList.this._master.isVisible() && !this._minion.isVisible()) {
                if (MinionList.this._reusedMinionReferences != null) {
                    MinionList.this._reusedMinionReferences.remove(this._minion);
                }
                this._minion.refreshID();
                MinionList.initializeNpcInstance(MinionList.this._master, this._minion);
            }
        }
    }
}

