/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.util;

import com.l2jserver.Config;
import com.l2jserver.gameserver.GeoData;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.enums.HtmlActionScope;
import com.l2jserver.gameserver.enums.IllegalActionPunishmentType;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.tasks.player.IllegalPlayerActionTask;
import com.l2jserver.gameserver.model.interfaces.ILocational;
import com.l2jserver.gameserver.network.serverpackets.NpcHtmlMessage;
import com.l2jserver.gameserver.network.serverpackets.ShowBoard;
import com.l2jserver.util.file.filter.ExtFilter;
import java.io.File;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javolution.text.TextBuilder;

public final class Util {
    private static final Logger LOGGER = Logger.getLogger(Util.class.getName());
    static final double HEADING_PER_DEGREE = 182.04444444444445;
    static final double HEADING_PER_RADIAN = 10430.378350470453;

    public static void handleIllegalPlayerAction(L2PcInstance actor, String message, IllegalActionPunishmentType punishment) {
        ThreadPoolManager.getInstance().scheduleGeneral(new IllegalPlayerActionTask(actor, message, punishment), 5000L);
    }

    public static String getRelativePath(File base, File file) {
        return file.toURI().getPath().substring(base.toURI().getPath().length());
    }

    public static double calculateAngleFrom(ILocational from, ILocational to) {
        return Util.calculateAngleFrom(from.getX(), from.getY(), to.getX(), to.getY());
    }

    public static final double calculateAngleFrom(int fromX, int fromY, int toX, int toY) {
        double angleTarget = Math.toDegrees(Math.atan2(toY - fromY, toX - fromX));
        if (angleTarget < 0.0) {
            angleTarget += 360.0;
        }
        return angleTarget;
    }

    public static final double convertHeadingToDegree(int clientHeading) {
        return (double)clientHeading / 182.04444444444445;
    }

    public static final double convertHeadingToRadian(int clientHeading) {
        return (double)clientHeading / 10430.378350470453;
    }

    public static final int convertDegreeToClientHeading(double degree) {
        return (int)(degree * 182.04444444444445) & 0xFFFF;
    }

    public static final int convertRadianToClientHeading(double radian) {
        return (int)(radian * 10430.378350470453) & 0xFFFF;
    }

    public static final int calculateHeadingFrom(ILocational from, ILocational to) {
        return Util.calculateHeadingFrom(from.getX(), from.getY(), to.getX(), to.getY());
    }

    public static final int calculateHeadingFrom(int fromX, int fromY, int toX, int toY) {
        return (int)(Math.atan2(toY - fromY, toX - fromX) * 10430.378350470453) & 0xFFFF;
    }

    public static final int calculateHeadingFrom(double dx, double dy) {
        return (int)(Math.atan2(dy, dx) * 10430.378350470453) & 0xFFFF;
    }

    public static double calculateDistance(int x1, int y1, int x2, int y2) {
        return Util.calculateDistance(x1, y1, 0, x2, y2, 0, false, false);
    }

    public static double calculateDistance(int x1, int y1, int z1, int x2, int y2, int z2, boolean includeZAxis) {
        return Util.calculateDistance(x1, y1, z1, x2, y2, z2, includeZAxis, false);
    }

    public static double calculateDistance(L2Object obj1, L2Object obj2, boolean includeZAxis) {
        if (obj1 == null || obj2 == null) {
            return 1000000.0;
        }
        return Util.calculateDistance(obj1.getX(), obj1.getY(), obj1.getZ(), obj2.getX(), obj2.getY(), obj2.getZ(), includeZAxis, false);
    }

    public static double calculateDistance(int x1, int y1, int z1, int x2, int y2, int z2, boolean includeZAxis, boolean squared) {
        double dx = x1 - x2;
        double d = dx * dx;
        dx = y1 - y2;
        double distance = d + dx * dx;
        if (includeZAxis) {
            dx = z1 - z2;
            distance += dx * dx;
        }
        return squared ? distance : Math.sqrt(distance);
    }

    public static double calculateDistance(ILocational loc1, ILocational loc2, boolean includeZAxis, boolean squared) {
        return Util.calculateDistance(loc1.getX(), loc1.getY(), loc1.getZ(), loc2.getX(), loc2.getY(), loc2.getZ(), includeZAxis, squared);
    }

    public static String capitalizeFirst(String str) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        char[] arr = str.toCharArray();
        char c = arr[0];
        if (Character.isLetter(c)) {
            arr[0] = Character.toUpperCase(c);
        }
        return new String(arr);
    }

    @Deprecated
    public static String capitalizeWords(String str) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        char[] charArray = str.toCharArray();
        StringBuilder result = new StringBuilder(256);
        charArray[0] = Character.toUpperCase(charArray[0]);
        for (int i = 0; i < charArray.length; ++i) {
            if (Character.isWhitespace(charArray[i])) {
                charArray[i + 1] = Character.toUpperCase(charArray[i + 1]);
            }
            result.append(charArray[i]);
        }
        return result.toString();
    }

    public static boolean checkIfInRange(int range, L2Object obj1, L2Object obj2, boolean includeZAxis) {
        if (obj1 == null || obj2 == null) {
            return false;
        }
        if (obj1.getInstanceId() != obj2.getInstanceId()) {
            return false;
        }
        if (range == -1) {
            return true;
        }
        int rad = 0;
        if (obj1 instanceof L2Character) {
            rad += ((L2Character)obj1).getTemplate().getCollisionRadius();
        }
        if (obj2 instanceof L2Character) {
            rad += ((L2Character)obj2).getTemplate().getCollisionRadius();
        }
        double dx = obj1.getX() - obj2.getX();
        double dy = obj1.getY() - obj2.getY();
        double d = dx * dx + dy * dy;
        if (includeZAxis) {
            double dz = obj1.getZ() - obj2.getZ();
            d += dz * dz;
        }
        return d <= (double)(range * range + 2 * range * rad + rad * rad);
    }

    public static boolean checkIfInShortRadius(int radius, L2Object obj1, L2Object obj2, boolean includeZAxis) {
        if (obj1 == null || obj2 == null) {
            return false;
        }
        if (radius == -1) {
            return true;
        }
        int dx = obj1.getX() - obj2.getX();
        int dy = obj1.getY() - obj2.getY();
        if (includeZAxis) {
            int dz = obj1.getZ() - obj2.getZ();
            return dx * dx + dy * dy + dz * dz <= radius * radius;
        }
        return dx * dx + dy * dy <= radius * radius;
    }

    public static int countWords(String str) {
        return str.trim().split("\\s+").length;
    }

    public static String implodeString(Iterable<String> strArray, String strDelim) {
        TextBuilder sbString = TextBuilder.newInstance();
        for (String strValue : strArray) {
            sbString.append(strValue).append(strDelim);
        }
        String result = sbString.toString();
        TextBuilder.recycle((TextBuilder)sbString);
        return result;
    }

    public static <T> String implode(T[] objArray, String strDelim) {
        TextBuilder sbString = TextBuilder.newInstance();
        int length = objArray.length;
        for (int i = 0; i < length; ++i) {
            if (i > 0) {
                sbString.append(strDelim);
            }
            sbString.append(objArray[i].toString());
        }
        String result = sbString.toString();
        TextBuilder.recycle((TextBuilder)sbString);
        return result;
    }

    public static float roundTo(float number, int numPlaces) {
        if (numPlaces <= 1) {
            return Math.round(number);
        }
        float exponent = (float)Math.pow(10.0, numPlaces);
        return (float)Math.round(number * exponent) / exponent;
    }

    public static boolean isDigit(String text) {
        if (text == null || text.isEmpty()) {
            return false;
        }
        for (char c : text.toCharArray()) {
            if (Character.isDigit(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isAlphaNumeric(String text) {
        if (text == null || text.isEmpty()) {
            return false;
        }
        for (char c : text.toCharArray()) {
            if (Character.isLetterOrDigit(c)) continue;
            return false;
        }
        return true;
    }

    public static String formatAdena(long amount) {
        StringBuilder s = new StringBuilder(26).append(amount);
        for (int i = s.length() - 3; i > 0; i -= 3) {
            s.insert(i, ',');
        }
        return s.toString();
    }

    public static String formatAdenaK(long amount) {
        String u;
        long a = amount / 1000000000L;
        if (a != 0L && amount % 100000000L == 0L) {
            u = "G";
        } else {
            a = amount / 1000000L;
            if (a != 0L && amount % 100000L == 0L) {
                u = "M";
            } else {
                a = amount / 1000L;
                if (a != 0L && amount % 1000L == 0L) {
                    u = "K";
                } else {
                    a = amount;
                    u = "";
                }
            }
        }
        return Util.formatAdena(a) + u;
    }

    public static int calcCameraAngle(L2Character target) {
        return (540 - (int)Math.round(Util.convertHeadingToDegree(target.getHeading()))) % 360;
    }

    public static String formatDouble(double val, String format) {
        DecimalFormat formatter = new DecimalFormat(format, new DecimalFormatSymbols(Locale.ENGLISH));
        return formatter.format(val);
    }

    public static String formatDate(Date date, String format) {
        if (date == null) {
            return null;
        }
        return new SimpleDateFormat(format).format(date);
    }

    public static <T> boolean contains(T[] array, T obj) {
        for (T element : array) {
            if (element != obj) continue;
            return true;
        }
        return false;
    }

    public static <T> int indexOf(T[] array, T obj) {
        int len = array.length;
        for (int i = 0; i < len; ++i) {
            if (array[i] != obj) continue;
            return i;
        }
        return -1;
    }

    public static <T> int lastIndexOf(T[] array, T obj) {
        int i = array.length;
        while (--i >= 0) {
            if (array[i] != obj) continue;
            return i;
        }
        return -1;
    }

    public static <T> T[] append(T[] array, T obj) {
        if (array == null) {
            return new Object[]{obj};
        }
        int len = array.length;
        T[] tmp = Arrays.copyOf(array, len + 1, array.getClass());
        tmp[len] = obj;
        return tmp;
    }

    public static boolean contains(int[] array, int obj) {
        for (int element : array) {
            if (element != obj) continue;
            return true;
        }
        return false;
    }

    public static int indexOf(int[] array, int obj) {
        int len = array.length;
        for (int i = 0; i < len; ++i) {
            if (array[i] != obj) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(int[] array, int obj) {
        int i = array.length;
        while (--i >= 0) {
            if (array[i] != obj) continue;
            return i;
        }
        return -1;
    }

    public static int[] append(int[] array, int obj) {
        if (array == null) {
            return new int[]{obj};
        }
        int len = array.length;
        int[] tmp = new int[len + 1];
        System.arraycopy(array, 0, tmp, 0, len);
        tmp[len] = obj;
        return tmp;
    }

    public static File[] getDatapackFiles(String dirname, String extention) {
        File dir = new File(Config.DATAPACK_ROOT, "data/" + dirname);
        if (!dir.exists()) {
            return null;
        }
        return dir.listFiles(new ExtFilter(extention));
    }

    public static String getDateString(Date date) {
        return new SimpleDateFormat("yyyy-MM-dd").format(date.getTime());
    }

    private static final void buildHtmlBypassCache(L2PcInstance player, HtmlActionScope scope, String html) {
        int bypassStartEnd;
        int bypassStart;
        String htmlLower = html.toLowerCase(Locale.ENGLISH);
        int bypassEnd = 0;
        while ((bypassStart = htmlLower.indexOf("=\"bypass ", bypassEnd)) != -1 && (bypassEnd = htmlLower.indexOf(34, bypassStartEnd = bypassStart + 9)) != -1) {
            int hParamPos = htmlLower.indexOf("-h ", bypassStartEnd);
            String bypass = hParamPos != -1 && hParamPos < bypassEnd ? html.substring(hParamPos + 3, bypassEnd).trim() : html.substring(bypassStartEnd, bypassEnd).trim();
            int firstParameterStart = bypass.indexOf(36);
            if (firstParameterStart != -1) {
                bypass = bypass.substring(0, firstParameterStart + 1);
            }
            if (Config.HTML_ACTION_CACHE_DEBUG) {
                LOGGER.info("Cached html bypass(" + scope.toString() + "): '" + bypass + "'");
            }
            player.addHtmlAction(scope, bypass);
        }
    }

    private static final void buildHtmlLinkCache(L2PcInstance player, HtmlActionScope scope, String html) {
        int linkStartEnd;
        int linkStart;
        String htmlLower = html.toLowerCase(Locale.ENGLISH);
        int linkEnd = 0;
        while ((linkStart = htmlLower.indexOf("=\"link ", linkEnd)) != -1 && (linkEnd = htmlLower.indexOf(34, linkStartEnd = linkStart + 7)) != -1) {
            String htmlLink = html.substring(linkStartEnd, linkEnd).trim();
            if (htmlLink.isEmpty()) {
                LOGGER.warning("Html link path is empty!");
                continue;
            }
            if (htmlLink.contains("..")) {
                LOGGER.warning("Html link path is invalid: " + htmlLink);
                continue;
            }
            if (Config.HTML_ACTION_CACHE_DEBUG) {
                LOGGER.info("Cached html link(" + scope.toString() + "): '" + htmlLink + "'");
            }
            player.addHtmlAction(scope, "link " + htmlLink);
        }
    }

    public static void buildHtmlActionCache(L2PcInstance player, HtmlActionScope scope, int npcObjId, String html) {
        if (player == null || scope == null || npcObjId < 0 || html == null) {
            throw new IllegalArgumentException();
        }
        if (Config.HTML_ACTION_CACHE_DEBUG) {
            LOGGER.info("Set html action npc(" + scope.toString() + "): " + npcObjId);
        }
        player.setHtmlActionOriginObjectId(scope, npcObjId);
        Util.buildHtmlBypassCache(player, scope, html);
        Util.buildHtmlLinkCache(player, scope, html);
    }

    public static void sendHtml(L2PcInstance activeChar, String html) {
        NpcHtmlMessage npcHtml = new NpcHtmlMessage();
        npcHtml.setHtml(html);
        activeChar.sendPacket(npcHtml);
    }

    public static void sendCBHtml(L2PcInstance activeChar, String html) {
        Util.sendCBHtml(activeChar, html, true);
    }

    public static void sendCBHtml(L2PcInstance activeChar, String html, boolean buildActionCache) {
        Util.sendCBHtml(activeChar, html, null, buildActionCache);
    }

    public static void sendCBHtml(L2PcInstance activeChar, String html, String fillMultiEdit) {
        Util.sendCBHtml(activeChar, html, fillMultiEdit, true);
    }

    public static void sendCBHtml(L2PcInstance activeChar, String html, String fillMultiEdit, boolean buildActionCache) {
        Util.sendCBHtml(0, activeChar, html, fillMultiEdit, buildActionCache);
    }

    public static void sendCBHtml(L2Npc npc, L2PcInstance activeChar, String html, String fillMultiEdit, boolean buildActionCache) {
        Util.sendCBHtml(npc.getObjectId(), activeChar, html, fillMultiEdit, buildActionCache);
    }

    public static void sendCBHtml(int npcObjId, L2PcInstance activeChar, String html, String fillMultiEdit, boolean buildActionCache) {
        if (activeChar == null) {
            return;
        }
        activeChar.clearHtmlActions(HtmlActionScope.COMM_BOARD_HTML);
        if (buildActionCache) {
            Util.buildHtmlActionCache(activeChar, HtmlActionScope.COMM_BOARD_HTML, npcObjId, html);
        }
        if (fillMultiEdit != null) {
            activeChar.sendPacket(new ShowBoard(html, "1001"));
            Util.fillMultiEditContent(activeChar, fillMultiEdit);
        } else if (html.length() < 16250) {
            activeChar.sendPacket(new ShowBoard(html, "101"));
            activeChar.sendPacket(new ShowBoard(null, "102"));
            activeChar.sendPacket(new ShowBoard(null, "103"));
        } else if (html.length() < 32500) {
            activeChar.sendPacket(new ShowBoard(html.substring(0, 16250), "101"));
            activeChar.sendPacket(new ShowBoard(html.substring(16250), "102"));
            activeChar.sendPacket(new ShowBoard(null, "103"));
        } else if (html.length() < 48750) {
            activeChar.sendPacket(new ShowBoard(html.substring(0, 16250), "101"));
            activeChar.sendPacket(new ShowBoard(html.substring(16250, 32500), "102"));
            activeChar.sendPacket(new ShowBoard(html.substring(32500), "103"));
        } else {
            activeChar.sendPacket(new ShowBoard("<html><body><br><center>Error: HTML was too long!</center></body></html>", "101"));
            activeChar.sendPacket(new ShowBoard(null, "102"));
            activeChar.sendPacket(new ShowBoard(null, "103"));
        }
    }

    public static void fillMultiEditContent(L2PcInstance activeChar, String text) {
        text = Pattern.compile("(?:\r\n|\n|\r|<br>)", 2).matcher(text).replaceAll("\n");
        ArrayList<String> arg = new ArrayList<String>(17);
        arg.add("0");
        arg.add("0");
        arg.add("0");
        arg.add("0");
        arg.add("0");
        arg.add("0");
        arg.add(activeChar.getName());
        arg.add(Integer.toString(activeChar.getObjectId()));
        arg.add(activeChar.getAccountName());
        arg.add("9");
        arg.add(" ");
        arg.add(" ");
        arg.add(text == null || text.length() == 0 ? " " : text);
        arg.add("0");
        arg.add("0");
        arg.add("0");
        arg.add("0");
        activeChar.sendPacket(new ShowBoard(arg));
    }

    public static int getPlayersCountInRadius(int range, L2Object npc, boolean playable, boolean invisible) {
        int count = 0;
        Collection objs = npc.getKnownList().getKnownObjects().values();
        for (L2Object obj : objs) {
            L2Character cha;
            if (obj == null || (!obj.isPlayable() || !playable) && !obj.isPet() || obj.isPlayer() && !invisible && obj.getActingPlayer().getAppearance().getInvisible() || (cha = (L2Character)obj).getZ() < npc.getZ() - 100 && cha.getZ() > npc.getZ() + 100 || !GeoData.getInstance().canSeeTarget(cha.getX(), cha.getY(), cha.getZ(), npc.getX(), npc.getY(), npc.getZ()) || !Util.checkIfInRange(range, npc, obj, true) || cha.isDead()) continue;
            ++count;
        }
        return count;
    }

    public static boolean isInsideRangeOfObjectId(L2Object obj, int targetObjId, int radius) {
        L2Object target = (L2Object)obj.getKnownList().getKnownObjects().get(targetObjId);
        if (target == null) {
            return false;
        }
        return !(obj.calculateDistance(target, false, false) > (double)radius);
    }

    public static int min(int value1, int value2, int ... values) {
        int min = Math.min(value1, value2);
        for (int value : values) {
            if (min <= value) continue;
            min = value;
        }
        return min;
    }

    public static int max(int value1, int value2, int ... values) {
        int max = Math.max(value1, value2);
        for (int value : values) {
            if (max >= value) continue;
            max = value;
        }
        return max;
    }

    public static long min(long value1, long value2, long ... values) {
        long min = Math.min(value1, value2);
        for (long value : values) {
            if (min <= value) continue;
            min = value;
        }
        return min;
    }

    public static long max(long value1, long value2, long ... values) {
        long max = Math.max(value1, value2);
        for (long value : values) {
            if (max >= value) continue;
            max = value;
        }
        return max;
    }

    public static float min(float value1, float value2, float ... values) {
        float min = Math.min(value1, value2);
        for (float value : values) {
            if (!(min > value)) continue;
            min = value;
        }
        return min;
    }

    public static float max(float value1, float value2, float ... values) {
        float max = Math.max(value1, value2);
        for (float value : values) {
            if (!(max < value)) continue;
            max = value;
        }
        return max;
    }

    public static double min(double value1, double value2, double ... values) {
        double min = Math.min(value1, value2);
        for (double value : values) {
            if (!(min > value)) continue;
            min = value;
        }
        return min;
    }

    public static double max(double value1, double value2, double ... values) {
        double max = Math.max(value1, value2);
        for (double value : values) {
            if (!(max < value)) continue;
            max = value;
        }
        return max;
    }

    public static int getIndexOfMaxValue(int ... array) {
        int index = 0;
        for (int i = 1; i < array.length; ++i) {
            if (array[i] <= array[index]) continue;
            index = i;
        }
        return index;
    }

    public static int getIndexOfMinValue(int ... array) {
        int index = 0;
        for (int i = 1; i < array.length; ++i) {
            if (array[i] >= array[index]) continue;
            index = i;
        }
        return index;
    }

    public static int map(int input, int inputMin, int inputMax, int outputMin, int outputMax) {
        return (input - inputMin) * (outputMax - outputMin) / (inputMax - inputMin) + outputMin;
    }

    public static long map(long input, long inputMin, long inputMax, long outputMin, long outputMax) {
        return (input - inputMin) * (outputMax - outputMin) / (inputMax - inputMin) + outputMin;
    }

    public static double map(double input, double inputMin, double inputMax, double outputMin, double outputMax) {
        return (input - inputMin) * (outputMax - outputMin) / (inputMax - inputMin) + outputMin;
    }

    public static int constrain(int input, int min, int max) {
        return input < min ? min : (input > max ? max : input);
    }

    public static long constrain(long input, long min, long max) {
        return input < min ? min : (input > max ? max : input);
    }

    public static double constrain(double input, double min, double max) {
        return input < min ? min : (input > max ? max : input);
    }
}

