/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.status;

import com.l2jserver.Config;
import com.l2jserver.gameserver.handler.ITelnetHandler;
import com.l2jserver.gameserver.handler.TelnetHandler;
import com.l2jserver.status.TelnetExec;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Properties;
import java.util.logging.Logger;

public class GameStatusThread
extends Thread {
    private static final Logger _log = Logger.getLogger(GameStatusThread.class.getName());
    private final Socket _cSocket;
    private final PrintWriter _print;
    private final BufferedReader _read;
    private final int _uptime;

    private void telnetOutput(int type, String text) {
        if (Config.DEVELOPER) {
            if (type == 1) {
                System.out.println("TELNET | " + text);
            } else if (type == 2) {
                System.out.print("TELNET | " + text);
            } else if (type == 3) {
                System.out.print(text);
            } else if (type == 4) {
                System.out.println(text);
            } else {
                System.out.println("TELNET | " + text);
            }
        } else if (type == 5) {
            System.out.println("TELNET | " + text);
        }
    }

    private boolean isValidIP(Socket client) {
        boolean result = false;
        InetAddress ClientIP = client.getInetAddress();
        String clientStringIP = ClientIP.getHostAddress();
        this.telnetOutput(1, "Connection from: " + clientStringIP);
        if (Config.DEVELOPER) {
            this.telnetOutput(2, "");
        }
        try (FileInputStream telnetIS = new FileInputStream("./config/Telnet.properties");){
            Properties telnetSettings = new Properties();
            telnetSettings.load(telnetIS);
            String HostList = telnetSettings.getProperty("ListOfHosts", "127.0.0.1,localhost,::1");
            if (Config.DEVELOPER) {
                this.telnetOutput(3, "Comparing ip to list...");
            }
            String ipToCompare = null;
            for (String ip : HostList.split(",")) {
                if (result) continue;
                ipToCompare = InetAddress.getByName(ip).getHostAddress();
                if (clientStringIP.equals(ipToCompare)) {
                    result = true;
                }
                if (!Config.DEVELOPER) continue;
                this.telnetOutput(3, clientStringIP + " = " + ipToCompare + "(" + ip + ") = " + result);
            }
        }
        catch (IOException e) {
            if (Config.DEVELOPER) {
                this.telnetOutput(4, "");
            }
            this.telnetOutput(1, "Error: " + e);
        }
        if (Config.DEVELOPER) {
            this.telnetOutput(4, "Allow IP: " + result);
        }
        return result;
    }

    public GameStatusThread(Socket client, int uptime, String StatusPW) throws IOException {
        this.setPriority(10);
        this._cSocket = client;
        this._uptime = uptime;
        this._print = new PrintWriter(this._cSocket.getOutputStream());
        this._read = new BufferedReader(new InputStreamReader(this._cSocket.getInputStream()));
        if (this.isValidIP(client)) {
            this.telnetOutput(1, client.getInetAddress().getHostAddress() + " accepted.");
            this._print.println("Welcome To The L2J Telnet Session.");
            this._print.println("Please Insert Your Password!");
            this._print.print("Password: ");
            this._print.flush();
            String tmpLine = this._read.readLine();
            if (tmpLine == null) {
                this._print.println("Error.");
                this._print.println("Disconnected...");
                this._print.flush();
                this._cSocket.close();
            } else if (!tmpLine.equals(StatusPW)) {
                this._print.println("Incorrect Password!");
                this._print.println("Disconnected...");
                this._print.flush();
                this._cSocket.close();
            } else {
                this._print.println("Password Correct!");
                this._print.println("[L2J Game Server]");
                this._print.print("");
                this._print.flush();
                this.start();
            }
        } else {
            this.telnetOutput(5, "Connection attempt from " + client.getInetAddress().getHostAddress() + " rejected.");
            this._cSocket.close();
        }
    }

    @Override
    public void run() {
        String _usrCommand = "";
        try {
            while (_usrCommand.compareTo("quit") != 0 && _usrCommand.compareTo("exit") != 0) {
                _usrCommand = this._read.readLine();
                if (_usrCommand == null) {
                    this._cSocket.close();
                    break;
                }
                ITelnetHandler handler = TelnetHandler.getInstance().getHandler(_usrCommand);
                if (handler != null) {
                    handler.useCommand(_usrCommand, this._print, this._cSocket, this._uptime);
                } else if (!(_usrCommand.equalsIgnoreCase("quit") || _usrCommand.equalsIgnoreCase("exit") || _usrCommand.isEmpty())) {
                    if (_usrCommand.startsWith("!")) {
                        int exitValue = new TelnetExec(this._print).exec(_usrCommand.substring(1));
                        this._print.println("*ERROELEVEL=" + exitValue);
                    } else {
                        this._print.print("Command: " + _usrCommand + " was not found!");
                    }
                }
                this._print.print("");
                this._print.flush();
            }
            if (!this._cSocket.isClosed()) {
                this._print.println("Bye Bye!");
                this._print.flush();
                this._cSocket.close();
            }
            this.telnetOutput(1, "Connection from " + this._cSocket.getInetAddress().getHostAddress() + " was closed by client.");
        }
        catch (IOException e) {
            _log.warning(this.getClass().getSimpleName() + ": " + e.getMessage());
        }
    }
}

