/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import java.util.logging.Logger;

public final class PropertiesParser {
    private static final Logger _log = Logger.getLogger(PropertiesParser.class.getName());
    private final Properties _properties = new Properties();
    private final File _file;

    public PropertiesParser(String name) {
        this(new File(name));
    }

    public PropertiesParser(File file) {
        this._file = file;
        try (InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8);){
            this._properties.load(inputStreamReader);
        }
        catch (Exception e) {
            _log.warning("[" + this._file.getName() + "] There was an error loading config reason: " + e.getMessage());
        }
    }

    public boolean containskey(String key) {
        return this._properties.containsKey(key);
    }

    private String getValue(String key) {
        String value = this._properties.getProperty(key);
        return value != null ? value.trim() : null;
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        String value = this.getValue(key);
        if (value == null) {
            _log.warning("[" + this._file.getName() + "] missing property for key: " + key + " using default value: " + defaultValue);
            return defaultValue;
        }
        if (value.equalsIgnoreCase("true")) {
            return true;
        }
        if (value.equalsIgnoreCase("false")) {
            return false;
        }
        _log.warning("[" + this._file.getName() + "] Invalid value specified for key: " + key + " specified value: " + value + " should be \"boolean\" using default value: " + defaultValue);
        return defaultValue;
    }

    public byte getByte(String key, byte defaultValue) {
        String value = this.getValue(key);
        if (value == null) {
            _log.warning("[" + this._file.getName() + "] missing property for key: " + key + " using default value: " + defaultValue);
            return defaultValue;
        }
        try {
            return Byte.parseByte(value);
        }
        catch (NumberFormatException e) {
            _log.warning("[" + this._file.getName() + "] Invalid value specified for key: " + key + " specified value: " + value + " should be \"byte\" using default value: " + defaultValue);
            return defaultValue;
        }
    }

    public short getShort(String key, short defaultValue) {
        String value = this.getValue(key);
        if (value == null) {
            _log.warning("[" + this._file.getName() + "] missing property for key: " + key + " using default value: " + defaultValue);
            return defaultValue;
        }
        try {
            return Short.parseShort(value);
        }
        catch (NumberFormatException e) {
            _log.warning("[" + this._file.getName() + "] Invalid value specified for key: " + key + " specified value: " + value + " should be \"short\" using default value: " + defaultValue);
            return defaultValue;
        }
    }

    public int getInt(String key, int defaultValue) {
        String value = this.getValue(key);
        if (value == null) {
            _log.warning("[" + this._file.getName() + "] missing property for key: " + key + " using default value: " + defaultValue);
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            _log.warning("[" + this._file.getName() + "] Invalid value specified for key: " + key + " specified value: " + value + " should be \"int\" using default value: " + defaultValue);
            return defaultValue;
        }
    }

    public long getLong(String key, long defaultValue) {
        String value = this.getValue(key);
        if (value == null) {
            _log.warning("[" + this._file.getName() + "] missing property for key: " + key + " using default value: " + defaultValue);
            return defaultValue;
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            _log.warning("[" + this._file.getName() + "] Invalid value specified for key: " + key + " specified value: " + value + " should be \"long\" using default value: " + defaultValue);
            return defaultValue;
        }
    }

    public float getFloat(String key, float defaultValue) {
        String value = this.getValue(key);
        if (value == null) {
            _log.warning("[" + this._file.getName() + "] missing property for key: " + key + " using default value: " + defaultValue);
            return defaultValue;
        }
        try {
            return Float.parseFloat(value);
        }
        catch (NumberFormatException e) {
            _log.warning("[" + this._file.getName() + "] Invalid value specified for key: " + key + " specified value: " + value + " should be \"float\" using default value: " + defaultValue);
            return defaultValue;
        }
    }

    public double getDouble(String key, double defaultValue) {
        String value = this.getValue(key);
        if (value == null) {
            _log.warning("[" + this._file.getName() + "] missing property for key: " + key + " using default value: " + defaultValue);
            return defaultValue;
        }
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            _log.warning("[" + this._file.getName() + "] Invalid value specified for key: " + key + " specified value: " + value + " should be \"double\" using default value: " + defaultValue);
            return defaultValue;
        }
    }

    public String getString(String key, String defaultValue) {
        String value = this.getValue(key);
        if (value == null) {
            _log.warning("[" + this._file.getName() + "] missing property for key: " + key + " using default value: " + defaultValue);
            return defaultValue;
        }
        return value;
    }

    public <T extends Enum<T>> T getEnum(String key, Class<T> clazz, T defaultValue) {
        String value = this.getValue(key);
        if (value == null) {
            _log.warning("[" + this._file.getName() + "] missing property for key: " + key + " using default value: " + defaultValue);
            return defaultValue;
        }
        try {
            return Enum.valueOf(clazz, value);
        }
        catch (IllegalArgumentException e) {
            _log.warning("[" + this._file.getName() + "] Invalid value specified for key: " + key + " specified value: " + value + " should be enum value of \"" + clazz.getSimpleName() + "\" using default value: " + defaultValue);
            return defaultValue;
        }
    }
}

