/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.loginserver;

import com.l2jserver.Config;
import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.loginserver.GameServerThread;
import com.l2jserver.util.IPSubnet;
import com.l2jserver.util.Rnd;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.spec.RSAKeyGenParameterSpec;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javolution.io.UTF8StreamReader;
import javolution.xml.stream.XMLStreamReaderImpl;

public final class GameServerTable {
    private static final Logger _log = Logger.getLogger(GameServerTable.class.getName());
    private static final Map<Integer, String> _serverNames = new HashMap<Integer, String>();
    private static final Map<Integer, GameServerInfo> _gameServerTable = new HashMap<Integer, GameServerInfo>();
    private static final int KEYS_SIZE = 10;
    private KeyPair[] _keyPairs;

    public GameServerTable() {
        this.loadGameServerNames();
        _log.info(this.getClass().getSimpleName() + ": Loaded " + _serverNames.size() + " server names");
        this.loadRegisteredGameServers();
        _log.info(this.getClass().getSimpleName() + ": Loaded " + _gameServerTable.size() + " registered Game Servers");
        this.initRSAKeys();
        _log.info(this.getClass().getSimpleName() + ": Cached " + (this._keyPairs == null ? 0 : this._keyPairs.length) + " RSA keys for Game Server communication.");
    }

    private void loadGameServerNames() {
        File xml = new File(Config.DATAPACK_ROOT, "data/servername.xml");
        try (FileInputStream in = new FileInputStream(xml);
             UTF8StreamReader utf8 = new UTF8StreamReader();){
            XMLStreamReaderImpl xpp = new XMLStreamReaderImpl();
            xpp.setInput((Reader)utf8.setInput((InputStream)in));
            int e = xpp.getEventType();
            while (e != 8) {
                if (e == 1 && xpp.getLocalName().toString().equals("server")) {
                    Integer id = Integer.valueOf(xpp.getAttributeValue(null, (CharSequence)"id").toString());
                    String name = xpp.getAttributeValue(null, (CharSequence)"name").toString();
                    _serverNames.put(id, name);
                }
                e = xpp.next();
            }
            xpp.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initRSAKeys() {
        try {
            KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA");
            keyGen.initialize(new RSAKeyGenParameterSpec(512, RSAKeyGenParameterSpec.F4));
            this._keyPairs = new KeyPair[10];
            for (int i = 0; i < 10; ++i) {
                this._keyPairs[i] = keyGen.genKeyPair();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void loadRegisteredGameServers() {
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             Statement ps = con.createStatement();
             ResultSet rs = ps.executeQuery("SELECT * FROM gameservers");){
            while (rs.next()) {
                int id = rs.getInt("server_id");
                _gameServerTable.put(id, new GameServerInfo(id, this.stringToHex(rs.getString("hexid"))));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Map<Integer, GameServerInfo> getRegisteredGameServers() {
        return _gameServerTable;
    }

    public GameServerInfo getRegisteredGameServerById(int id) {
        return _gameServerTable.get(id);
    }

    public boolean hasRegisteredGameServerOnId(int id) {
        return _gameServerTable.containsKey(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean registerWithFirstAvaliableId(GameServerInfo gsi) {
        Map<Integer, GameServerInfo> map = _gameServerTable;
        synchronized (map) {
            for (Map.Entry<Integer, String> entry : _serverNames.entrySet()) {
                if (_gameServerTable.containsKey(entry.getKey())) continue;
                _gameServerTable.put(entry.getKey(), gsi);
                gsi.setId(entry.getKey());
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean register(int id, GameServerInfo gsi) {
        Map<Integer, GameServerInfo> map = _gameServerTable;
        synchronized (map) {
            if (!_gameServerTable.containsKey(id)) {
                _gameServerTable.put(id, gsi);
                gsi.setId(id);
                return true;
            }
        }
        return false;
    }

    public void registerServerOnDB(GameServerInfo gsi) {
        this.registerServerOnDB(gsi.getHexId(), gsi.getId(), gsi.getExternalHost());
    }

    public void registerServerOnDB(byte[] hexId, int id, String externalHost) {
        this.register(id, new GameServerInfo(id, hexId));
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement ps = con.prepareStatement("INSERT INTO gameservers (hexid,server_id,host) values (?,?,?)");){
            ps.setString(1, this.hexToString(hexId));
            ps.setInt(2, id);
            ps.setString(3, externalHost);
            ps.executeUpdate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getServerNameById(int id) {
        return _serverNames.get(id);
    }

    public Map<Integer, String> getServerNames() {
        return _serverNames;
    }

    public KeyPair getKeyPair() {
        return this._keyPairs[Rnd.nextInt(10)];
    }

    private byte[] stringToHex(String string) {
        return new BigInteger(string, 16).toByteArray();
    }

    private String hexToString(byte[] hex) {
        if (hex == null) {
            return "null";
        }
        return new BigInteger(hex).toString(16);
    }

    public static GameServerTable getInstance() {
        return SingletonHolder._instance;
    }

    private static class SingletonHolder {
        protected static final GameServerTable _instance = new GameServerTable();

        private SingletonHolder() {
        }
    }

    public static class GameServerInfo {
        private int _id;
        private final byte[] _hexId;
        private boolean _isAuthed;
        private GameServerThread _gst;
        private int _status;
        private final ArrayList<GameServerAddress> _addrs = new ArrayList(5);
        private int _port;
        private final boolean _isPvp = true;
        private int _serverType;
        private int _ageLimit;
        private boolean _isShowingBrackets;
        private int _maxPlayers;

        public GameServerInfo(int id, byte[] hexId, GameServerThread gst) {
            this._id = id;
            this._hexId = hexId;
            this._gst = gst;
            this._status = 4;
        }

        public GameServerInfo(int id, byte[] hexId) {
            this(id, hexId, null);
        }

        public void setId(int id) {
            this._id = id;
        }

        public int getId() {
            return this._id;
        }

        public byte[] getHexId() {
            return this._hexId;
        }

        public void setAuthed(boolean isAuthed) {
            this._isAuthed = isAuthed;
        }

        public boolean isAuthed() {
            return this._isAuthed;
        }

        public void setGameServerThread(GameServerThread gst) {
            this._gst = gst;
        }

        public GameServerThread getGameServerThread() {
            return this._gst;
        }

        public void setStatus(int status) {
            this._status = status;
        }

        public int getStatus() {
            return this._status;
        }

        public int getCurrentPlayerCount() {
            if (this._gst == null) {
                return 0;
            }
            return this._gst.getPlayerCount();
        }

        public String getExternalHost() {
            try {
                return this.getServerAddress(InetAddress.getByName("0.0.0.0"));
            }
            catch (Exception exception) {
                return null;
            }
        }

        public int getPort() {
            return this._port;
        }

        public void setPort(int port) {
            this._port = port;
        }

        public void setMaxPlayers(int maxPlayers) {
            this._maxPlayers = maxPlayers;
        }

        public int getMaxPlayers() {
            return this._maxPlayers;
        }

        public boolean isPvp() {
            return true;
        }

        public void setAgeLimit(int val) {
            this._ageLimit = val;
        }

        public int getAgeLimit() {
            return this._ageLimit;
        }

        public void setServerType(int val) {
            this._serverType = val;
        }

        public int getServerType() {
            return this._serverType;
        }

        public void setShowingBrackets(boolean val) {
            this._isShowingBrackets = val;
        }

        public boolean isShowingBrackets() {
            return this._isShowingBrackets;
        }

        public void setDown() {
            this.setAuthed(false);
            this.setPort(0);
            this.setGameServerThread(null);
            this.setStatus(4);
        }

        public void addServerAddress(String subnet, String addr) throws UnknownHostException {
            this._addrs.add(new GameServerAddress(subnet, addr));
        }

        public String getServerAddress(InetAddress addr) {
            for (GameServerAddress a : this._addrs) {
                if (!a.equals(addr)) continue;
                return a.getServerAddress();
            }
            return null;
        }

        public String[] getServerAddresses() {
            String[] result = new String[this._addrs.size()];
            for (int i = 0; i < result.length; ++i) {
                result[i] = this._addrs.get(i).toString();
            }
            return result;
        }

        public void clearServerAddresses() {
            this._addrs.clear();
        }

        private class GameServerAddress
        extends IPSubnet {
            private final String _serverAddress;

            public GameServerAddress(String subnet, String address) throws UnknownHostException {
                super(subnet);
                this._serverAddress = address;
            }

            public String getServerAddress() {
                return this._serverAddress;
            }

            @Override
            public String toString() {
                return this._serverAddress + ":" + GameServerInfo.this.getPort() + super.toString();
            }
        }
    }
}

