/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.loginserver;

import com.l2jserver.Config;
import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.loginserver.GameServerTable;
import com.l2jserver.loginserver.GameServerThread;
import com.l2jserver.loginserver.SessionKey;
import com.l2jserver.loginserver.network.L2LoginClient;
import com.l2jserver.loginserver.network.serverpackets.LoginFail;
import com.l2jserver.util.Base64;
import com.l2jserver.util.Rnd;
import com.l2jserver.util.crypt.ScrambledKeyPair;
import com.l2jserver.util.lib.Log;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.RSAKeyGenParameterSpec;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.Cipher;
import javolution.util.FastList;
import javolution.util.FastMap;

public class LoginController {
    protected static final Logger _log = Logger.getLogger(LoginController.class.getName());
    private static LoginController _instance;
    public static final int LOGIN_TIMEOUT = 60000;
    protected FastMap<String, L2LoginClient> _loginServerClients = new FastMap().shared();
    protected FastMap<String, String> _loginServerIpAddrs = new FastMap().shared();
    private final Map<String, BanInfo> _bannedIps = new FastMap().shared();
    private final Map<InetAddress, FailedLoginAttempt> _hackProtection;
    protected ScrambledKeyPair[] _keyPairs;
    private final Thread _purge;
    protected byte[][] _blowfishKeys;
    private static final int BLOWFISH_KEYS = 20;
    private static final String USER_INFO_SELECT = "SELECT password, IF(? > value OR value IS NULL, accessLevel, -1) AS accessLevel, lastServer FROM accounts LEFT JOIN (account_data) ON (account_data.account_name=accounts.login AND account_data.var=\"ban_temp\") WHERE login=?";
    private static final String AUTOCREATE_ACCOUNTS_INSERT = "INSERT INTO accounts (login, password, lastactive, accessLevel, lastIP) values (?, ?, ?, ?, ?)";
    private static final String ACCOUNT_INFO_UPDATE = "UPDATE accounts SET lastactive = ?, lastIP = ? WHERE login = ?";
    private static final String ACCOUNT_LAST_SERVER_UPDATE = "UPDATE accounts SET lastServer = ? WHERE login = ?";
    private static final String ACCOUNT_ACCESS_LEVEL_UPDATE = "UPDATE accounts SET accessLevel = ? WHERE login = ?";
    private static final String ACCOUNT_IPS_UPDATE = "UPDATE accounts SET pcIp = ?, hop1 = ?, hop2 = ?, hop3 = ?, hop4 = ? WHERE login = ?";
    private static final String ACCOUNT_IPAUTH_SELECT = "SELECT * FROM accounts_ipauth WHERE login = ?";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void load() throws GeneralSecurityException {
        Class<LoginController> clazz = LoginController.class;
        synchronized (LoginController.class) {
            if (_instance != null) {
                throw new IllegalStateException("LoginController can only be loaded a single time.");
            }
            _instance = new LoginController();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static LoginController getInstance() {
        return _instance;
    }

    private LoginController() throws GeneralSecurityException {
        _log.info("Loading LoginController...");
        this._hackProtection = new FastMap();
        this._keyPairs = new ScrambledKeyPair[10];
        KeyPairGenerator keygen = null;
        keygen = KeyPairGenerator.getInstance("RSA");
        RSAKeyGenParameterSpec spec = new RSAKeyGenParameterSpec(1024, RSAKeyGenParameterSpec.F4);
        keygen.initialize(spec);
        for (int i = 0; i < 10; ++i) {
            this._keyPairs[i] = new ScrambledKeyPair(keygen.generateKeyPair());
        }
        _log.info("Cached 10 KeyPairs for RSA communication");
        this.testCipher((RSAPrivateKey)this._keyPairs[0]._pair.getPrivate());
        this.generateBlowFishKeys();
        this._purge = new PurgeThread();
        this._purge.setDaemon(true);
        this._purge.start();
    }

    private void testCipher(RSAPrivateKey key) throws GeneralSecurityException {
        Cipher rsaCipher = Cipher.getInstance("RSA/ECB/nopadding");
        rsaCipher.init(2, key);
    }

    private void generateBlowFishKeys() {
        this._blowfishKeys = new byte[20][16];
        for (int i = 0; i < 20; ++i) {
            for (int j = 0; j < this._blowfishKeys[i].length; ++j) {
                this._blowfishKeys[i][j] = (byte)(Rnd.nextInt(255) + 1);
            }
        }
        _log.info("Stored " + this._blowfishKeys.length + " keys for Blowfish communication");
    }

    public byte[] getBlowfishKey() {
        return this._blowfishKeys[(int)(Math.random() * 20.0)];
    }

    public SessionKey assignSessionKeyToClient(String account, L2LoginClient client) {
        SessionKey key = new SessionKey(Rnd.nextInt(), Rnd.nextInt(), Rnd.nextInt(), Rnd.nextInt());
        this._loginServerClients.put((Object)account, (Object)client);
        return key;
    }

    public void removeAuthedLoginClient(String account) {
        if (account == null) {
            return;
        }
        this._loginServerClients.remove((Object)account);
    }

    public L2LoginClient getAuthedClient(String account) {
        return (L2LoginClient)((Object)this._loginServerClients.get((Object)account));
    }

    public void removeLoginIpAddr(String account) {
        this._loginServerIpAddrs.remove((Object)account);
    }

    public String getLoginIpAddr(String account) {
        return (String)this._loginServerIpAddrs.get((Object)account);
    }

    public String[] getAlreadyLoginAccounts(String address) {
        FastList ret = new FastList();
        for (Map.Entry e : this._loginServerIpAddrs.entrySet()) {
            if (!((String)e.getValue()).equals(address)) continue;
            ret.add(e.getKey());
        }
        return ret.toArray(new String[ret.size()]);
    }

    public boolean isIpAddrInGameServer(String account, String address) {
        if (!Config.DENY_MULTI_LOGIN_BY_IPADDR) {
            return false;
        }
        if (!this._loginServerIpAddrs.containsKey((Object)account) && this._loginServerIpAddrs.containsValue((Object)address)) {
            return this.getUserLevel(account) <= 0;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuthLoginResult tryAuthLogin(String account, String password, L2LoginClient client, LoginFail.LoginFailReason[] loginFailReason) {
        AuthLoginResult ret = AuthLoginResult.INVALID_PASSWORD;
        loginFailReason[0] = LoginFail.LoginFailReason.REASON_USER_OR_PASS_WRONG;
        String ip = client.getConnection().getInetAddress().getHostAddress();
        if (Config.DENY_BANNED_USER_BY_IPADDR && this.isIPinBanList(account, ip)) {
            return AuthLoginResult.ACCOUNT_BANNED;
        }
        if (this.loginValid(account, password, client, loginFailReason)) {
            loginFailReason[0] = LoginFail.LoginFailReason.REASON_ACCOUNT_IN_USE;
            ret = AuthLoginResult.ALREADY_ON_GS;
            if (!this.isAccountInAnyGameServer(account)) {
                ret = AuthLoginResult.ALREADY_IPADDR;
                FastMap<String, String> fastMap = this._loginServerIpAddrs;
                synchronized (fastMap) {
                    if (!this.isIpAddrInGameServer(account, ip)) {
                        if (!this._loginServerIpAddrs.containsKey((Object)account)) {
                            this._loginServerIpAddrs.put((Object)account, (Object)ip);
                        }
                    } else {
                        return ret;
                    }
                }
                loginFailReason[0] = LoginFail.LoginFailReason.REASON_ACCOUNT_IN_USE;
                ret = AuthLoginResult.ALREADY_ON_LS;
                if (this._loginServerClients.putIfAbsent((Object)account, (Object)client) == null) {
                    ret = AuthLoginResult.AUTH_SUCCESS;
                }
            }
        } else if (client.getAccessLevel() < 0) {
            ret = AuthLoginResult.ACCOUNT_BANNED;
        }
        return ret;
    }

    public void addBanForAddress(String address, long expiration) throws UnknownHostException {
        InetAddress netAddress = InetAddress.getByName(address);
        if (!this._bannedIps.containsKey(netAddress.getHostAddress())) {
            this._bannedIps.put(netAddress.getHostAddress(), new BanInfo(netAddress, expiration));
        }
    }

    public void addBanForAddress(InetAddress address, long duration) {
        if (!this._bannedIps.containsKey(address.getHostAddress())) {
            this._bannedIps.put(address.getHostAddress(), new BanInfo(address, System.currentTimeMillis() + duration));
        }
    }

    public boolean isBannedAddress(InetAddress address) {
        String[] parts = address.getHostAddress().split("\\.");
        BanInfo bi = this._bannedIps.get(address.getHostAddress());
        if (bi == null) {
            bi = this._bannedIps.get(parts[0] + "." + parts[1] + "." + parts[2] + ".0");
        }
        if (bi == null) {
            bi = this._bannedIps.get(parts[0] + "." + parts[1] + ".0.0");
        }
        if (bi == null) {
            bi = this._bannedIps.get(parts[0] + ".0.0.0");
        }
        if (bi != null) {
            if (bi.hasExpired()) {
                this._bannedIps.remove(address.getHostAddress());
                return false;
            }
            return true;
        }
        return false;
    }

    public Map<String, BanInfo> getBannedIps() {
        return this._bannedIps;
    }

    public boolean removeBanForAddress(InetAddress address) {
        return this._bannedIps.remove(address.getHostAddress()) != null;
    }

    public boolean removeBanForAddress(String address) {
        try {
            return this.removeBanForAddress(InetAddress.getByName(address));
        }
        catch (UnknownHostException e) {
            return false;
        }
    }

    public SessionKey getKeyForAccount(String account) {
        L2LoginClient client = (L2LoginClient)((Object)this._loginServerClients.get((Object)account));
        if (client != null) {
            return client.getSessionKey();
        }
        return null;
    }

    public boolean isAccountInAnyGameServer(String account) {
        Collection<GameServerTable.GameServerInfo> serverList = GameServerTable.getInstance().getRegisteredGameServers().values();
        for (GameServerTable.GameServerInfo gsi : serverList) {
            GameServerThread gst = gsi.getGameServerThread();
            if (gst == null || !gst.hasAccountOnGameServer(account)) continue;
            return true;
        }
        return false;
    }

    public GameServerTable.GameServerInfo getAccountOnGameServer(String account) {
        Collection<GameServerTable.GameServerInfo> serverList = GameServerTable.getInstance().getRegisteredGameServers().values();
        for (GameServerTable.GameServerInfo gsi : serverList) {
            GameServerThread gst = gsi.getGameServerThread();
            if (gst == null || !gst.hasAccountOnGameServer(account)) continue;
            return gsi;
        }
        return null;
    }

    public void getCharactersOnAccount(String account) {
        Collection<GameServerTable.GameServerInfo> serverList = GameServerTable.getInstance().getRegisteredGameServers().values();
        for (GameServerTable.GameServerInfo gsi : serverList) {
            if (!gsi.isAuthed()) continue;
            gsi.getGameServerThread().requestCharacters(account);
        }
    }

    public boolean isLoginPossible(L2LoginClient client, int serverId) {
        GameServerTable.GameServerInfo gsi = GameServerTable.getInstance().getRegisteredGameServerById(serverId);
        int access = client.getAccessLevel();
        if (gsi != null && gsi.isAuthed()) {
            boolean loginOk;
            boolean bl = loginOk = gsi.getCurrentPlayerCount() < gsi.getMaxPlayers() && gsi.getStatus() != 5 || access > 0;
            if (loginOk && client.getLastServer() != serverId) {
                try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
                     PreparedStatement ps = con.prepareStatement(ACCOUNT_LAST_SERVER_UPDATE);){
                    ps.setInt(1, serverId);
                    ps.setString(2, client.getAccount());
                    ps.executeUpdate();
                }
                catch (Exception e) {
                    _log.log(Level.WARNING, "Could not set lastServer: " + e.getMessage(), e);
                }
            }
            return loginOk;
        }
        return false;
    }

    public void setAccountAccessLevel(String account, int banLevel) {
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement ps = con.prepareStatement(ACCOUNT_ACCESS_LEVEL_UPDATE);){
            ps.setInt(1, banLevel);
            ps.setString(2, account);
            ps.executeUpdate();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Could not set accessLevel: " + e.getMessage(), e);
        }
    }

    public void setAccountLastTracert(String account, String pcIp, String hop1, String hop2, String hop3, String hop4) {
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement ps = con.prepareStatement(ACCOUNT_IPS_UPDATE);){
            ps.setString(1, pcIp);
            ps.setString(2, hop1);
            ps.setString(3, hop2);
            ps.setString(4, hop3);
            ps.setString(5, hop4);
            ps.setString(6, account);
            ps.executeUpdate();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Could not set last tracert: " + e.getMessage(), e);
        }
    }

    public void setCharactersOnServer(String account, int charsNum, long[] timeToDel, int serverId) {
        L2LoginClient client = (L2LoginClient)((Object)this._loginServerClients.get((Object)account));
        if (client == null) {
            return;
        }
        if (charsNum > 0) {
            client.setCharsOnServ(serverId, charsNum);
        }
        if (timeToDel.length > 0) {
            client.serCharsWaitingDelOnServ(serverId, timeToDel);
        }
    }

    public ScrambledKeyPair getScrambledRSAKeyPair() {
        return this._keyPairs[Rnd.nextInt(10)];
    }

    private boolean loginValid(String user, String password, L2LoginClient client, LoginFail.LoginFailReason[] loginFailReason) {
        InetAddress address;
        boolean ok;
        block158: {
            loginFailReason[0] = LoginFail.LoginFailReason.REASON_USER_OR_PASS_WRONG;
            ok = false;
            address = client.getConnection().getInetAddress();
            if (address == null || user == null) {
                return false;
            }
            try {
                Throwable throwable;
                PreparedStatement ps;
                Throwable throwable2;
                Connection con;
                ArrayList<InetAddress> ipBlackList;
                ArrayList<InetAddress> ipWhiteList;
                int lastServer;
                int access;
                byte[] expected;
                byte[] hash;
                block156: {
                    Throwable throwable3;
                    ResultSet rset;
                    MessageDigest md = MessageDigest.getInstance("SHA");
                    byte[] raw = password.getBytes(StandardCharsets.UTF_8);
                    hash = md.digest(raw);
                    expected = null;
                    access = 0;
                    lastServer = 1;
                    ipWhiteList = new ArrayList<InetAddress>();
                    ipBlackList = new ArrayList<InetAddress>();
                    con = L2DatabaseFactory.getInstance().getConnectionFast();
                    throwable2 = null;
                    try {
                        ps = con.prepareStatement(USER_INFO_SELECT);
                        throwable = null;
                        try {
                            ps.setString(1, Long.toString(System.currentTimeMillis()));
                            ps.setString(2, user);
                            rset = ps.executeQuery();
                            throwable3 = null;
                            try {
                                if (rset.next()) {
                                    expected = Base64.decode(rset.getString("password"));
                                    access = rset.getInt("accessLevel");
                                    lastServer = rset.getInt("lastServer");
                                    if (lastServer <= 0) {
                                        lastServer = 1;
                                    }
                                    if (Config.DEBUG) {
                                        _log.fine("account exists");
                                    }
                                }
                            }
                            catch (Throwable x2) {
                                throwable3 = x2;
                                throw x2;
                            }
                            finally {
                                if (rset != null) {
                                    if (throwable3 != null) {
                                        try {
                                            rset.close();
                                        }
                                        catch (Throwable x2) {
                                            throwable3.addSuppressed(x2);
                                        }
                                    } else {
                                        rset.close();
                                    }
                                }
                            }
                        }
                        catch (Throwable x2) {
                            throwable = x2;
                            throw x2;
                        }
                        finally {
                            if (ps != null) {
                                if (throwable != null) {
                                    try {
                                        ps.close();
                                    }
                                    catch (Throwable x2) {
                                        throwable.addSuppressed(x2);
                                    }
                                } else {
                                    ps.close();
                                }
                            }
                        }
                    }
                    catch (Throwable x2) {
                        throwable2 = x2;
                        throw x2;
                    }
                    finally {
                        if (con != null) {
                            if (throwable2 != null) {
                                try {
                                    con.close();
                                }
                                catch (Throwable x2) {
                                    throwable2.addSuppressed(x2);
                                }
                            } else {
                                con.close();
                            }
                        }
                    }
                    con = L2DatabaseFactory.getInstance().getConnectionFast();
                    throwable2 = null;
                    try {
                        ps = con.prepareStatement(ACCOUNT_IPAUTH_SELECT);
                        throwable = null;
                        try {
                            ps.setString(1, user);
                            rset = ps.executeQuery();
                            throwable3 = null;
                            block94: while (true) {
                                try {
                                    while (rset.next()) {
                                        String ip = rset.getString("ip");
                                        String type = rset.getString("type");
                                        if (!this.isValidIPAddress(ip)) continue;
                                        try {
                                            if (type.equals("allow")) {
                                                ipWhiteList.add(InetAddress.getByName(ip));
                                                continue block94;
                                            }
                                            if (!type.equals("deny")) continue block94;
                                            ipBlackList.add(InetAddress.getByName(ip));
                                            continue block94;
                                        }
                                        catch (UnknownHostException e) {
                                        }
                                    }
                                    break block156;
                                }
                                catch (Throwable throwable4) {
                                    throwable3 = throwable4;
                                    throw throwable4;
                                }
                            }
                            finally {
                                if (rset != null) {
                                    if (throwable3 != null) {
                                        try {
                                            rset.close();
                                        }
                                        catch (Throwable x2) {
                                            throwable3.addSuppressed(x2);
                                        }
                                    } else {
                                        rset.close();
                                    }
                                }
                            }
                        }
                        catch (Throwable x2) {
                            throwable = x2;
                            throw x2;
                        }
                        finally {
                            if (ps != null) {
                                if (throwable != null) {
                                    try {
                                        ps.close();
                                    }
                                    catch (Throwable x2) {
                                        throwable.addSuppressed(x2);
                                    }
                                } else {
                                    ps.close();
                                }
                            }
                        }
                    }
                    catch (Throwable x2) {
                        throwable2 = x2;
                        throw x2;
                    }
                    finally {
                        if (con != null) {
                            if (throwable2 != null) {
                                try {
                                    con.close();
                                }
                                catch (Throwable x2) {
                                    throwable2.addSuppressed(x2);
                                }
                            } else {
                                con.close();
                            }
                        }
                    }
                }
                if (expected == null) {
                    if (Config.AUTO_CREATE_ACCOUNTS) {
                        if (user.length() >= 2 && user.length() <= 14) {
                            con = L2DatabaseFactory.getInstance().getConnectionFast();
                            throwable2 = null;
                            try {
                                ps = con.prepareStatement(AUTOCREATE_ACCOUNTS_INSERT);
                                throwable = null;
                                try {
                                    ps.setString(1, user);
                                    ps.setString(2, Base64.encodeBytes(hash));
                                    ps.setLong(3, System.currentTimeMillis());
                                    ps.setInt(4, 0);
                                    ps.setString(5, address.getHostAddress());
                                    ps.execute();
                                }
                                catch (Throwable x2) {
                                    throwable = x2;
                                    throw x2;
                                }
                                finally {
                                    if (ps != null) {
                                        if (throwable != null) {
                                            try {
                                                ps.close();
                                            }
                                            catch (Throwable x2) {
                                                throwable.addSuppressed(x2);
                                            }
                                        } else {
                                            ps.close();
                                        }
                                    }
                                }
                            }
                            catch (Throwable x2) {
                                throwable2 = x2;
                                throw x2;
                            }
                            finally {
                                if (con != null) {
                                    if (throwable2 != null) {
                                        try {
                                            con.close();
                                        }
                                        catch (Throwable x2) {
                                            throwable2.addSuppressed(x2);
                                        }
                                    } else {
                                        con.close();
                                    }
                                }
                            }
                            if (Config.LOG_LOGIN_CONTROLLER) {
                                Log.add("'" + user + "' " + address.getHostAddress() + " - OK : AccountCreate", "loginlog");
                            }
                            _log.info("Created new account for " + user);
                            return true;
                        }
                        if (Config.LOG_LOGIN_CONTROLLER) {
                            Log.add("'" + user + "' " + address.getHostAddress() + " - ERR : ErrCreatingACC", "loginlog");
                        }
                        _log.warning("Invalid username creation/use attempt: " + user);
                    } else {
                        int failedCount;
                        if (Config.LOG_LOGIN_CONTROLLER) {
                            Log.add("'" + user + "' " + address.getHostAddress() + " - ERR : AccountMissing", "loginlog");
                        }
                        _log.warning("Account missing for user " + user);
                        FailedLoginAttempt failedAttempt = this._hackProtection.get(address);
                        if (failedAttempt == null) {
                            this._hackProtection.put(address, new FailedLoginAttempt(address, password));
                            failedCount = 1;
                        } else {
                            failedAttempt.increaseCounter();
                            failedCount = failedAttempt.getCount();
                        }
                        if (failedCount >= Config.LOGIN_TRY_BEFORE_BAN) {
                            _log.info("Banning '" + address.getHostAddress() + "' for " + Config.LOGIN_BLOCK_AFTER_BAN + " seconds due to " + failedCount + " invalid user name attempts");
                            this.addBanForAddress(address, (long)(Config.LOGIN_BLOCK_AFTER_BAN * 1000));
                        }
                    }
                    loginFailReason[0] = LoginFail.LoginFailReason.REASON_USER_OR_PASS_WRONG;
                    return false;
                }
                if (access < 0) {
                    if (Config.LOG_LOGIN_CONTROLLER) {
                        Log.add("'" + user + "' " + address.getHostAddress() + " - ERR : AccountBanned", "loginlog");
                    }
                    client.setAccessLevel(access);
                    return false;
                }
                if (!ipWhiteList.isEmpty() || !ipBlackList.isEmpty()) {
                    if (!ipWhiteList.isEmpty() && !ipWhiteList.contains(address)) {
                        if (Config.LOG_LOGIN_CONTROLLER) {
                            Log.add("'" + user + "' " + address.getHostAddress() + " - ERR : INCORRECT IP", "loginlog");
                        }
                        loginFailReason[0] = LoginFail.LoginFailReason.REASON_RESTRICTED_IP;
                        return false;
                    }
                    if (!ipBlackList.isEmpty() && ipBlackList.contains(address)) {
                        if (Config.LOG_LOGIN_CONTROLLER) {
                            Log.add("'" + user + "' " + address.getHostAddress() + " - ERR : BLACKLISTED IP", "loginlog");
                        }
                        loginFailReason[0] = LoginFail.LoginFailReason.REASON_RESTRICTED_IP;
                        return false;
                    }
                }
                if (!(ok = Arrays.equals(hash, expected))) break block158;
                client.setAccessLevel(access);
                client.setLastServer(lastServer);
                con = L2DatabaseFactory.getInstance().getConnectionFast();
                throwable2 = null;
                try {
                    ps = con.prepareStatement(ACCOUNT_INFO_UPDATE);
                    throwable = null;
                    try {
                        ps.setLong(1, System.currentTimeMillis());
                        ps.setString(2, address.getHostAddress());
                        ps.setString(3, user);
                        ps.execute();
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                    finally {
                        if (ps != null) {
                            if (throwable != null) {
                                try {
                                    ps.close();
                                }
                                catch (Throwable x2) {
                                    throwable.addSuppressed(x2);
                                }
                            } else {
                                ps.close();
                            }
                        }
                    }
                }
                catch (Throwable throwable6) {
                    throwable2 = throwable6;
                    throw throwable6;
                }
                finally {
                    if (con != null) {
                        if (throwable2 != null) {
                            try {
                                con.close();
                            }
                            catch (Throwable x2) {
                                throwable2.addSuppressed(x2);
                            }
                        } else {
                            con.close();
                        }
                    }
                }
            }
            catch (NoSuchAlgorithmException | SQLException e) {
                _log.log(Level.WARNING, "Could not check password.", e);
                loginFailReason[0] = LoginFail.LoginFailReason.REASON_SYSTEM_ERROR_LOGIN_LATER;
                ok = false;
            }
        }
        if (!ok) {
            int failedCount;
            FailedLoginAttempt failedAttempt;
            if (Config.LOG_LOGIN_CONTROLLER) {
                Log.add("'" + user + "' " + address.getHostAddress() + " - ERR : LoginFailed", "loginlog");
            }
            if ((failedAttempt = this._hackProtection.get(address)) == null) {
                this._hackProtection.put(address, new FailedLoginAttempt(address, password));
                failedCount = 1;
            } else {
                failedAttempt.increaseCounter(password);
                failedCount = failedAttempt.getCount();
            }
            if (failedCount >= Config.LOGIN_TRY_BEFORE_BAN) {
                _log.info("Banning '" + address.getHostAddress() + "' for " + Config.LOGIN_BLOCK_AFTER_BAN + " seconds due to " + failedCount + " invalid user/pass attempts");
                this.addBanForAddress(address, (long)(Config.LOGIN_BLOCK_AFTER_BAN * 1000));
            }
        } else {
            this._hackProtection.remove(address);
            if (Config.LOG_LOGIN_CONTROLLER) {
                Log.add("'" + user + "' " + address.getHostAddress() + " - OK : LoginOk", "loginlog");
            }
        }
        return ok;
    }

    public boolean isValidIPAddress(String ipAddress) {
        String[] parts = ipAddress.split("\\.");
        if (parts.length != 4) {
            return false;
        }
        for (String s : parts) {
            int i = Integer.parseInt(s);
            if (i >= 0 && i <= 255) continue;
            return false;
        }
        return true;
    }

    public int getUserLevel(String account) {
        int ret = 0;
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement statement = con.prepareStatement("SELECT userLevel FROM accounts WHERE login=?");){
            statement.setString(1, account);
            ResultSet rset = statement.executeQuery();
            if (rset.next()) {
                ret = rset.getInt(1);
            }
        }
        catch (SQLException e) {
            _log.log(Level.WARNING, "could not check userlevel state:", e);
        }
        return ret;
    }

    public boolean isIPinBanList(String user, String address) {
        boolean ok = false;
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement statement = con.prepareStatement("SELECT login FROM accounts WHERE lastIP=? and accessLevel = -100");){
            statement.setString(1, address);
            ResultSet rset = statement.executeQuery();
            if (rset.next()) {
                ok = true;
                _log.warning("connection from IP exists in BAN List (ID:" + user + ", IP:" + address + ")");
            }
        }
        catch (SQLException e) {
            _log.log(Level.WARNING, "could not check IP in BanList:", e);
        }
        return ok;
    }

    class PurgeThread
    extends Thread {
        public PurgeThread() {
            this.setName("PurgeThread");
        }

        @Override
        public void run() {
            while (!this.isInterrupted()) {
                for (L2LoginClient client : LoginController.this._loginServerClients.values()) {
                    if (client == null || client.getConnectionStartTime() + 60000L >= System.currentTimeMillis()) continue;
                    client.close(LoginFail.LoginFailReason.REASON_ACCESS_FAILED);
                }
                try {
                    Thread.sleep(30000L);
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        }
    }

    class BanInfo {
        private final InetAddress _ipAddress;
        private final long _expiration;

        public BanInfo(InetAddress ipAddress, long expiration) {
            this._ipAddress = ipAddress;
            this._expiration = expiration;
        }

        public InetAddress getAddress() {
            return this._ipAddress;
        }

        public boolean hasExpired() {
            return System.currentTimeMillis() > this._expiration && this._expiration > 0L;
        }
    }

    class FailedLoginAttempt {
        private int _count = 1;
        private long _lastAttempTime = System.currentTimeMillis();
        private String _lastPassword;

        public FailedLoginAttempt(InetAddress address, String lastPassword) {
            this._lastPassword = lastPassword;
        }

        public void increaseCounter(String password) {
            if (!this._lastPassword.equals(password)) {
                this._count = System.currentTimeMillis() - this._lastAttempTime < 300000L ? ++this._count : 1;
                this._lastPassword = password;
                this._lastAttempTime = System.currentTimeMillis();
            } else {
                this._lastAttempTime = System.currentTimeMillis();
            }
        }

        public int getCount() {
            return this._count;
        }

        public void increaseCounter() {
            ++this._count;
        }
    }

    public static enum AuthLoginResult {
        INVALID_PASSWORD,
        ACCOUNT_BANNED,
        ALREADY_IPADDR,
        ALREADY_ON_LS,
        ALREADY_ON_GS,
        AUTH_SUCCESS;

    }
}

