/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.loginserver.mail;

import com.l2jserver.Config;
import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.loginserver.mail.MailSystem;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Properties;
import java.util.logging.Logger;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;

public class BaseMail
implements Runnable {
    private static final Logger _log = Logger.getLogger(BaseMail.class.getName());
    private final Properties _mailProp = new Properties();
    private final SmtpAuthenticator _authenticator;
    private MimeMessage _messageMime = null;

    public BaseMail(String account, String mailId, String ... args) {
        this._mailProp.put("mail.smtp.host", Config.EMAIL_SYS_HOST);
        this._mailProp.put("mail.smtp.auth", (Object)Config.EMAIL_SYS_SMTP_AUTH);
        this._mailProp.put("mail.smtp.port", (Object)Config.EMAIL_SYS_PORT);
        this._mailProp.put("mail.smtp.socketFactory.port", (Object)Config.EMAIL_SYS_PORT);
        this._mailProp.put("mail.smtp.socketFactory.class", Config.EMAIL_SYS_FACTORY);
        this._mailProp.put("mail.smtp.socketFactory.fallback", (Object)Config.EMAIL_SYS_FACTORY_CALLBACK);
        this._authenticator = Config.EMAIL_SYS_SMTP_AUTH ? new SmtpAuthenticator() : null;
        String mailAddr = this.getUserMail(account);
        if (mailAddr == null) {
            return;
        }
        MailSystem.MailContent content = MailSystem.getInstance().getMailContent(mailId);
        if (content == null) {
            return;
        }
        String message = this.compileHtml(account, content.getText(), args);
        Session mailSession = Session.getDefaultInstance((Properties)this._mailProp, (Authenticator)this._authenticator);
        try {
            this._messageMime = new MimeMessage(mailSession);
            this._messageMime.setSubject(content.getSubject());
            try {
                this._messageMime.setFrom((Address)new InternetAddress(Config.EMAIL_SYS_ADDRESS, Config.EMAIL_SERVERINFO_NAME));
            }
            catch (UnsupportedEncodingException e) {
                _log.warning("Sender Address not Valid!");
            }
            this._messageMime.setContent((Object)message, "text/html");
            this._messageMime.setRecipient(Message.RecipientType.TO, (Address)new InternetAddress(mailAddr));
        }
        catch (MessagingException e) {
            _log.warning(this.getClass().getSimpleName() + ": " + e.getMessage());
        }
    }

    private String compileHtml(String account, String html, String[] args) {
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                html = html.replace("%var" + i + "%", args[i]);
            }
        }
        html = html.replace("%accountname%", account);
        return html;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getUserMail(String username) {
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement statement = con.prepareStatement(Config.EMAIL_SYS_SELECTQUERY);){
            statement.setString(1, username);
            try (ResultSet rset = statement.executeQuery();){
                String mail;
                if (!rset.next()) return null;
                String string = mail = rset.getString(Config.EMAIL_SYS_DBFIELD);
                return string;
            }
        }
        catch (Exception e) {
            _log.warning("Cannot select user mail: Exception");
        }
        return null;
    }

    @Override
    public void run() {
        try {
            if (this._messageMime != null) {
                Transport.send((Message)this._messageMime);
            }
        }
        catch (MessagingException e) {
            _log.warning("Error encounterd while sending email");
        }
    }

    private class SmtpAuthenticator
    extends Authenticator {
        private final PasswordAuthentication _auth = new PasswordAuthentication(Config.EMAIL_SYS_USERNAME, Config.EMAIL_SYS_PASSWORD);

        public PasswordAuthentication getPasswordAuthentication() {
            return this._auth;
        }
    }
}

