/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.util;

import com.l2jserver.gameserver.geoengine.Direction;

public final class GeoUtils {
    public static boolean forEachLinePoint(int srcX, int srcY, int dstX, int dstY, PointListener listener) {
        int dx = Math.abs(dstX - srcX);
        int sx = srcX < dstX ? 1 : -1;
        int dy = -Math.abs(dstY - srcY);
        int sy = srcY < dstY ? 1 : -1;
        int err = dx + dy;
        while (true) {
            if (!listener.onPoint(srcX, srcY)) {
                return false;
            }
            if (srcX == dstX && srcY == dstY) break;
            int e2 = 2 * err;
            if (e2 > dy) {
                err += dy;
                srcX += sx;
            }
            if (e2 >= dx) continue;
            err += dx;
            srcY += sy;
        }
        return true;
    }

    public static Direction computeDirection(int lastX, int lastY, int x, int y) {
        if (x > lastX) {
            if (y > lastY) {
                return Direction.SOUTH_EAST;
            }
            if (y < lastY) {
                return Direction.NORTH_EAST;
            }
            return Direction.EAST;
        }
        if (x < lastX) {
            if (y > lastY) {
                return Direction.SOUTH_WEST;
            }
            if (y < lastY) {
                return Direction.NORTH_WEST;
            }
            return Direction.WEST;
        }
        if (y > lastY) {
            return Direction.SOUTH;
        }
        if (y < lastY) {
            return Direction.NORTH;
        }
        return null;
    }

    public static interface PointListener {
        public boolean onPoint(int var1, int var2);
    }
}

