/*
 * Copyright (C) 2005-2008 L2J_JP / 2008-2013 L2J-SFJP
 * 
 * This file is part of L2J Server.
 * 
 * L2J Server is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * L2J Server is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package ai.npc.NpcBuffers.impl;

import static ai.npc.NpcBuffers.impl.NpcBuffUtil.*;
import static com.l2jserver.gameserver.datatables.SkillData.*;

import java.util.concurrent.ScheduledFuture;

import ai.npc.AbstractNpcAI;

import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.instancemanager.ZoneManager;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.skills.AbnormalType;
import com.l2jserver.gameserver.model.skills.EffectScope;
import com.l2jserver.gameserver.model.skills.Skill;
import com.l2jserver.gameserver.model.skills.targets.L2TargetType;
import com.l2jserver.gameserver.model.zone.type.L2TownZone;

//@formatter:off
/**
 * @author JOJO
 * 
 * NPC          148     
 * |ACe    21875   Ηp̉ΑŐ - 30ԂŎgƕ΂܂B苗ȏ㗣ꂽꏊŕ΂Ɖ񕜃{[iXʂ܂B퓬nł͉񕜗͂オ܂Bg[hAhbvAj͂ł܂Blqɂւ̕ۊǂ͂ł܂B
 * |            1864    (30)
 * |XL  22305-1 Ώ
 * |BUFXL   22304-1 ΂̉ - ΂̉肪܂BHP񕜗͂80%ACP񕜗͂60%AMP񕜗͂40܂B
 */
public class CampfireBuffer extends AbstractNpcAI
{
	private static final int CAMPFIRE = 148;
	private static final int FIRE_EFFECT_BURN = 1;
	
	static final int CAMPFIRE_WARMTH = getSkillHashCode(22304, 1);
	
	private CampfireBuffer()
	{
		super(CampfireBuffer.class.getSimpleName(), "ai/npc/NpcBuffers/impl");
		addFirstTalkId(CAMPFIRE);
		addSpawnId(CAMPFIRE);
		
		if (NOTDONE(getSkill(CAMPFIRE_WARMTH))) throw new RuntimeException();
	}
	
	private boolean NOTDONE(Skill skill)
	{
		return skill.getTargetType() == L2TargetType.NONE && skill.getAbnormalType() == AbnormalType.NONE && skill.getEffects(EffectScope.GENERAL) == null;
	}
	
	@Override
	public String onFirstTalk(L2Npc npc, L2PcInstance player)
	{
		return null;
	}
	
	@Override
	public String onSpawn(L2Npc npc)
	{
		npc.setShowSummonAnimation(false);
		
		if (ZoneManager.getInstance().getZone(npc, L2TownZone.class) == null
	  /* && ZoneManager.getInstance().getZone(npc, L2****Zone.class) != null*/) //TODO: "퓬nł͉񕜗͂オ܂B"
		{
			new CampfireAI(npc);
			npc.setDisplayEffect(FIRE_EFFECT_BURN); // fire burns
		}
		return null;
	}
	
	private static class CampfireAI implements Runnable
	{
		private final L2Npc _npc;
		private final ScheduledFuture<?> _aiTask;
		
		protected CampfireAI(L2Npc npc)
		{
			_npc = npc;
			_aiTask = ThreadPoolManager.getInstance().scheduleGeneralWithFixedDelay(this, 3000, 3000);
		}
		
		@Override
		public void run()
		{
			if (!_npc.isVisible())
			{
				_aiTask.cancel(false);
				return;
			}
			
			if (_npc.getKnownList().getKnownPlayers().size() == 0)
				return;
			
			final Skill campfireWarmth = getSkill(CAMPFIRE_WARMTH);
			final int skillRadius = campfireWarmth.getAffectRange();
			for (L2PcInstance player : _npc.getKnownList().getKnownPlayers().values())
			{
				if (player == null || !player.isVisible() || player.isInvul() || player.isMovementDisabled())
					continue;
				if (player.getPkKills() > 5)
					continue;
				if (!player.isInsideRadius(_npc, skillRadius, true, true))
					continue;
				if (player.getCurrentHp() < player.getMaxHp()
				 || player.getCurrentCp() < player.getMaxCp()
				 || player.getCurrentMp() < player.getMaxMp())
				{
					handleEffect(player, campfireWarmth);
				}
			}
		}
	}
	
	public static void main(String[] args)
	{
		new CampfireBuffer();
	}
}
