/*
 * Copyright (C) 2004-2014 L2J DataPack
 * 
 * This file is part of L2J DataPack.
 * 
 * L2J DataPack is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * L2J DataPack is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package events.FreyaCelebration;

import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.event.LongTimeEvent;
import com.l2jserver.gameserver.model.itemcontainer.Inventory;
import com.l2jserver.gameserver.model.quest.QuestState;
import com.l2jserver.gameserver.model.quest.State;
import com.l2jserver.gameserver.model.skills.Skill;
import com.l2jserver.gameserver.network.NpcStringId;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.Say2;
import com.l2jserver.gameserver.network.serverpackets.NpcSay;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.util.Util;

/**
 * Freya Celebration event AI.
 * @author Gnacik
 */
public final class FreyaCelebration extends LongTimeEvent
{
	// NPC
	private static final int FREYA = 13296;	// Cxgis
	// Items
	private static final int FREYA_POTION = 15440;	// oC^eBێ30|[V
	private static final int FREYA_GIFT = 17138;	// t̃v[g
		// ACe 17138 t̃v[g
		//     ItemSkills: 9158-1 t̃v[g (t̐S߂ꂽMtg {bNXBg[hAhbv͂ł܂B)
		//         capsuled_items_skill:
		//             16026 jꂽt lbNX
		//              9627 l̔`Fn
		//             17139 ϐgXN[FAiLi30j
		//             17140 ϐgXN[FUPi30j
		//             14052 xXym[u
		//              6622 l̔`
		//              2134 WFXg[FSO[h
		//             14701 ͏uԑ̗͉񕜍
	
	// Misc
	private static final int HOURS = 20;
	
	private static final int[] SKILLS =
	{
		9150,	// (ACe 17130) t[WẢԑFCxg (t[WẢԑBԌt͂ǂȂB)
		9151,	// (ACe 17131) JX~̉ԑFCxg (JX~̉ԑBԌt͐؂ȂvB)
		9152,	// (ACe 17132) sN fBFCxg (1912NAhŏ㉉đD]𓾂usNfBv̋LOp[eBŃqCɕꂽJNeB)
		9153,	// (ACe 17133) W[ oOFCxg (6̒ƂӖ̃JNeBԂ̍ɌĂъ񂹂悤ɁAΖLȉĂ̂₩ƊÂ肪͓IB)
		9154,	// (ACe 17134) 炩`[YP[LFCxg (ÂTڂŁAXt̂悤ɖcłĂӂӂƂō`[YP[LB)
		9155,	// (ACe 17135) ĂăoQbgFCxg ({̌łoQbgƂ͈āA``ďĂĂ̍YoQbgB)
		9156,	// (ACe 17136) ÂN[pFCxg (̉gōÂJX^[hՂ̃N[pB)
		9157,	// (ACe 17137) zCgf[ LfBFCxg (v[gƒNɂł΂邩킢LfBB)
	};
	
	private static final NpcStringId[] FREYA_TEXT =
	{
		NpcStringId.EVEN_THOUGH_YOU_BRING_SOMETHING_CALLED_A_GIFT_AMONG_YOUR_HUMANS_IT_WOULD_JUST_BE_PROBLEMATIC_FOR_ME,
		NpcStringId.I_JUST_DONT_KNOW_WHAT_EXPRESSION_I_SHOULD_HAVE_IT_APPEARED_ON_ME_ARE_HUMANS_EMOTIONS_LIKE_THIS_FEELING,
		NpcStringId.THE_FEELING_OF_THANKS_IS_JUST_TOO_MUCH_DISTANT_MEMORY_FOR_ME,
		NpcStringId.BUT_I_KIND_OF_MISS_IT_LIKE_I_HAD_FELT_THIS_FEELING_BEFORE,
		NpcStringId.I_AM_ICE_QUEEN_FREYA_THIS_FEELING_AND_EMOTION_ARE_NOTHING_BUT_A_PART_OF_MELISSAA_MEMORIES
	};
	
	private static final NpcStringId[] GIFT_TEXT = 
	{
		NpcStringId.DEAR_S1_THINK_OF_THIS_AS_MY_APPRECIATION_FOR_THE_GIFT_TAKE_THIS_WITH_YOU_THERES_NOTHING_STRANGE_ABOUT_IT_ITS_JUST_A_BIT_OF_MY_CAPRICIOUSNESS,
		NpcStringId.THE_KINDNESS_OF_SOMEBODY_IS_NOT_A_BAD_FEELING_DEAR_S1_I_WILL_TAKE_THIS_GIFT_OUT_OF_RESPECT_YOUR_KINDNESS,
	};
	
	private FreyaCelebration()
	{
		super(FreyaCelebration.class.getSimpleName(), "events");
		addStartNpc(FREYA);
		addFirstTalkId(FREYA);
		addTalkId(FREYA);
		addSkillSeeId(FREYA);
	}
	
	@Override
	public String onAdvEvent(String event, L2Npc npc, L2PcInstance player)
	{
		QuestState st = player.getQuestState(getName());
		if (st == null)
		{
			return null;
		}
		
		if (event.equalsIgnoreCase("give_potion"))
		{
			if (st.getQuestItemsCount(Inventory.ADENA_ID) > 1)
			{
				final long now = System.currentTimeMillis();
//TODO:			final String streuse = st.get("reuse");
//TODO:			final long reuseTime = streuse == null ? 0 : Long.parseLong(streuse);
				final String value = loadGlobalQuestVar(player.getAccountName());
				final long reuseTime = value == "" ? 0 : Long.parseLong(value);
				
				if (now > reuseTime)
				{
					st.setState(State.STARTED);
					st.takeItems(Inventory.ADENA_ID, 1);
					st.giveItems(FREYA_POTION, 1);
//TODO:				st.set("reuse", String.valueOf(now + HOURS * 3600000));
					saveGlobalQuestVar(player.getAccountName(), Long.toString(now + (HOURS * 3600000)));
				}
				else
				{
					final long remainingTime = reuseTime - now + 59999;	// ceil
					final int hours = (int) (remainingTime / 3600000L);
					final int minutes = (int) (remainingTime / 60000L % 60);
					SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.AVAILABLE_AFTER_S1_S2_HOURS_S3_MINUTES);
					sm.addItemName(FREYA_POTION);
					sm.addInt(hours);
					sm.addInt(minutes);
					player.sendPacket(sm);
				}
			}
			else
			{
				player.sendPacket(SystemMessageId.YOU_NOT_ENOUGH_ADENA);	//[JOJO]
			//	SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S2_UNIT_OF_THE_ITEM_S1_REQUIRED);
			//	sm.addItemName(Inventory.ADENA_ID);
			//	sm.addInt(1);
			//	player.sendPacket(sm);
			}
		}
		return null;
	}
	
	@Override
	public String onSkillSee(L2Npc npc, L2PcInstance caster, Skill skill, L2Object[] targets, boolean isSummon)
	{
		if ((caster == null) || (npc == null))
		{
			return null;
		}
		
		if ((npc.getId() == FREYA) && Util.contains(targets, npc) && Util.contains(SKILLS, skill.getId()))
		{
			if (getRandom(100) < 5)
			{
				NpcSay cs = new NpcSay(npc.getObjectId(), Say2.NPC_ALL, npc.getId(), GIFT_TEXT[getRandom(GIFT_TEXT.length)]);
				cs.addPcName(caster);
				
				npc.broadcastPacket(cs);
				
				caster.addItem("FreyaCelebration", FREYA_GIFT, 1, npc, true);
			}
			else
			{
				if (getRandom(10) < 2)
				{
					npc.broadcastPacket(new NpcSay(npc.getObjectId(), Say2.NPC_ALL, npc.getId(), FREYA_TEXT[getRandom(FREYA_TEXT.length)]));
				}
			}
		}
		return super.onSkillSee(npc, caster, skill, targets, isSummon);
	}
	
	@Override
	public String onFirstTalk(L2Npc npc, L2PcInstance player)
	{
		if (player.getQuestState(getName()) == null)
		{
			newQuestState(player);
		}
		return "13296.htm";
	}
	
	public static void main(String[] args)
	{
		new FreyaCelebration();
	}
}
