/*
 * Copyright (C) 2004-2014 L2J DataPack
 * 
 * This file is part of L2J DataPack.
 * 
 * L2J DataPack is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * L2J DataPack is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package handlers.admincommandhandlers;

import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.cache.HtmCache;
import com.l2jserver.gameserver.handler.IAdminCommandHandler;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.NpcHtmlMessage;
import com.l2jserver.gameserver.network.serverpackets.SpecialCamera;

/**
 * Camera commands.
 * @author Zoey76
 */
public class AdminCamera implements IAdminCommandHandler
{
	private static final String[] ADMIN_COMMANDS =
	{
		"admin_camera",
		"admin_cam",
		"admin_camex",
		"admin_cam3"
	};
	
	@Override
	public boolean useAdminCommand(String command, L2PcInstance activeChar)
	{
		//[JOJO]-------------------------------------------------
		if (command.startsWith("admin_camera"))
		{
			if (command.equals("admin_camera")) return showCameraHtml(activeChar);	/* "//camera" */
			if (command.contains(" | ")) return useCameraHtml(command, activeChar);	/* "admin_camera | 1000 | 10 | ...." */
			// AdminCamera.java r9377
			try
			{
				final L2Character target = (L2Character) activeChar.getTarget();
				final String[] com = command.split(" ");
				
				target.broadcastPacket(new SpecialCamera(target.getObjectId(), Integer.parseInt(com[1]), Integer.parseInt(com[2]), Integer.parseInt(com[3]), Integer.parseInt(com[4]), Integer.parseInt(com[5]), Integer.parseInt(com[6]), Integer.parseInt(com[7]), Integer.parseInt(com[8]), Integer.parseInt(com[9])));
			}
			catch (Exception e)
			{
				activeChar.sendMessage("Usage: //camera distance yaw pitch time duration turn rise widescreen unknown");
				return false;
			}
			return true;
		}
		//-------------------------------------------------------
		
		if ((activeChar.getTarget() == null) || !activeChar.getTarget().isCharacter())
		{
			activeChar.sendPacket(SystemMessageId.TARGET_CANT_FOUND);
			return false;
		}
		
		final L2Character target = (L2Character) activeChar.getTarget();
		final String[] com = command.split(" ");
		switch (com[0])
		{
			case "admin_cam":
			{
				if (com.length != 11)
				{
					activeChar.sendMessage("Usage: //cam force angle1 angle2 time range duration relYaw relPitch isWide relAngle");
					return false;
				}
				activeChar.sendPacket(new SpecialCamera(target, Integer.parseInt(com[1]), Integer.parseInt(com[2]), Integer.parseInt(com[3]), Integer.parseInt(com[4]), Integer.parseInt(com[5]), Integer.parseInt(com[6]), Integer.parseInt(com[7]), Integer.parseInt(com[8]), Integer.parseInt(com[9]), Integer.parseInt(com[10]), 0));
				break;
			}
			case "admin_camex":
			{
				if (com.length != 10)
				{
					activeChar.sendMessage("Usage: //camex force angle1 angle2 time duration relYaw relPitch isWide relAngle");
					return false;
				}
				activeChar.sendPacket(new SpecialCamera(target, Integer.parseInt(com[1]), Integer.parseInt(com[2]), Integer.parseInt(com[3]), Integer.parseInt(com[4]), 0, Integer.parseInt(com[5]), Integer.parseInt(com[6]), Integer.parseInt(com[7]), Integer.parseInt(com[8]), Integer.parseInt(com[9]), 0));
				break;
			}
			case "admin_cam3":
			{
				if (com.length != 12)
				{
					activeChar.sendMessage("Usage: //cam3 force angle1 angle2 time range duration relYaw relPitch isWide relAngle unk");
					return false;
				}
				activeChar.sendPacket(new SpecialCamera(target, Integer.parseInt(com[1]), Integer.parseInt(com[2]), Integer.parseInt(com[3]), Integer.parseInt(com[4]), Integer.parseInt(com[5]), Integer.parseInt(com[6]), Integer.parseInt(com[7]), Integer.parseInt(com[8]), Integer.parseInt(com[9]), Integer.parseInt(com[10]), Integer.parseInt(com[11])));
				break;
			}
		}
		return true;
	}
	
	//[JOJO]-------------------------------------------------
	protected static class AdminCameraValues { public int distance, yaw, pitch, time, duration, turn, rise, widescreen, heading, unknown; }
	private jp.sf.l2j.troja.FastIntObjectMap<AdminCameraValues> _cameraParamPool = new jp.sf.l2j.troja.FastIntObjectMap<>();

	private boolean useCameraHtml(String command, L2PcInstance activeChar)
	{
		try
		{
			final L2Character target = (L2Character)activeChar.getTarget();
			String[] com = command.split(" *\\| *", 11);
			if (com.length != 11)
				throw new RuntimeException();
			AdminCameraValues camera = _cameraParamPool.get(activeChar.getObjectId());
			if (camera == null) camera = new AdminCameraValues();
			camera.distance = parseInt(com[1], camera.distance);
			camera.yaw = parseInt(com[2], camera.yaw);
			camera.pitch = parseInt(com[3], camera.pitch);
			camera.time = parseInt(com[4], camera.time);
			camera.duration = parseInt(com[5], camera.duration);
			camera.turn = parseInt(com[6], camera.turn);
			camera.rise = parseInt(com[7], camera.rise);
			camera.widescreen = parseInt(com[8], camera.widescreen);
			camera.heading = parseInt(com[9], camera.heading);
			camera.unknown = parseInt(com[10], camera.unknown);

			target.broadcastPacket(new SpecialCamera(target.getObjectId()
					, camera.distance, camera.yaw, camera.pitch, camera.time, camera.duration, camera.turn, camera.rise, camera.widescreen, camera.heading, camera.unknown));
			_cameraParamPool.put(activeChar.getObjectId(), camera);
			class $ implements Runnable {
				final L2PcInstance activeChar;
				$(L2PcInstance activeChar) {this.activeChar = activeChar;}
				@Override public void run(){showCameraHtml(activeChar);}
			}
			ThreadPoolManager.getInstance().scheduleGeneral(new $(activeChar), camera.duration + 1000);
		}
		catch (Exception e)
		{
			activeChar.sendMessage("Usage: //camera distance yaw pitch time duration turn rise widescreen heading unknown");
			return false;
		}
		return true;
	}

	private int parseInt(String key, int defaultValue)
	{
		try {
			return Integer.parseInt(key);
		} catch (NumberFormatException e) {
			return defaultValue;
		}
	}

	protected boolean showCameraHtml(L2PcInstance activeChar)
	{
		NpcHtmlMessage adminReply = new NpcHtmlMessage();
		String content = HtmCache.getInstance().getHtm(activeChar.getHtmlPrefix(), "data/html/admin/camera.htm");
		
		AdminCameraValues camera = _cameraParamPool.get(activeChar.getObjectId());
		if (camera == null) {
			content = content.replaceAll("%\\w+?%", "");
			adminReply.setHtml(content);
		}
		else
		{
			adminReply.setHtml(content);
			adminReply.replace("%distance%", camera.distance);
			adminReply.replace("%yaw%", camera.yaw);
			adminReply.replace("%pitch%", camera.pitch);
			adminReply.replace("%time%", camera.time);
			adminReply.replace("%duration%", camera.duration);
			adminReply.replace("%turn%", camera.turn);
			adminReply.replace("%rise%", camera.rise);
			adminReply.replace("%widescreen%", camera.widescreen);
			adminReply.replace("%heading%", camera.heading);
			adminReply.replace("%unknown%", camera.unknown);
		}

		activeChar.sendPacket(adminReply);
		return true;
	}
	//-------------------------------------------------------
	
	@Override
	public String[] getAdminCommandList()
	{
		return ADMIN_COMMANDS;
	}
}