/*
 * Copyright (C) 2004-2014 L2J DataPack
 * 
 * This file is part of L2J DataPack.
 * 
 * L2J DataPack is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * L2J DataPack is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package handlers.admincommandhandlers;

import java.util.Calendar;
import java.util.StringTokenizer;

import com.l2jserver.gameserver.datatables.ClanTable;
import com.l2jserver.gameserver.handler.IAdminCommandHandler;
import com.l2jserver.gameserver.instancemanager.AuctionManager;
import com.l2jserver.gameserver.instancemanager.CHSiegeManager;
import com.l2jserver.gameserver.instancemanager.CastleManager;
import com.l2jserver.gameserver.instancemanager.ClanHallManager;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.entity.Castle;
import com.l2jserver.gameserver.model.entity.ClanHall;
import com.l2jserver.gameserver.model.entity.clanhall.SiegableHall;
import com.l2jserver.gameserver.model.zone.type.L2ClanHallZone;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.NpcHtmlMessage;
import com.l2jserver.gameserver.util.Util;
import com.l2jserver.util.StringUtil;

/**
 * This class handles all siege commands.
 * @author Zoey76 (rework)
 */
public class AdminSiege implements IAdminCommandHandler
{
	private static final String[] ADMIN_COMMANDS =
	{
		// Castle commands
		"admin_siege",
		"admin_add_attacker",
		"admin_add_defender",
		"admin_add_guard",
		"admin_list_siege_clans",
		"admin_clear_siege_list",
		"admin_move_defenders",
		"admin_spawn_doors",
		"admin_endsiege",
		"admin_startsiege",
		"admin_setsiegetime",
		"admin_setcastle",
		"admin_removecastle",
		// Clan hall commands
		"admin_clanhall",
		"admin_clanhallset",
		"admin_clanhalldel",
		"admin_clanhallopendoors",
		"admin_clanhallclosedoors",
		"admin_clanhallteleportself"
	};
	
	@Override
	public boolean useAdminCommand(final String _command, L2PcInstance activeChar)
	{
		StringTokenizer st = new StringTokenizer(_command, " ");
		String command = st.nextToken(); // Get actual command
		
		// Get castle
		Castle castle = null;
		ClanHall clanhall = null;
		if (st.hasMoreTokens())
		{
			L2PcInstance player = null;
			if ((activeChar.getTarget() != null) && activeChar.getTarget().isPlayer())
			{
				player = activeChar.getTarget().getActingPlayer();
			}
			
			String val = st.nextToken();
			if (command.startsWith("admin_clanhall"))
			{
				if (Util.isDigit(val))
				{
					clanhall = ClanHallManager.getInstance().getClanHallById(Integer.parseInt(val));
					L2Clan clan = null;
					switch (command)
					{
						case "admin_clanhallset":
							if ((player == null) || (player.getClan() == null))
							{
								activeChar.sendPacket(SystemMessageId.INCORRECT_TARGET);
								return false;
							}
							
							if (clanhall.getOwnerId() > 0)
							{
								activeChar.sendMessage("This Clan Hall is not free!");
								return false;
							}
							
							clan = player.getClan();
							if (clan.getHideoutId() > 0)
							{
								activeChar.sendMessage("You have already a Clan Hall!");
								return false;
							}
							
							if (!clanhall.isSiegableHall())
							{
								ClanHallManager.getInstance().setOwner(clanhall.getId(), clan);
								if (AuctionManager.getInstance().getAuction(clanhall.getId()) != null)
								{
									AuctionManager.getInstance().getAuction(clanhall.getId()).deleteAuctionFromDB();
								}
							}
							else
							{
								clanhall.setOwner(clan);
								clan.setHideoutId(clanhall.getId());
							}
							break;
						case "admin_clanhalldel":
							
							if (!clanhall.isSiegableHall())
							{
								if (!ClanHallManager.getInstance().isFree(clanhall.getId()))
								{
									ClanHallManager.getInstance().setFree(clanhall.getId());
									AuctionManager.getInstance().initNPC(clanhall.getId());
								}
								else
								{
									activeChar.sendMessage("This Clan Hall is already free!");
								}
							}
							else
							{
								final int oldOwner = clanhall.getOwnerId();
								if (oldOwner > 0)
								{
									clanhall.free();
									clan = ClanTable.getInstance().getClan(oldOwner);
									if (clan != null)
									{
										clan.setHideoutId(0);
										clan.broadcastClanStatus();
									}
								}
							}
							break;
						case "admin_clanhallopendoors":
							clanhall.openCloseDoors(true);
							break;
						case "admin_clanhallclosedoors":
							clanhall.openCloseDoors(false);
							break;
						case "admin_clanhallteleportself":
							final L2ClanHallZone zone = clanhall.getZone();
							if (zone != null)
							{
								activeChar.teleToLocation(zone.getSpawnLoc(), true);
							}
							break;
						default:
							showClanHallPage(activeChar, clanhall);
							break;
					}
				}
			}
			else
			{
				castle = CastleManager.getInstance().getCastle(val);
				switch (command)
				{
					case "admin_add_attacker":
						if (player == null)
						{
							activeChar.sendPacket(SystemMessageId.INCORRECT_TARGET);
						}
						else
						{
							castle.getSiege().registerAttacker(player, true);
						}
						break;
					case "admin_add_defender":
						if (player == null)
						{
							activeChar.sendPacket(SystemMessageId.INCORRECT_TARGET);
						}
						else
						{
							castle.getSiege().registerDefender(player, true);
						}
						break;
					case "admin_add_guard":
						if (st.hasMoreTokens())
						{
							val = st.nextToken();
							if (Util.isDigit(val))
							{
								castle.getSiege().getSiegeGuardManager().addSiegeGuard(activeChar, Integer.parseInt(val));
								break;
							}
						}
						// If doesn't have more tokens or token is not a number.
						activeChar.sendMessage("Usage: //add_guard castle npcId");
						break;
					case "admin_clear_siege_list":
						castle.getSiege().clearSiegeClan();
						break;
					case "admin_endsiege":
						castle.getSiege().endSiege();
						break;
					case "admin_list_siege_clans":
						castle.getSiege().listRegisterClan(activeChar);
						break;
					case "admin_move_defenders":
						activeChar.sendMessage("Not implemented yet.");
						break;
					case "admin_setcastle":
						if ((player == null) || (player.getClan() == null))
						{
							activeChar.sendPacket(SystemMessageId.INCORRECT_TARGET);
						}
						else
						{
							castle.setOwner(player.getClan());
						}
						break;
					case "admin_removecastle":
						final L2Clan clan = ClanTable.getInstance().getClan(castle.getOwnerId());
						if (clan != null)
						{
							castle.removeOwner(clan);
						}
						else
						{
							activeChar.sendMessage("Unable to remove castle.");
						}
						break;
					case "admin_setsiegetime":
						// castlesiegetime.htm
						if (st.hasMoreTokens())
						{
							final Calendar cal = Calendar.getInstance();
							cal.setTimeInMillis(castle.getSiegeDate().getTimeInMillis());
							
							val = st.nextToken();
							
							if ("month".equals(val))
							{
								cal.add(Calendar.MONTH, Integer.parseInt(st.nextToken()));
							}
							else if ("day+".equals(val))
							{
								cal.add(Calendar.DAY_OF_MONTH, Integer.parseInt(st.nextToken()));
							}
							else if ("day".equals(val))
							{
								int day = Integer.parseInt(st.nextToken());
								if ((cal.getActualMinimum(Calendar.DAY_OF_MONTH) > day) || (cal.getActualMaximum(Calendar.DAY_OF_MONTH) < day))
								{
									activeChar.sendMessage("Unable to change Siege Date - Incorrect day value only " + cal.getActualMinimum(Calendar.DAY_OF_MONTH) + "-" + cal.getActualMaximum(Calendar.DAY_OF_MONTH) + " is accepted!");
									return false;
								}
								cal.set(Calendar.DAY_OF_MONTH, day);
							}
							else if ("hour".equals(val))
							{
								int hour = Integer.parseInt(st.nextToken());
								if ((cal.getActualMinimum(Calendar.HOUR_OF_DAY) > hour) || (cal.getActualMaximum(Calendar.HOUR_OF_DAY) < hour))
								{
									activeChar.sendMessage("Unable to change Siege Date - Incorrect hour value only " + cal.getActualMinimum(Calendar.HOUR_OF_DAY) + "-" + cal.getActualMaximum(Calendar.HOUR_OF_DAY) + " is accepted!");
									return false;
								}
								cal.set(Calendar.HOUR_OF_DAY, hour);
							}
							else if ("min".equals(val))
							{
								int min = Integer.parseInt(st.nextToken());
								if ((cal.getActualMinimum(Calendar.MINUTE) > min) || (cal.getActualMaximum(Calendar.MINUTE) < min))
								{
									activeChar.sendMessage("Unable to change Siege Date - Incorrect minute value only " + cal.getActualMinimum(Calendar.MINUTE) + "-" + cal.getActualMaximum(Calendar.MINUTE) + " is accepted!");
									return false;
								}
								cal.set(Calendar.MINUTE, min);
							}
							
							if (cal.getTimeInMillis() < System.currentTimeMillis())
							{
								activeChar.sendMessage("Unable to change Siege Date");
							}
							else if (cal.getTimeInMillis() != castle.getSiegeDate().getTimeInMillis())
							{
								castle.getSiegeDate().setTimeInMillis(cal.getTimeInMillis());
								castle.getSiege().saveSiegeDate();
								activeChar.sendMessage("Castle siege time for castle " + castle.getCastleName() + " has been changed.");
							}
						}
						showSiegeTimePage(activeChar, castle);
						break;
					case "admin_spawn_doors":
						castle.spawnDoor();
						break;
					case "admin_startsiege":
						castle.getSiege().startSiege();
						break;
					default:
						showSiegePage(activeChar, castle);	//[JOJO]
						break;
				}
			}
		}
		else
		{
			showCastleSelectPage(activeChar);
		}
		return true;
	}
	
	/**
	 * Show castle select page.
	 * @param activeChar the active char
	 */
	private void showCastleSelectPage(L2PcInstance activeChar)
	{
		int i = 0;
		final NpcHtmlMessage adminReply = new NpcHtmlMessage();
		adminReply.setFile(activeChar.getHtmlPrefix(), "data/html/admin/castles.htm");
		final StringBuilder cList = new StringBuilder(500);
		for (Castle castle : CastleManager.getInstance().getCastles())
		{
			if (castle != null)
			{
				final String color1, color2;
				if (castle.getOwnerId() > 0)
				{
					color1 = "<FONT COLOR=32C332>";
					color2 = "</FONT>";
				}
				else
				{
					color1 = color2 = "";
				}
				StringUtil.append(cList, "<td fixwidth=90><a action=\"bypass -h admin_siege ", castle.getName(), "\">", color1, castle.getCastleNameHtm(), color2, "</a></td>");	//[JOJO]
				i++;
			}
			if (i > 2)
			{
				cList.append("</tr><tr>");
				i = 0;
			}
		}
		adminReply.replace("%castles%", cList.toString());
		cList.setLength(0);
		i = 0;
		for (SiegableHall hall : CHSiegeManager.getInstance().getConquerableHalls().values())
		{
			if (hall != null)
			{
				final String color1, color2;
				if (hall.getOwnerId() > 0)
				{
					color1 = "<FONT COLOR=32C332>";
					color2 = "</FONT>";
				}
				else
				{
					color1 = color2 = "";
				}
				StringUtil.append(cList, "<td fixwidth=90><a action=\"bypass -h admin_chsiege_siegablehall ", String.valueOf(hall.getId()), "\">", color1, hall.getNameHtm(), color2, "</a></td>");	//[JOJO]
				i++;
			}
			if (i > 1)
			{
				cList.append("</tr><tr>");
				i = 0;
			}
		}
		adminReply.replace("%siegableHalls%", cList.toString());
		cList.setLength(0);
		i = 0;
		for (ClanHall clanhall : ClanHallManager.getInstance().getClanHalls().values())
		{
			if (clanhall != null)
			{
				final String color1 = "<FONT COLOR=32C332>", color2 = "</FONT>";
				StringUtil.append(cList, "<td fixwidth=134><a action=\"bypass -h admin_clanhall ", String.valueOf(clanhall.getId()), "\">", color1, clanhall.getNameHtm(), color2, "</a></td>");	//[JOJO]
				i++;
			}
			if (i > 1)
			{
				cList.append("</tr><tr>");
				i = 0;
			}
		}
		adminReply.replace("%clanhalls%", cList.toString());
		cList.setLength(0);
		i = 0;
		for (ClanHall clanhall : ClanHallManager.getInstance().getFreeClanHalls().values())
		{
			if (clanhall != null)
			{
				StringUtil.append(cList, "<td fixwidth=134><a action=\"bypass -h admin_clanhall ", String.valueOf(clanhall.getId()), "\">", clanhall.getNameHtm(), "</a></td></tr><tr>");	//[JOJO]
			}
		}
		adminReply.replace("%freeclanhalls%", cList.toString());
		activeChar.sendPacket(adminReply);
	}
	
	/**
	 * Show the siege page.
	 * @param activeChar the active char
	 * @param castleName the castle name
	 */
	private void showSiegePage(L2PcInstance activeChar, Castle castle)	//[JOJO]
	{
		final NpcHtmlMessage adminReply = new NpcHtmlMessage();
		adminReply.setFile(activeChar.getHtmlPrefix(), "data/html/admin/castle.htm");
		adminReply.replace("%castleNameHtm%", castle.getCastleNameHtm());
		adminReply.replace("%castleName%", castle.getName());	//[JOJO]
		final L2Clan owner = ClanTable.getInstance().getClan(castle.getOwnerId());
		adminReply.replace("%castleOwner%", owner == null ? "No Owner" : owner.getName());	//+[JOJO]
		activeChar.sendPacket(adminReply);
	}
	
	/**
	 * Show the siege time page.
	 * @param activeChar the active char
	 * @param castle the castle
	 */
	private void showSiegeTimePage(L2PcInstance activeChar, Castle castle)
	{
		final NpcHtmlMessage adminReply = new NpcHtmlMessage();
		adminReply.setFile(activeChar.getHtmlPrefix(), "data/html/admin/castlesiegetime.htm");
		
		// <table><tr>%calendar%</tr></table>
		final String BUTTON = "<td width=35><button value=\"\1\" action=\"bypass admin_setsiegetime %castleName% day \1\" width=35 height=21 back=\"L2UI_CT1.Button_DF_Down\" fore=\"L2UI_CT1.Button_DF\"></td>" + AdminSiege.CR;
		final String CURRENT = "<td align=center><font color=LEVEL>\1</font></td>" + AdminSiege.CR;
		adminReply.replace("%calendar%", AdminSiege.calendarHtmlTable(castle.getSiegeDate(), BUTTON, CURRENT));
		
		adminReply.replace("%castleNameHtm%", castle.getCastleNameHtm());	//[JOJO]
		adminReply.replace("%castleName%", castle.getName());
		adminReply.replace("%time%", com.l2jserver.util.Util.dateFormat(castle.getSiegeDate()));
		activeChar.sendPacket(adminReply);
	}
	
	static final String calendarHtmlTable(Calendar theDate, String BUTTON, String CURRENT)
	{
		final String PADDING = "<td align=center>E</td>" + AdminSiege.CR;
		final StringBuilder sb = new StringBuilder(256);
		final int theMonth = theDate.get(Calendar.MONTH);
		final int theDay = theDate.get(Calendar.DAY_OF_MONTH);
		final Calendar cal = (Calendar) theDate.clone();
		final int FIRST_DAY_OF_WEEK = cal.getFirstDayOfWeek();
		cal.set(Calendar.DAY_OF_MONTH, 1);
		cal.get(Calendar.DAY_OF_MONTH);	// verify
		cal.set(Calendar.DAY_OF_WEEK, FIRST_DAY_OF_WEEK);
		cal.get(Calendar.DAY_OF_WEEK);	// verify
		for (; cal.get(Calendar.MONTH) != theMonth; cal.add(Calendar.DAY_OF_MONTH, 1))
			sb.append(PADDING);
		for (; cal.get(Calendar.MONTH) == theMonth; cal.add(Calendar.DAY_OF_MONTH, 1)) {
			if (cal.get(Calendar.DAY_OF_WEEK) == FIRST_DAY_OF_WEEK && sb.length() > 0)
				sb.append("</tr><tr>").append(CR);
			int day = cal.get(Calendar.DAY_OF_MONTH);
			sb.append((day == theDay ? CURRENT : BUTTON).replace("\1", String.valueOf(day)));
		}
		for (; cal.get(Calendar.DAY_OF_WEEK) != FIRST_DAY_OF_WEEK; cal.add(Calendar.DAY_OF_MONTH, 1))
			sb.append(PADDING);
		//sb.insert(0, "<tr>" + CR);
		//sb.append("</tr>" + CR);
		return sb.toString();
	}
	//static final String CR = "";
	static final String CR = "\n";
	
	/**
	 * Show the clan hall page.
	 * @param activeChar the active char
	 * @param clanhall the clan hall
	 */
	private void showClanHallPage(L2PcInstance activeChar, ClanHall clanhall)
	{
		final String htmPath;
		if (clanhall.isSiegableHall())
			htmPath = "data/html/admin/siegablehall.htm";
		else
			htmPath = "data/html/admin/clanhall.htm";
		final NpcHtmlMessage adminReply = new NpcHtmlMessage();
		adminReply.setFile(activeChar.getHtmlPrefix(), htmPath);
		adminReply.replace("%clanhallNameHtm%", clanhall.getNameHtm());
		adminReply.replace("%clanhallId%", clanhall.getId());
		final L2Clan owner = ClanTable.getInstance().getClan(clanhall.getOwnerId());
		adminReply.replace("%clanhallOwner%", owner == null ? "No Owner" : owner.getName());
		activeChar.sendPacket(adminReply);
	}
	
	@Override
	public String[] getAdminCommandList()
	{
		return ADMIN_COMMANDS;
	}
}
