## Active Perl 5.8.8 or later

# Add comments to seeds.xml
# Author JOJO

use utf8;
use strict;
use warnings;
use Encode;
use DBI;

binmode STDOUT,':encoding(cp932)'; $|=1;
sub   FS {Encode::encode('cp932',shift)}
sub UTF8 {Encode::decode('cp932',shift)}

my $DEBUG = 0; # 1 or 0

my $LogFile = UTF8(__FILE__);
   $LogFile =~ s!\.[^.\/\\]*$!.log!;
open LOG, '>:utf8', FS($LogFile)  or die "'$LogFile' $!";

my %array_castle_name = (
	1 => 'グルーディオ',
	2 => 'ディオン',
	3 => 'ギラン',
	4 => 'オーレン',
	5 => 'アデン',
	6 => 'インナドリル',
	7 => 'ゴダード',
	8 => 'ルウン',
	9 => 'シュチュッツガルト',
);

my $vars_txt = '../../../tools/vars.txt';
open FILE,'<',$vars_txt  or do {warn "'$vars_txt' $!";exit 0};
read FILE,my $vars,-s FILE;
close FILE;
my $gsuser = ($vars =~ m/^@*set gsuser=(.+)$/m)[0];
my $gspass = ($vars =~ m/^@*set gspass=(.+)$/m)[0];
my $gsdb   = ($vars =~ m/^@*set gsdb=(.+)$/m)[0];
my $gshost = ($vars =~ m/^@*set gshost=(.+)$/m)[0];

my $db = DBI->connect("DBI:mysql:$gsdb:$gshost", $gsuser, $gspass, {mysql_enable_utf8=>1}) or do{warn DBI::errstr;exit 0};
   $db->do('SET NAMES UTF8');

&start('./seeds.xml');

close LOG;
exit 0;

sub start {
	my ($filePath) = @_;

	print "  $filePath\n" if $DEBUG;
	open FILE, '<:utf8', FS($filePath) or die "'$filePath' $!";
	my $mtime = (stat FILE)[9];
	read FILE,my $text,-s FILE;
	close FILE;

	my $backup = $text;
	my @T = split m/(?<=[\n])/, $text;
	foreach my $line (@T) {
		if ($line =~ m/^[\t ]*<castle id="(\d+)">/) {
			my $id = $1;
			my $castle = $array_castle_name{$id};
			   $line =~ s{<!--(:?[^-]|-[^-]|--[^>])*-->$}{<!-- $castle -->}
			or $line =~ s{$}{ <!-- $castle -->};
		}
		elsif ($line =~ m/^[\t ]*<crop id="(\d+)"[^<>]*\breward1="(\d+)" reward2="(\d+)"/) {
			my ($id,$reward1,$reward2) = ($1,$2,$3);
			my $name = getItemName($id).' ('.getItemName($reward1).','.getItemName($reward2).')';
			   $line =~ s{<!--(:?[^-]|-[^-]|--[^>])*-->$}{<!-- $name -->}
			or $line =~ s{$}{ <!-- $name -->};
		}
	#	elsif ($line =~ m/^[\t ]*<crop id="(\d+)" seedId="(\d+)" mature_Id="(\d+)" reward1="(\d+)" reward2="(\d+)"/) {
	#		my ($id,$seedId,$mature_Id,$reward1,$reward2) = ($1,$2,$3,$4,$5);
	#		my $name = getItemName($id).',seed='.getItemName($seedId).',mature='.getItemName($mature_Id).',reward1='.getItemName($reward1).',reward2='.getItemName($reward2);
	#		   $line =~ s{<!--(:?[^-]|-[^-]|--[^>])*-->$}{<!-- $name -->}
	#		or $line =~ s{$}{ <!-- $name -->};
	#	}
	#	elsif ($line =~ m/^[\t ]*<crop id="(\d+)"/) {
	#		my $id = $1;
	#		my $name = getItemName($id);
	#		   $line =~ s{<!--(:?[^-]|-[^-]|--[^>])*-->$}{<!-- $name -->}
	#		or $line =~ s{$}{ <!-- $name -->};
	#	}
	}
	$text = join '',@T;

	if ($backup ne $text) {
		my $outPath = $filePath;
		   $outPath = $filePath . '.text' if $DEBUG;
		open FILE, '>:utf8', FS($outPath) or die "'$outPath' $!";
		print FILE $text;
		close FILE;
		utime $mtime, $mtime, FS($outPath);
	}
}

sub getItemName {
	my ($id) = @_;

	my $sql = "SELECT name FROM itemname_ja WHERE id=?";
	my $sth = $db->prepare($sql);
	$sth->execute($id) or die DBI::errstr;
	$sth->bind_columns(undef, \(my($N_name))) or die DBI::errstr;
	my $rc = $sth->fetch();

	return $N_name;
}
