//@formatter:off
/*
 * Auther: tukune
 * 
 * DON'T CODE FORMAT!
 * DON'T CONVERT TAB <---> SPACE
 * DON'T STRIP TRAILING BLANKS FROM END OF LINE
 */
package jp.sf.l2j.arrayMaps;

import static jp.sf.l2j.arrayMaps.SortedArrayMap.*;

import java.util.Arrays;
import java.util.Map;
import java.util.Map.Entry;

/*
 * @auther JOJO
 */
public class SortedLongBooleanArrayMap
{
	private long[] _keys;
	private boolean[] _values;
	public final boolean NULL;
	
	public SortedLongBooleanArrayMap()
	{
		this(BOOLEAN_NULL);
	}
	
	public SortedLongBooleanArrayMap(boolean nullValue)
	{
		this(nullValue, LONG_EMPTY, BOOLEAN_EMPTY);
	}
	
	public SortedLongBooleanArrayMap(long[] keys, boolean[] values)
	{
		this(BOOLEAN_NULL, keys, values);
	}
	
	public SortedLongBooleanArrayMap(boolean nullValue, long[] keys, boolean[] values)
	{
		NULL = nullValue;
		_keys = keys;
		_values = values;
		sort();
	}
	
	public SortedLongBooleanArrayMap(Map<Long, Boolean> t)
	{
		this(BOOLEAN_NULL, t);
	}
	
	public SortedLongBooleanArrayMap(boolean nullValue, Map<Long, Boolean> t)
	{
		NULL = nullValue;
		int length = t.size();
		long[] tmpKeys = new long[length];
		boolean[] tmpValues = new boolean[length];
		
		Boolean w;
		int index = 0;
		for (Entry<Long, Boolean> e : t.entrySet())
		{
			tmpKeys[index] = e.getKey();
			tmpValues[index] = (w = e.getValue()) == null ? NULL : w;
			++index;
		}
		_keys = tmpKeys;
		_values = tmpValues;
		sort();
	}
	
	public void clear()
	{
		_keys = LONG_EMPTY;
		_values = BOOLEAN_EMPTY;
	}
	
	public boolean containsKey(long key)
	{
		return Arrays.binarySearch(_keys, key) >= 0;
	}
	
	public boolean containsValue(boolean value)
	{
		for (int index = _values.length; --index >= 0;)
			if (_values[index] == value)
				return true;
		return false;
	}
	
	public boolean get(long key)
	{
		return getOrDefault(key, NULL);
	}
	
	public boolean getOrDefault(long key, boolean defaultValue)
	{
		int index = Arrays.binarySearch(_keys, key);
		if (index >= 0)
			return _values[index];
		else
			return defaultValue;
	}
	
	public boolean isEmpty()
	{
		return _keys.length == 0;
	}
	
	public long[] keySet()
	{
		return _keys;
	}
	
	public long[] keys()
	{
		return _keys;
	}
	
	public boolean put(long key, boolean value)
	{
		int index = Arrays.binarySearch(_keys, key);
		if (index >= 0) {
			boolean prev = _values[index];
			_values[index] = value;
			return prev;
		} else {
			return insertEntry(-(index + 1), key, value);
		}
	}
	
	public boolean putIfAbsent(long key, boolean value)
	{
		int index = Arrays.binarySearch(_keys, key);
		if (index >= 0)
			return _values[index];
		else
			return insertEntry(-(index + 1), key, value);
	}
	
	public void putAll(Map<Long, Boolean> t)
	{
		for (Entry<Long, Boolean> e : t.entrySet())
			put(e.getKey(), e.getValue());
	}
	
	public boolean remove(long key)
	{
		int index = Arrays.binarySearch(_keys, key);
		if (index >= 0)
			return deleteEntry(index);
		else
			return NULL;
	}
	
	public int size()
	{
		return _keys.length;
	}
	
	public boolean[] values()
	{
		return _values;
	}
	
	public SortedLongBooleanArrayMap append(long key, boolean value)
	{
		boolean prev = put(key, value);
		if (prev != NULL) throw new RuntimeException("Duplicate key:" + key + " value:" + value + " previus:" + prev);
		return this;
	}
	
	private boolean deleteEntry(int index)
	{
		final int length = _keys.length - 1;
		if (length < 0)
			return NULL;
		long[] tmpKeys = new long[length];
		boolean[] tmpValues = new boolean[length];
		if (index > 0) {
			System.arraycopy(_keys, 0, tmpKeys, 0, index);
			System.arraycopy(_values, 0, tmpValues, 0, index);
		}
		int n;
		if ((n = length - index) > 0) {
			System.arraycopy(_keys, index + 1, tmpKeys, index, n);
			System.arraycopy(_values, index + 1, tmpValues, index, n);
		}
		boolean prev = _values[index];
		_keys = tmpKeys;
		_values = tmpValues;
		return prev;
	}
	
	public int indexOf(long key)
	{
		return Arrays.binarySearch(_keys, key);
	}
	
	private boolean insertEntry(int index, long key, boolean value)
	{
		final int length = _keys.length;
		long[] tmpKeys = new long[length + 1];
		boolean[] tmpValues = new boolean[length + 1];
		if (index > 0) {
			System.arraycopy(_keys, 0, tmpKeys, 0, index);
			System.arraycopy(_values, 0, tmpValues, 0, index);
		}
		tmpKeys[index] = key;
		tmpValues[index] = value;
		int n;
		if ((n = length - index) > 0) {
			System.arraycopy(_keys, index, tmpKeys, index + 1, n);
			System.arraycopy(_values, index, tmpValues, index + 1, n);
		}
		_keys = tmpKeys;
		_values = tmpValues;
		return NULL;
	}
	
	public long keyAt(int index)
	{
		return _keys[index];
	}
	
	public boolean valueAt(int index)
	{
		return _values[index];
	}
	
	public long getKey(int index)
	{
		return keyAt(index);
	}
	
	public boolean getValue(int index)
	{
		return valueAt(index);
	}
	
	public boolean setValue(int index, boolean value)
	{
		boolean prev = _values[index];
		_values[index] = value;
		return prev;
	}
	
	public void fill(boolean value)
	{
		Arrays.fill(_values, value);
	}
	
	public void sort()
	{
		sort(0, _keys.length - 1);
	}
	
	private void sort(int left, int right)
	{
		if (left >= right) return;
		long pivot = _keys[(left + right) / 2];
		int i = left;
		int j = right;
		for (;;) {
			while (_keys[i] < pivot) ++i;
			while (pivot < _keys[j]) --j;
			if (i >= j) break;
			long key = _keys[i]; _keys[i] = _keys[j]; _keys[j] = key;
			boolean value = _values[i]; _values[i] = _values[j]; _values[j] = value;
			++i;
			--j;
		}
		sort(left,  i - 1);
		sort(j + 1, right);
	}
}
