//@formatter:off
/*
 * Auther: tukune
 * 
 * DON'T CODE FORMAT!
 * DON'T CONVERT TAB <---> SPACE
 * DON'T STRIP TRAILING BLANKS FROM END OF LINE
 */
package jp.sf.l2j.boundArrays;

import java.util.Arrays;

/**
 * @author JOJO
 */
public class BoundBooleanArray
{
	private static final boolean[] EMPTY_ELEMENTDATA = new boolean[0];	//TODO: #VC#_EMPTY
	
	private boolean[] elementData = EMPTY_ELEMENTDATA;
	private int lbound;
	public static final boolean NULL = false;	//TODO: #VC#_NULL
	
	public BoundBooleanArray() {}
	
	public BoundBooleanArray(int lbound) { this.lbound = lbound; }
	
	public BoundBooleanArray to(int ubound) {
		final int s = ubound - lbound + 1;
		if (s != elementData.length)
			elementData = Arrays.copyOf(elementData, s);
		return this;
	}
	
	private void grow(int newSize) { elementData = Arrays.copyOf(elementData, newSize); }
	
	public int size() { return elementData.length; }
	
	public boolean isEmpty() { return elementData.length == 0; }
	
	public int lbound() { return lbound; }
	
	public int ubound() { return lbound + elementData.length - 1; }
	
	public boolean contains(boolean element) { return indexOf(element) >= 0; }
	
	public boolean containsKey(int index) {
	//	return lbound() <= index && index <= ubound();
		int pos = index - lbound;
		return 0 <= pos && pos < elementData.length;
	}
	
	public int indexOf(boolean element) {
		for (int pos = 0; pos < elementData.length; ++pos)
			if (element == elementData[pos])
				return pos;
		return -1;
	}
	
	public int lastIndexOf(boolean element) {
		for (int pos = elementData.length; --pos >= 0;)
			if (element == elementData[pos])
				return pos;
		return -1;
	}
	
	public boolean[] toArray() { return Arrays.copyOf(elementData, elementData.length); }
	
	public boolean get(int index) {
		final int pos = index - lbound;
		return pos >= 0 && pos < elementData.length ? (boolean) elementData[pos] : NULL;
	}
	
	public boolean set(int index, boolean element) {
		final int pos = index - lbound;
		final boolean p = elementData[pos];
		elementData[pos] = element;
		return p;
	}
	
	public boolean put(int index, boolean element) {
		final int size = elementData.length;
		if (size == 0 && lbound == 0)
			lbound = index;
		final int pos = index - lbound;
		if (pos == size)
			grow(size + 1);
	//sure! else if (pos < 0 || pos > size) throw new ArrayIndexOutOfBoundsException();
		final boolean p = elementData[pos];
		elementData[pos] = element;
		return p;
	}
	
	public BoundBooleanArray append(int index, boolean element) {
		final int size = elementData.length;
		if (size == 0 && lbound == 0)
			lbound = index;
		final int pos = index - lbound;
		if (pos == size)
			grow(size + 1);
	//sure! else if (pos < 0 || pos > size) throw new ArrayIndexOutOfBoundsException();
		elementData[pos] = element;
		return this;
	}
	
	public BoundBooleanArray append(boolean element) {
		final int size = elementData.length;
		final int pos = size;
		grow(size + 1);
		elementData[pos] = element;
		return this;
	}
	
	public void clear() { elementData = EMPTY_ELEMENTDATA; }
	
	public boolean addAll(boolean[] a) {
		final int size = elementData.length;
		final int numNew = a.length;
		grow(size + numNew);
		System.arraycopy(a, 0, elementData, size, numNew);
		return numNew != 0;
	}
	
	public void fill(boolean element) { Arrays.fill(elementData, element); }
	
	public boolean[] values() { return elementData; }
}
