//@formatter:off
/*
 * Auther: tukune
 * 
 * DON'T CODE FORMAT!
 * DON'T CONVERT TAB <---> SPACE
 * DON'T STRIP TRAILING BLANKS FROM END OF LINE
 */
package jp.sf.l2j.boundArrays;

import java.util.Arrays;

/**
 * @author JOJO
 */
public class BoundShortArray
{
	private static final short[] EMPTY_ELEMENTDATA = new short[0];	//TODO: #VC#_EMPTY
	
	private short[] elementData = EMPTY_ELEMENTDATA;
	private int lbound;
	public static final short NULL = 0;	//TODO: #VC#_NULL
	
	public BoundShortArray() {}
	
	public BoundShortArray(int lbound) { this.lbound = lbound; }
	
	public BoundShortArray to(int ubound) {
		final int s = ubound - lbound + 1;
		if (s != elementData.length)
			elementData = Arrays.copyOf(elementData, s);
		return this;
	}
	
	private void grow(int newSize) { elementData = Arrays.copyOf(elementData, newSize); }
	
	public int size() { return elementData.length; }
	
	public boolean isEmpty() { return elementData.length == 0; }
	
	public int lbound() { return lbound; }
	
	public int ubound() { return lbound + elementData.length - 1; }
	
	public boolean contains(short element) { return indexOf(element) >= 0; }
	
	public boolean containsKey(int index) {
	//	return lbound() <= index && index <= ubound();
		int pos = index - lbound;
		return 0 <= pos && pos < elementData.length;
	}
	
	public int indexOf(short element) {
		for (int pos = 0; pos < elementData.length; ++pos)
			if (element == elementData[pos])
				return pos;
		return -1;
	}
	
	public int lastIndexOf(short element) {
		for (int pos = elementData.length; --pos >= 0;)
			if (element == elementData[pos])
				return pos;
		return -1;
	}
	
	public short[] toArray() { return Arrays.copyOf(elementData, elementData.length); }
	
	public short get(int index) {
		final int pos = index - lbound;
		return pos >= 0 && pos < elementData.length ? (short) elementData[pos] : NULL;
	}
	
	public short set(int index, short element) {
		final int pos = index - lbound;
		final short p = elementData[pos];
		elementData[pos] = element;
		return p;
	}
	
	public short put(int index, short element) {
		final int size = elementData.length;
		if (size == 0 && lbound == 0)
			lbound = index;
		final int pos = index - lbound;
		if (pos == size)
			grow(size + 1);
	//sure! else if (pos < 0 || pos > size) throw new ArrayIndexOutOfBoundsException();
		final short p = elementData[pos];
		elementData[pos] = element;
		return p;
	}
	
	public BoundShortArray append(int index, short element) {
		final int size = elementData.length;
		if (size == 0 && lbound == 0)
			lbound = index;
		final int pos = index - lbound;
		if (pos == size)
			grow(size + 1);
	//sure! else if (pos < 0 || pos > size) throw new ArrayIndexOutOfBoundsException();
		elementData[pos] = element;
		return this;
	}
	
	public BoundShortArray append(short element) {
		final int size = elementData.length;
		final int pos = size;
		grow(size + 1);
		elementData[pos] = element;
		return this;
	}
	
	public void clear() { elementData = EMPTY_ELEMENTDATA; }
	
	public boolean addAll(short[] a) {
		final int size = elementData.length;
		final int numNew = a.length;
		grow(size + numNew);
		System.arraycopy(a, 0, elementData, size, numNew);
		return numNew != 0;
	}
	
	public void fill(short element) { Arrays.fill(elementData, element); }
	
	public short[] values() { return elementData; }
}
