use utf8;
use strict;
use warnings;

my $PACKAGE = 'jp.sf.l2j.boundArrays';

&ToBoolean('Bound_E_Array.template');
&ToByte('Bound_E_Array.template');
&ToShort('Bound_E_Array.template');
&ToChar('Bound_E_Array.template');
&ToInt('Bound_E_Array.template');
&ToLong('Bound_E_Array.template');
&ToFloat('Bound_E_Array.template');
&ToDouble('Bound_E_Array.template');
&ToObject('BoundObjectArray.template');
&ToObject('BoundArrayList.template');

exit;

sub ToBoolean()
{
	my ($template) = @_;
	my $output = $template;
	$output =~ s/_E_/Boolean/;
	$output =~ s/\.template/.java.txt/;

	$_ = readAll($template);

	s/#p#/$PACKAGE/g;

	s/#e#/boolean/g;
	s/#ET#/Boolean/g;
	s/#E#/Boolean/g;
	s/#EC#/BOOLEAN/g;
	s/#NULL#/false/g;	#s/#NULL#/NULL/g;

	writeAll($output, $_);
}

sub ToByte()
{
	my ($template) = @_;
	my $output = $template;
	$output =~ s/_E_/Byte/;
	$output =~ s/\.template/.java.txt/;

	$_ = readAll($template);

	s/#p#/$PACKAGE/g;

	s/#e#/byte/g;
	s/#ET#/Byte/g;
	s/#E#/Byte/g;
	s/#EC#/BYTE/g;
	s/#NULL#/0/g;	#s/#NULL#/NULL/g;

	writeAll($output, $_);
}

sub ToShort()
{
	my ($template) = @_;
	my $output = $template;
	$output =~ s/_E_/Short/;
	$output =~ s/\.template/.java.txt/;

	$_ = readAll($template);

	s/#p#/$PACKAGE/g;

	s/#e#/short/g;
	s/#ET#/Short/g;
	s/#E#/Short/g;
	s/#EC#/SHORT/g;
	s/#NULL#/0/g;	#s/#NULL#/NULL/g;

	writeAll($output, $_);
}

sub ToChar()
{
	my ($template) = @_;
	my $output = $template;
	$output =~ s/_E_/Char/;
	$output =~ s/\.template/.java.txt/;

	$_ = readAll($template);

	s/#p#/$PACKAGE/g;

	s/#e#/char/g;
	s/#ET#/Character/g;
	s/#E#/Char/g;
	s/#EC#/CHAR/g;
	s/#NULL#/'\\0'/g;	#s/#NULL#/NULL/g;

	writeAll($output, $_);
}

sub ToInt()
{
	my ($template) = @_;
	my $output = $template;
	$output =~ s/_E_/Int/;
	$output =~ s/\.template/.java.txt/;

	$_ = readAll($template);

	s/#p#/$PACKAGE/g;

	s/#e#/int/g;
	s/#ET#/Integer/g;
	s/#E#/Int/g;
	s/#EC#/INT/g;
	s/#NULL#/0/g;	#s/#NULL#/NULL/g;

	writeAll($output, $_);
}

sub ToLong()
{
	my ($template) = @_;
	my $output = $template;
	$output =~ s/_E_/Long/;
	$output =~ s/\.template/.java.txt/;

	$_ = readAll($template);

	s/#p#/$PACKAGE/g;

	s/#e#/long/g;
	s/#ET#/Long/g;
	s/#E#/Long/g;
	s/#EC#/LONG/g;
	s/#NULL#/0/g;	#s/#NULL#/NULL/g;

	writeAll($output, $_);
}

sub ToFloat()
{
	my ($template) = @_;
	my $output = $template;
	$output =~ s/_E_/Float/;
	$output =~ s/\.template/.java.txt/;

	$_ = readAll($template);

	s/#p#/$PACKAGE/g;

	s/#e#/float/g;
	s/#ET#/Float/g;
	s/#E#/Float/g;
	s/#EC#/FLOAT/g;
	s/#NULL#/0/g;	#s/#NULL#/NULL/g;

	writeAll($output, $_);
}

sub ToDouble()
{
	my ($template) = @_;
	my $output = $template;
	$output =~ s/_E_/Double/;
	$output =~ s/\.template/.java.txt/;

	$_ = readAll($template);

	s/#p#/$PACKAGE/g;

	s/#e#/double/g;
	s/#ET#/Double/g;
	s/#E#/Double/g;
	s/#EC#/DOUBLE/g;
	s/#NULL#/0/g;	#s/#NULL#/NULL/g;

	writeAll($output, $_);
}

sub ToObject()
{
	my ($template) = @_;
	my $output = $template;
	$output =~ s/\.template/.java.txt/;

	$_ = readAll($template);

	s/#p#/$PACKAGE/g;

	writeAll($output, $_);
}

sub readAll()
{
	my ($path) = @_;
	open FILE, '<', $path;
	binmode FILE;
	read FILE, my $text, -s FILE;
	close FILE;
	return $text;
}

sub writeAll()
{
	my ($path, $text) = @_;
	open FILE, '>', $path;
	binmode FILE;
	print FILE $text;
	close FILE
}
