/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.compatibility.plugins;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.osgi.compatibility.plugins.PluginConverterImpl;
import org.eclipse.osgi.framework.util.Headers;
import org.eclipse.osgi.internal.hookregistry.ActivatorHookFactory;
import org.eclipse.osgi.internal.hookregistry.BundleFileWrapperFactoryHook;
import org.eclipse.osgi.internal.hookregistry.HookConfigurator;
import org.eclipse.osgi.internal.hookregistry.HookRegistry;
import org.eclipse.osgi.service.pluginconversion.PluginConversionException;
import org.eclipse.osgi.service.pluginconversion.PluginConverter;
import org.eclipse.osgi.storage.BundleInfo;
import org.eclipse.osgi.storage.bundlefile.BundleEntry;
import org.eclipse.osgi.storage.bundlefile.BundleFile;
import org.eclipse.osgi.storage.bundlefile.BundleFileWrapper;
import org.eclipse.osgi.storage.bundlefile.FileBundleEntry;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class PluginConverterHook
implements HookConfigurator {
    public void addHooks(HookRegistry hookRegistry) {
        PluginConverterImpl tempConverter;
        try {
            tempConverter = new PluginConverterImpl(hookRegistry);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        final PluginConverterImpl converter = tempConverter;
        hookRegistry.addBundleFileWrapperFactoryHook(new BundleFileWrapperFactoryHook(){

            public BundleFileWrapper wrapBundleFile(BundleFile bundleFile, BundleInfo.Generation generation, boolean base) {
                if (!base) {
                    return null;
                }
                return new BundleFileWrapper(bundleFile){

                    public BundleEntry getEntry(String path) {
                        BundleEntry entry = this.getBundleFile().getEntry(path);
                        if (!"META-INF/MANIFEST.MF".equals(path)) {
                            return entry;
                        }
                        Headers headers = null;
                        if (entry != null) {
                            try {
                                headers = Headers.parseManifest((InputStream)entry.getInputStream());
                            }
                            catch (Exception e) {
                                throw new RuntimeException(e);
                            }
                            if (headers.containsKey((Object)"Bundle-ManifestVersion")) {
                                return entry;
                            }
                            if (headers.containsKey((Object)"Bundle-SymbolicName")) {
                                return entry;
                            }
                        }
                        try {
                            File manifest = converter.convertManifest(this.getBaseFile(), null, true, null, true, null, false);
                            if (manifest == null) {
                                return entry;
                            }
                            return new FileBundleEntry(manifest, "META-INF/MANIFEST.MF");
                        }
                        catch (PluginConversionException e) {
                            throw new RuntimeException(e);
                        }
                    }
                };
            }
        });
        hookRegistry.addActivatorHookFactory(new ActivatorHookFactory(){

            public BundleActivator createActivator() {
                return new BundleActivator(){
                    ServiceRegistration<PluginConverter> reg;

                    public void start(BundleContext context) throws Exception {
                        this.reg = context.registerService(PluginConverter.class, (Object)converter, null);
                    }

                    public void stop(BundleContext context) throws Exception {
                        this.reg.unregister();
                    }
                };
            }
        });
    }
}

