/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.decompiler.actions;

import java.util.List;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.sf.feeling.decompiler.actions.DecompileWithJDCoreAction;
import org.sf.feeling.decompiler.actions.DecompileWithJadAction;
import org.sf.feeling.decompiler.actions.DecompilerPeferenceAction;
import org.sf.feeling.decompiler.actions.ExportEditorSourceAction;
import org.sf.feeling.decompiler.actions.ExportSourceAction;
import org.sf.feeling.decompiler.util.UIUtil;

public class SubMenuCreator
implements IMenuCreator {
    private MenuManager dropDownMenuMgr;

    public Menu getMenu(Menu parent) {
        final Menu menu = new Menu(parent);
        this.fillMenu(menu);
        menu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                while (menu.getItemCount() > 0) {
                    menu.getItem(0).dispose();
                }
                SubMenuCreator.this.fillMenu(menu);
            }
        });
        return menu;
    }

    private void fillMenu(Menu menu) {
        MenuManager menuMgr = new MenuManager();
        if (UIUtil.isWin32()) {
            menuMgr.add((IAction)new DecompileWithJadAction());
        }
        menuMgr.add((IAction)new DecompileWithJDCoreAction());
        IContributionItem[] items = menuMgr.getItems();
        int i = 0;
        while (i < items.length) {
            IContributionItem item;
            IContributionItem newItem = item = items[i];
            if (item instanceof ActionContributionItem) {
                newItem = new ActionContributionItem(((ActionContributionItem)item).getAction());
            }
            newItem.fill(menu, -1);
            ++i;
        }
    }

    public Menu getMenu(Control parent) {
        this.createDropDownMenuMgr();
        return this.dropDownMenuMgr.createContextMenu(parent);
    }

    public void dispose() {
        if (this.dropDownMenuMgr != null) {
            this.dropDownMenuMgr.dispose();
            this.dropDownMenuMgr = null;
        }
    }

    private void createDropDownMenuMgr() {
        if (this.dropDownMenuMgr == null) {
            this.dropDownMenuMgr = new MenuManager();
            if (UIUtil.isWin32()) {
                this.dropDownMenuMgr.add((IAction)new DecompileWithJadAction());
            }
            this.dropDownMenuMgr.add((IAction)new DecompileWithJDCoreAction());
            this.dropDownMenuMgr.add((IContributionItem)new Separator());
            List list = UIUtil.getExportSelections();
            if (list != null) {
                this.dropDownMenuMgr.add((IAction)new ExportSourceAction(list));
            } else {
                this.dropDownMenuMgr.add((IAction)new ExportEditorSourceAction());
            }
            this.dropDownMenuMgr.add((IContributionItem)new Separator());
            this.dropDownMenuMgr.add((IContributionItem)new PreferenceActionContributionItem((IAction)new DecompilerPeferenceAction()));
        }
    }

    class PreferenceActionContributionItem
    extends ActionContributionItem {
        public PreferenceActionContributionItem(IAction action) {
            super(action);
        }

        public boolean isEnabledAllowed() {
            return true;
        }
    }
}

