/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.decompiler.editor;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.internal.core.BufferManager;
import org.eclipse.jdt.internal.core.ClassFile;
import org.eclipse.jdt.internal.ui.javaeditor.ClassFileEditor;
import org.eclipse.jdt.internal.ui.javaeditor.IClassFileEditorInput;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.IEditorInput;
import org.sf.feeling.decompiler.JavaDecompilerPlugin;
import org.sf.feeling.decompiler.editor.ClassFileSourceMap;
import org.sf.feeling.decompiler.editor.DecompilerSourceMapper;
import org.sf.feeling.decompiler.editor.JavaDecompilerBufferManager;
import org.sf.feeling.decompiler.editor.SourceMapperFactory;
import org.sf.feeling.decompiler.util.UIUtil;

public class JavaDecompilerClassFileEditor
extends ClassFileEditor {
    public static final String ID = "net.sf.feeling.decompiler.ClassFileEditor";
    public static final String MARK = "/*** Eclipse Class Decompiler plugin, copyright (c) 2012 Chao Chen (cnfree2000@hotmail.com) ***/";

    private boolean doOpenBuffer(IEditorInput input, boolean force) {
        IPreferenceStore prefs = JavaDecompilerPlugin.getDefault().getPreferenceStore();
        String decompilerType = prefs.getString("net.sf.feeling.decompiler.type");
        return this.doOpenBuffer(input, decompilerType, force);
    }

    private boolean doOpenBuffer(IEditorInput input, String type, boolean force) {
        IPreferenceStore prefs = JavaDecompilerPlugin.getDefault().getPreferenceStore();
        boolean reuseBuf = prefs.getBoolean("net.sf.feeling.decompiler.reusebuff");
        boolean always = prefs.getBoolean("net.sf.feeling.decompiler.alwaysuse");
        return this.doOpenBuffer(input, type, force, reuseBuf, always);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean doOpenBuffer(IEditorInput input, String type, boolean force, boolean reuseBuf, boolean always) {
        DecompilerSourceMapper sourceMapper;
        char[] src;
        IClassFile cf;
        block9: {
            if (!(input instanceof IClassFileEditorInput)) return false;
            boolean opened = false;
            cf = ((IClassFileEditorInput)input).getClassFile();
            String decompilerType = type;
            String origSrc = cf.getSource();
            if (origSrc != null && (!always || origSrc.startsWith(MARK))) {
                if (!origSrc.startsWith(MARK)) return opened;
                if (reuseBuf) {
                    if (!force) return opened;
                }
            }
            if ((src = (sourceMapper = SourceMapperFactory.getSourceMapper(decompilerType)).findSource(cf.getType())) == null) {
                if ("Jad".equals(decompilerType)) {
                    src = SourceMapperFactory.getSourceMapper("JD-Core").findSource(cf.getType());
                } else if ("JD-Core".equals(decompilerType) && UIUtil.isWin32()) {
                    src = SourceMapperFactory.getSourceMapper("Jad").findSource(cf.getType());
                }
            }
            if (src != null) break block9;
            return false;
        }
        try {
            char[] markedSrc = src;
            IBuffer buffer = BufferManager.createBuffer((IOpenable)cf);
            buffer.setContents(markedSrc);
            this.getBufferManager().addBuffer(buffer);
            sourceMapper.mapSource(cf.getType(), markedSrc, true);
            ClassFileSourceMap.updateSource(this.getBufferManager(), (ClassFile)cf, markedSrc);
            return true;
        }
        catch (Exception e) {
            JavaDecompilerPlugin.logError(e, "");
        }
        return false;
    }

    public void doSetInput(boolean force) {
        IEditorInput input = this.getEditorInput();
        if (this.doOpenBuffer(input, force)) {
            try {
                super.doSetInput(input);
            }
            catch (Exception e) {
                JavaDecompilerPlugin.logError(e, "");
            }
        }
    }

    public void doSetInput(String type, boolean force) {
        IEditorInput input = this.getEditorInput();
        if (this.doOpenBuffer(input, type, force)) {
            try {
                super.doSetInput(input);
            }
            catch (Exception e) {
                JavaDecompilerPlugin.logError(e, "");
            }
        }
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        this.doOpenBuffer(input, false);
        super.doSetInput(input);
    }

    protected JavaDecompilerBufferManager getBufferManager() {
        BufferManager defManager = BufferManager.getDefaultBufferManager();
        JavaDecompilerBufferManager manager = defManager instanceof JavaDecompilerBufferManager ? (JavaDecompilerBufferManager)defManager : new JavaDecompilerBufferManager(defManager);
        return manager;
    }
}

