/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.decompiler.fieldeditors;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.sf.feeling.decompiler.fieldeditors.CommandLineOptionEditor;
import org.sf.feeling.decompiler.i18n.Messages;
import org.sf.feeling.decompiler.jad.CommandOption;

public class StringOptionEditor
extends CommandLineOptionEditor {
    public static int ALLOW_EMPTY = 1;
    public static int ALLOW_WS = 2;
    private Text value;
    private int allowMask;

    public StringOptionEditor(String optionName, String label, int allowMask, Composite parent) {
        this.allowMask = allowMask;
        this.init(optionName, label);
        this.createControl(parent);
    }

    protected void adjustForNumColumns(int numColumns) {
        GridData gd = (GridData)this.value.getLayoutData();
        gd.horizontalSpan = numColumns - 1;
        gd.grabExcessHorizontalSpace = true;
    }

    protected void doAccept(CommandOption option) {
        if (option == null) {
            this.value.setText("");
        } else {
            String val = option.getValue();
            if (val != null && (val = val.trim()).length() > 0) {
                this.value.setText(val);
                if ((this.allowMask & ALLOW_WS) == 0 && (val.indexOf(32) > 0 || val.indexOf(9) > 0) && this.getPreferencePage() != null) {
                    this.getPreferencePage().setErrorMessage(String.valueOf(Messages.getString("StringOptionEditor.Message.Label.Option")) + this.getOptionName() + Messages.getString("StringOptionEditor.Message.Label.NotSupportWhitespace"));
                }
            } else {
                this.value.setText("");
                if ((this.allowMask & ALLOW_EMPTY) == 0 && this.getPreferencePage() != null) {
                    this.getPreferencePage().setErrorMessage(String.valueOf(Messages.getString("StringOptionEditor.Message.Label.Option")) + this.getOptionName() + Messages.getString("StringOptionEditor.Message.Label.MustHaveValue"));
                }
            }
        }
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        Label label = new Label(parent, 16384);
        label.setText(this.getLabel());
        this.value = new Text(parent, 2048);
        this.value.setLayoutData((Object)new GridData(768));
    }

    public int getNumberOfControls() {
        return 2;
    }

    public CommandOption toOption() {
        String val = this.value.getText();
        if (val != null && (val = val.trim()).length() > 0 && (val.indexOf(32) < 0 && val.indexOf(9) < 0 || (this.allowMask & ALLOW_WS) != 0)) {
            return new CommandOption(this.getOptionName(), val);
        }
        if ((this.allowMask & ALLOW_EMPTY) != 0) {
            return new CommandOption(this.getOptionName(), null);
        }
        return null;
    }
}

