/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.decompiler.jad;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.preference.IPreferenceStore;
import org.sf.feeling.decompiler.JavaDecompilerPlugin;
import org.sf.feeling.decompiler.jad.IJadDecompiler;
import org.sf.feeling.decompiler.jad.JarClassExtractor;
import org.sf.feeling.decompiler.jad.StreamRedirectThread;

public class JadDecompiler
implements IJadDecompiler {
    public static final String OPTION_ANNOTATE = "-a";
    public static final String OPTION_ANNOTATE_FQ = "-af";
    public static final String OPTION_BRACES = "-b";
    public static final String OPTION_CLEAR = "-clear";
    public static final String OPTION_DIR = "-d";
    public static final String OPTION_DEAD = "-dead";
    public static final String OPTION_DISASSEMBLER = "-dis";
    public static final String OPTION_FULLNAMES = "-f";
    public static final String OPTION_FIELDSFIRST = "-ff";
    public static final String OPTION_DEFINITS = "-i";
    public static final String OPTION_SPLITSTR_MAX = "-l";
    public static final String OPTION_LNC = "jd.ide.eclipse.prefs.DisplayLineNumbers";
    public static final String OPTION_LRADIX = "-lradix";
    public static final String OPTION_SPLITSTR_NL = "-nl";
    public static final String OPTION_NOCONV = "-noconv";
    public static final String OPTION_NOCAST = "-nocast";
    public static final String OPTION_NOCLASS = "-noclass";
    public static final String OPTION_NOCODE = "-nocode";
    public static final String OPTION_NOCTOR = "-noctor";
    public static final String OPTION_NODOS = "-nodos";
    public static final String OPTION_NOFLDIS = "-nofd";
    public static final String OPTION_NOINNER = "-noinner";
    public static final String OPTION_NOLVT = "-nolvt";
    public static final String OPTION_NONLB = "-nonlb";
    public static final String OPTION_OVERWRITE = "-o";
    public static final String OPTION_SENDSTDOUT = "-p";
    public static final String OPTION_PA = "-pa";
    public static final String OPTION_PC = "-pc";
    public static final String OPTION_PE = "-pe";
    public static final String OPTION_PF = "-pf";
    public static final String OPTION_PI = "-pi";
    public static final String OPTION_PL = "-pl";
    public static final String OPTION_PM = "-pm";
    public static final String OPTION_PP = "-pp";
    public static final String OPTION_PV = "-pv";
    public static final String OPTION_RESTORE = "-r";
    public static final String OPTION_IRADIX = "-radix";
    public static final String OPTION_EXT = "-s";
    public static final String OPTION_SAFE = "-safe";
    public static final String OPTION_SPACE = "-space";
    public static final String OPTION_STAT = "-stat";
    public static final String OPTION_INDENT_SPACE = "-t";
    public static final String OPTION_INDENT_TAB = "-t";
    public static final String OPTION_VERBOSE = "-v";
    public static final String OPTION_ANSI = "-8";
    public static final String OPTION_REDSTDERR = "-&";
    public static final String USE_TAB = "use tab";
    public static final String[] TOGGLE_OPTION = new String[]{"-a", "-af", "-b", "-clear", "-dead", "-dis", "-f", "-ff", "-i", "jd.ide.eclipse.prefs.DisplayLineNumbers", "-nl", "-noconv", "-nocast", "-noclass", "-nocode", "-noctor", "-nodos", "-nofd", "-noinner", "-nolvt", "-nonlb", "-safe", "-space", "-stat", "-t", "-v", "-8"};
    public static final String[] VALUE_OPTION_STRING = new String[]{"-pa", "-pc", "-pe", "-pf", "-pl", "-pm", "-pp"};
    public static final String[] VALUE_OPTION_INT = new String[]{"-l", "-lradix", "-pi", "-pv", "-radix"};
    private String source = "/* ERROR? */";
    private StringBuffer log;
    private List excList = new ArrayList();
    private long time;
    private long start;

    private String[] buildCmdLine(String classFileName) {
        ArrayList<String> cmdLine = new ArrayList<String>();
        IPreferenceStore settings = JavaDecompilerPlugin.getDefault().getPreferenceStore();
        cmdLine.add(settings.getString("net.sf.feeling.decompiler.cmd"));
        cmdLine.add(OPTION_SENDSTDOUT);
        String indent = settings.getString("-t");
        if (indent.equals(USE_TAB)) {
            cmdLine.add("-t");
        } else {
            try {
                Integer.parseInt(indent);
                cmdLine.add("-t" + indent);
            }
            catch (Exception exception) {}
        }
        int i = 0;
        while (i < TOGGLE_OPTION.length) {
            if (settings.getBoolean(TOGGLE_OPTION[i])) {
                if (OPTION_LNC.equals(TOGGLE_OPTION[i])) {
                    cmdLine.add("-lnc");
                } else {
                    cmdLine.add(TOGGLE_OPTION[i]);
                }
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < VALUE_OPTION_INT.length) {
            int iValue = settings.getInt(VALUE_OPTION_INT[i2]);
            if (iValue > 0) {
                cmdLine.add(String.valueOf(VALUE_OPTION_INT[i2]) + iValue);
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < VALUE_OPTION_STRING.length) {
            String sValue = settings.getString(VALUE_OPTION_STRING[i3]);
            if (sValue != null && sValue.length() > 0) {
                cmdLine.add(String.valueOf(VALUE_OPTION_STRING[i3]) + " " + sValue);
            }
            ++i3;
        }
        cmdLine.add(classFileName);
        return cmdLine.toArray(new String[cmdLine.size()]);
    }

    void debugCmdLine(List segments) {
        StringBuffer cmdline = new StringBuffer();
        int i = 0;
        while (i < segments.size()) {
            cmdline.append(segments.get(i)).append(" ");
            ++i;
        }
        System.err.println("-> " + cmdline.toString());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void decompile(String root, String packege, String className) {
        block11: {
            workingDir = new File(String.valueOf(root) + "/" + packege);
            decor = output = new StringWriter();
            errors = new StringWriter();
            errorsP = new PrintWriter(errors);
            status = 0;
            try {
                try {
                    this.start = System.currentTimeMillis();
                    errorsP.println("\tJad reported messages/errors:");
                    p = Runtime.getRuntime().exec(this.buildCmdLine(className), new String[0], workingDir);
                    outRedirect = new StreamRedirectThread("output_reader", p.getInputStream(), decor);
                    errRedirect = new StreamRedirectThread("error_reader", p.getErrorStream(), errors);
                    outRedirect.start();
                    errRedirect.start();
                    status = p.waitFor();
                    outRedirect.join();
                    errRedirect.join();
                    if (outRedirect.getException() != null) {
                        this.excList.add(outRedirect.getException());
                    }
                    if (errRedirect.getException() != null) {
                        this.excList.add(errRedirect.getException());
                    }
                }
                catch (Exception e) {
                    this.excList.add(e);
                }
            }
            catch (Throwable var14_14) {
                var13_15 = null;
                try {
                    decor.flush();
                    decor.close();
                    errorsP.println("\tExit status: " + status);
                    errors.flush();
                    errorsP.close();
                }
                catch (Exception e) {
                    this.excList.add(e);
                }
                this.time = System.currentTimeMillis() - this.start;
                throw var14_14;
            }
            {
                var13_16 = null;
            }
            ** try [egrp 2[TRYBLOCK] [3 : 244->290)] { 
lbl48:
            // 1 sources

            decor.flush();
            decor.close();
            errorsP.println("\tExit status: " + status);
            errors.flush();
            errorsP.close();
            break block11;
lbl54:
            // 1 sources

            catch (Exception e) {
                this.excList.add(e);
            }
        }
        this.time = System.currentTimeMillis() - this.start;
        this.source = output.toString();
        this.log = errors.getBuffer();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void decompileFromArchive(String archivePath, String packege, String className) {
        this.start = System.currentTimeMillis();
        File workingDir = new File(String.valueOf(JavaDecompilerPlugin.getDefault().getPreferenceStore().getString("net.sf.feeling.decompiler.tempd")) + "/" + System.currentTimeMillis());
        try {
            try {
                workingDir.mkdirs();
                JarClassExtractor.extract(archivePath, packege, className, true, workingDir.getAbsolutePath());
                this.decompile(workingDir.getAbsolutePath(), "", className);
            }
            catch (Exception e) {
                this.excList.add(e);
                Object var6_6 = null;
                this.deltree(workingDir);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.deltree(workingDir);
            throw throwable;
        }
        {
            Object var6_8 = null;
            this.deltree(workingDir);
            return;
        }
    }

    void deltree(File root) {
        if (root.isFile()) {
            root.delete();
            return;
        }
        File[] children = root.listFiles();
        int i = 0;
        while (i < children.length) {
            this.deltree(children[i]);
            ++i;
        }
        root.delete();
    }

    public long getDecompilationTime() {
        return this.time;
    }

    public List getExceptions() {
        return this.excList;
    }

    public String getLog() {
        return this.log == null ? "" : this.log.toString();
    }

    public String getSource() {
        return this.source;
    }
}

