/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.decompiler.jdcore;

import java.io.File;
import java.util.HashMap;
import jd.ide.eclipse.editors.JDSourceMapper;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.core.PackageFragmentRoot;
import org.eclipse.jdt.internal.core.SourceMapper;
import org.eclipse.jface.preference.IPreferenceStore;
import org.sf.feeling.decompiler.JavaDecompilerPlugin;
import org.sf.feeling.decompiler.editor.DecompilerSourceMapper;
import org.sf.feeling.decompiler.util.DecompilerOutputUtil;
import org.sf.feeling.decompiler.util.SortMemberUtil;

public class JDCoreSourceMapper
extends JDSourceMapper {
    public char[] findSource(IPath path, String javaClassPath) {
        if (path == null) {
            return null;
        }
        IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
        path = resource == null ? path : resource.getRawLocation();
        File baseFile = path.toFile();
        if (!JDCoreSourceMapper.checkBaseFile(baseFile, javaClassPath)) {
            return null;
        }
        try {
            this.loadLibrary();
            String baseName = baseFile.getAbsolutePath();
            String result = this.decompile(baseName, javaClassPath);
            if (result != null) {
                return result.toCharArray();
            }
        }
        catch (Exception e) {
            JavaDecompilerPlugin.getDefault().getLog().log((IStatus)new Status(4, "net.sf.feeling.decompiler", 0, e.getMessage(), (Throwable)e));
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    private static boolean checkBaseFile(File baseFile, String javaClassPath) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [3 : 188->191)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static boolean endsWithIgnoreCase(String s, String suffix) {
        int suffixLength = suffix.length();
        int index = s.length() - suffixLength;
        return s.regionMatches(true, index, suffix, 0, suffixLength);
    }

    public JDCoreSourceMapper() {
        super((IPath)new Path("."), "", new HashMap());
    }

    public char[] findSource(IType type, IBinaryType info) {
        boolean useSorter;
        char[] attachedSource;
        IPreferenceStore prefs = JavaDecompilerPlugin.getDefault().getPreferenceStore();
        boolean always = prefs.getBoolean("net.sf.feeling.decompiler.alwaysuse");
        IPackageFragment pkgFrag = type.getPackageFragment();
        IPackageFragmentRoot root = (IPackageFragmentRoot)pkgFrag.getParent();
        if (originalSourceMapper.containsKey(root) && !always && (attachedSource = ((SourceMapper)originalSourceMapper.get(root)).findSource(type, info)) != null) {
            this.isAttachedSource = true;
            return attachedSource;
        }
        if (info == null) {
            return null;
        }
        try {
            if (root instanceof PackageFragmentRoot) {
                char[] attachedSource2;
                PackageFragmentRoot pfr = (PackageFragmentRoot)root;
                SourceMapper sourceMapper = pfr.getSourceMapper();
                if (sourceMapper != null && !always && !(sourceMapper instanceof DecompilerSourceMapper) && (attachedSource2 = sourceMapper.findSource(type, info)) != null) {
                    this.isAttachedSource = true;
                    return attachedSource2;
                }
                if (!originalSourceMapper.containsKey(root)) {
                    originalSourceMapper.put(root, sourceMapper);
                }
                if (sourceMapper != this) {
                    pfr.setSourceMapper((SourceMapper)this);
                }
            }
        }
        catch (JavaModelException e) {
            JavaDecompilerPlugin.logError(e, "Could not set source mapper.");
        }
        this.isAttachedSource = false;
        IPath classePath = root.getPath();
        String className = new String(info.getName());
        String fullName = new String(info.getFileName());
        className = fullName.substring(fullName.lastIndexOf(className));
        char[] returnSource = this.findSource(classePath, className);
        if (returnSource == null) {
            return null;
        }
        String code = "/*** Eclipse Class Decompiler plugin, copyright (c) 2012 Chao Chen (cnfree2000@hotmail.com) ***/\r\n" + new String(returnSource);
        boolean showLineNumber = prefs.getBoolean("jd.ide.eclipse.prefs.DisplayLineNumbers");
        boolean align = prefs.getBoolean("jd.ide.eclipse.prefs.Align");
        if (showLineNumber && align) {
            DecompilerOutputUtil decompilerOutputUtil = new DecompilerOutputUtil("JD-Core", code);
            code = decompilerOutputUtil.realign();
        }
        if (useSorter = prefs.getBoolean("net.sf.feeling.decompiler.use_eclipse_sorter")) {
            code = SortMemberUtil.sortMember(type.getPackageFragment().getElementName(), className, code);
        }
        StringBuffer source = new StringBuffer();
        source.append(this.formatSource(code));
        if (originalSourceMapper.containsKey(root)) {
            ((SourceMapper)originalSourceMapper.get(root)).mapSource(type, source.toString().toCharArray(), null);
        }
        return source.toString().toCharArray();
    }
}

