/*
 * Decompiled with CFR 0.152.
 */
package de.loskutov.bco.asm;

import de.loskutov.bco.asm.DecompiledClassInfo;
import de.loskutov.bco.asm.DecompiledMethod;
import de.loskutov.bco.asm.DecompilerOptions;
import de.loskutov.bco.asm.ICommentedClassVisitor;
import de.loskutov.bco.asm.Index;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.util.ASMifier;
import org.objectweb.asm.util.Printer;
import org.objectweb.asm.util.TraceMethodVisitor;

public class CommentedASMifierClassVisitor
extends ASMifier
implements ICommentedClassVisitor {
    protected final boolean showLines;
    protected final boolean showLocals;
    protected final boolean showStackMap;
    private final DecompilerOptions options;
    private String javaVersion;
    private int accessFlags;
    private LabelNode currentLabel;
    private int currentInsn;
    private ASMifier dummyAnnVisitor;
    private DecompiledMethod currMethod;
    private String className;
    private final ClassNode classNode;

    private CommentedASMifierClassVisitor(ClassNode classNode, DecompilerOptions options, String name, int id) {
        super(327680, name, id);
        this.classNode = classNode;
        this.options = options;
        this.showLines = options.modes.get(4);
        this.showLocals = options.modes.get(5);
        this.showStackMap = options.modes.get(9);
    }

    public CommentedASMifierClassVisitor(ClassNode classNode, DecompilerOptions options) {
        this(classNode, options, "cw", 0);
    }

    protected ASMifier createASMifier(String name1, int id1) {
        CommentedASMifierClassVisitor classVisitor = new CommentedASMifierClassVisitor(this.classNode, this.options, name1, id1);
        classVisitor.currMethod = this.currMethod;
        return classVisitor;
    }

    private void addIndex(int opcode) {
        this.text.add(new Index(this.currentLabel, this.currentInsn++, opcode));
    }

    void setCurrentLabel(LabelNode currentLabel) {
        this.currentLabel = currentLabel;
    }

    private boolean decompilingEntireClass() {
        return this.options.methodFilter == null && this.options.fieldFilter == null;
    }

    public void visit(int version, int access, String name1, String signature, String superName, String[] interfaces) {
        if (this.decompilingEntireClass()) {
            super.visit(version, access, name1, signature, superName, interfaces);
        }
        this.className = this.name;
        int major = version & 0xFFFF;
        int javaV = major % 44;
        if (javaV > 0 && javaV < 10) {
            this.javaVersion = "1." + javaV;
        }
        this.accessFlags = access;
    }

    public ASMifier visitClassAnnotation(String desc, boolean visible) {
        if (this.decompilingEntireClass()) {
            return super.visitClassAnnotation(desc, visible);
        }
        return this.getDummyVisitor();
    }

    public void visitClassAttribute(Attribute attr) {
        if (this.decompilingEntireClass()) {
            super.visitClassAttribute(attr);
        }
    }

    public void visitClassEnd() {
        if (this.decompilingEntireClass()) {
            super.visitClassEnd();
        }
    }

    public void visitInnerClass(String name1, String outerName, String innerName, int access) {
        if (this.decompilingEntireClass()) {
            super.visitInnerClass(name1, outerName, innerName, access);
        }
    }

    public void visitOuterClass(String owner, String name1, String desc) {
        if (this.decompilingEntireClass()) {
            super.visitOuterClass(owner, name1, desc);
        }
    }

    public void visitSource(String file, String debug) {
        if (this.decompilingEntireClass()) {
            super.visitSource(file, debug);
        }
    }

    public ASMifier visitMethod(int access, String name1, String desc, String signature, String[] exceptions) {
        if (this.options.fieldFilter != null || this.options.methodFilter != null && !this.options.methodFilter.equals(name1 + desc)) {
            return this.getDummyVisitor();
        }
        MethodNode meth = null;
        List<String> exList = Arrays.asList(exceptions);
        for (MethodNode mn : this.classNode.methods) {
            if (!mn.name.equals(name1) || !mn.desc.equals(desc) || !mn.exceptions.equals(exList)) continue;
            meth = mn;
            break;
        }
        assert (meth != null);
        this.currMethod = new DecompiledMethod(this.className, new HashMap<Label, Integer>(), meth, this.options, access);
        ASMifier textifier = super.visitMethod(access, name1, desc, signature, exceptions);
        TraceMethodVisitor tm = new TraceMethodVisitor((Printer)textifier);
        meth.accept((MethodVisitor)tm);
        Object methodEnd = this.text.remove(this.text.size() - 1);
        Object methodtext = this.text.remove(this.text.size() - 1);
        this.currMethod.setText((List)methodtext);
        this.text.add(this.currMethod);
        this.text.add(methodEnd);
        return textifier;
    }

    public ASMifier visitField(int access, String name1, String desc, String signature, Object value) {
        if (this.options.methodFilter != null) {
            return this.getDummyVisitor();
        }
        if (this.options.fieldFilter != null && !name1.equals(this.options.fieldFilter)) {
            return this.getDummyVisitor();
        }
        return super.visitField(access, name1, desc, signature, value);
    }

    public void visitFieldInsn(int opcode, String owner1, String name1, String desc) {
        this.addIndex(opcode);
        super.visitFieldInsn(opcode, owner1, name1, desc);
    }

    public void visitFrame(int type, int nLocal, Object[] local, int nStack, Object[] stack) {
        if (this.showStackMap) {
            this.addIndex(-1);
            super.visitFrame(type, nLocal, local, nStack, stack);
        }
    }

    public void visitInsn(int opcode) {
        this.addIndex(opcode);
        super.visitInsn(opcode);
    }

    public void visitIntInsn(int opcode, int operand) {
        this.addIndex(opcode);
        super.visitIntInsn(opcode, operand);
    }

    public void visitJumpInsn(int opcode, Label label) {
        this.addIndex(opcode);
        super.visitJumpInsn(opcode, label);
    }

    public void visitLabel(Label label) {
        this.addIndex(-1);
        super.visitLabel(label);
        InsnList instructions = this.currMethod.meth.instructions;
        LabelNode currLabel = null;
        for (int i = 0; i < instructions.size(); ++i) {
            LabelNode labelNode;
            AbstractInsnNode insnNode = instructions.get(i);
            if (!(insnNode instanceof LabelNode) || (labelNode = (LabelNode)insnNode).getLabel() != label) continue;
            currLabel = labelNode;
        }
        this.setCurrentLabel(currLabel);
    }

    public void visitLdcInsn(Object cst) {
        this.addIndex(18);
        super.visitLdcInsn(cst);
    }

    public void visitInvokeDynamicInsn(String name1, String desc, Handle bsm, Object ... bsmArgs) {
        this.addIndex(186);
        super.visitInvokeDynamicInsn(name1, desc, bsm, bsmArgs);
    }

    public void visitIincInsn(int var, int increment) {
        this.addIndex(132);
        super.visitIincInsn(var, increment);
    }

    public void visitLineNumber(int line, Label start) {
        if (this.showLines) {
            this.addIndex(-1);
            this.currMethod.addLineNumber(start, line);
            super.visitLineNumber(line, start);
        }
    }

    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        this.addIndex(171);
        super.visitLookupSwitchInsn(dflt, keys, labels);
    }

    public void visitLocalVariable(String name1, String desc, String signature, Label start, Label end, int index) {
        if (this.showLocals) {
            super.visitLocalVariable(name1, desc, signature, start, end, index);
        }
    }

    public void visitMaxs(int maxStack, int maxLocals) {
        super.visitMaxs(maxStack, maxLocals);
    }

    public void visitMethodInsn(int opcode, String owner, String name1, String desc) {
        this.addIndex(opcode);
        super.visitMethodInsn(opcode, owner, name1, desc);
    }

    public void visitMultiANewArrayInsn(String desc, int dims) {
        this.addIndex(197);
        super.visitMultiANewArrayInsn(desc, dims);
    }

    public void visitTableSwitchInsn(int min, int max, Label dflt, Label ... labels) {
        this.addIndex(170);
        super.visitTableSwitchInsn(min, max, dflt, labels);
    }

    public void visitTypeInsn(int opcode, String desc) {
        this.addIndex(opcode);
        super.visitTypeInsn(opcode, desc);
    }

    public void visitVarInsn(int opcode, int var) {
        this.addIndex(opcode);
        super.visitVarInsn(opcode, var);
    }

    @Override
    public DecompiledClassInfo getClassInfo() {
        return new DecompiledClassInfo(this.javaVersion, this.accessFlags);
    }

    private ASMifier getDummyVisitor() {
        if (this.dummyAnnVisitor == null) {
            this.dummyAnnVisitor = new ASMifier(327680, "", -1){

                public void visitAnnotationEnd() {
                    this.text.clear();
                }

                public void visitClassEnd() {
                    this.text.clear();
                }

                public void visitFieldEnd() {
                    this.text.clear();
                }

                public void visitMethodEnd() {
                    this.text.clear();
                }
            };
        }
        return this.dummyAnnVisitor;
    }
}

