/*
 * Decompiled with CFR 0.152.
 */
package de.loskutov.bco.asm;

import de.loskutov.bco.asm.DecompiledClassInfo;
import de.loskutov.bco.asm.DecompiledMethod;
import de.loskutov.bco.asm.LineRange;
import de.loskutov.bco.ui.JdtUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jface.text.ITextSelection;
import org.objectweb.asm.tree.ClassNode;

public class DecompiledClass {
    private final Map<DecompiledMethod, IJavaElement> methodToJavaElt;
    private final List<Object> text;
    private String value;
    private final ClassNode classNode;
    private int classSize;
    private final DecompiledClassInfo classInfo;

    public DecompiledClass(List<Object> text, DecompiledClassInfo classInfo, ClassNode classNode) {
        this.text = text;
        this.classInfo = classInfo;
        this.classNode = classNode;
        this.methodToJavaElt = new HashMap<DecompiledMethod, IJavaElement>();
    }

    public int getAccessFlags() {
        return this.classInfo.accessFlags;
    }

    public boolean isAbstractOrInterface() {
        int accessFlags = this.classInfo.accessFlags;
        return (accessFlags & 0x400) != 0 || (accessFlags & 0x200) != 0;
    }

    public boolean isDefaultMethodPossible() {
        return this.classInfo.major >= 8;
    }

    public String getText() {
        if (this.value == null) {
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < this.text.size(); ++i) {
                Object o = this.text.get(i);
                if (o instanceof DecompiledMethod) {
                    buf.append(((DecompiledMethod)o).getText());
                    continue;
                }
                buf.append(o);
            }
            this.value = buf.toString();
        }
        return this.value;
    }

    public String[][] getTextTable() {
        ArrayList<String[]> lines = new ArrayList<String[]>();
        for (int i = 0; i < this.text.size(); ++i) {
            Object o = this.text.get(i);
            if (o instanceof DecompiledMethod) {
                String[][] mlines = ((DecompiledMethod)o).getTextTable();
                for (int j = 0; j < mlines.length; ++j) {
                    lines.add(mlines[j]);
                }
                continue;
            }
            lines.add(new String[]{"", "", "", o.toString(), ""});
        }
        return (String[][])lines.toArray((T[])new String[lines.size()][]);
    }

    public int getBytecodeOffset(int decompiledLine) {
        int currentDecompiledLine = 0;
        for (int i = 0; i < this.text.size(); ++i) {
            Object o = this.text.get(i);
            if (o instanceof DecompiledMethod) {
                DecompiledMethod m = (DecompiledMethod)o;
                Integer offset = m.getBytecodeOffset(decompiledLine - currentDecompiledLine);
                if (offset != null) {
                    return offset;
                }
                currentDecompiledLine += m.getLineCount();
                continue;
            }
            ++currentDecompiledLine;
        }
        return -1;
    }

    public int getBytecodeInsn(int decompiledLine) {
        int currentDecompiledLine = 0;
        for (int i = 0; i < this.text.size(); ++i) {
            Object o = this.text.get(i);
            if (o instanceof DecompiledMethod) {
                DecompiledMethod m = (DecompiledMethod)o;
                Integer opcode = m.getBytecodeInsn(decompiledLine - currentDecompiledLine);
                if (opcode != null) {
                    return opcode;
                }
                currentDecompiledLine += m.getLineCount();
                continue;
            }
            ++currentDecompiledLine;
        }
        return -1;
    }

    public int getSourceLine(int decompiledLine) {
        int currentDecompiledLine = 0;
        for (int i = 0; i < this.text.size(); ++i) {
            Object o = this.text.get(i);
            if (o instanceof DecompiledMethod) {
                DecompiledMethod m = (DecompiledMethod)o;
                int l = m.getSourceLine(decompiledLine - currentDecompiledLine);
                if (l != -1) {
                    return l;
                }
                currentDecompiledLine += m.getLineCount();
                continue;
            }
            ++currentDecompiledLine;
        }
        return -1;
    }

    public DecompiledMethod getMethod(int decompiledLine) {
        int currentDecompiledLine = 0;
        for (int i = 0; i < this.text.size(); ++i) {
            Object o = this.text.get(i);
            if (o instanceof DecompiledMethod) {
                DecompiledMethod m = (DecompiledMethod)o;
                int l = m.getSourceLine(decompiledLine - currentDecompiledLine);
                if (l != -1) {
                    return m;
                }
                currentDecompiledLine += m.getLineCount();
                continue;
            }
            ++currentDecompiledLine;
        }
        return null;
    }

    public DecompiledMethod getMethod(String signature) {
        for (int i = 0; i < this.text.size(); ++i) {
            DecompiledMethod m;
            Object o = this.text.get(i);
            if (!(o instanceof DecompiledMethod) || !signature.equals((m = (DecompiledMethod)o).getSignature())) continue;
            return m;
        }
        return null;
    }

    public IJavaElement getJavaElement(int decompiledLine, IClassFile clazz) {
        DecompiledMethod method = this.getMethod(decompiledLine);
        if (method != null) {
            IJavaElement javaElement = this.methodToJavaElt.get(method);
            if (javaElement == null) {
                javaElement = JdtUtils.getMethod((IParent)clazz, method.getSignature());
                if (javaElement != null) {
                    this.methodToJavaElt.put(method, javaElement);
                } else {
                    javaElement = clazz;
                }
            }
            return javaElement;
        }
        return clazz;
    }

    public int getDecompiledLine(String methSignature) {
        int currentDecompiledLine = 0;
        for (int i = 0; i < this.text.size(); ++i) {
            Object o = this.text.get(i);
            if (o instanceof DecompiledMethod) {
                DecompiledMethod m = (DecompiledMethod)o;
                if (methSignature.equals(m.getSignature())) {
                    return currentDecompiledLine;
                }
                currentDecompiledLine += m.getLineCount();
                continue;
            }
            ++currentDecompiledLine;
        }
        return 0;
    }

    public String[] getFrame(int decompiledLine, boolean showQualifiedNames) {
        int currentDecompiledLine = 0;
        for (int i = 0; i < this.text.size(); ++i) {
            Object o = this.text.get(i);
            if (o instanceof DecompiledMethod) {
                DecompiledMethod m = (DecompiledMethod)o;
                String[] frame = m.getFrame(decompiledLine - currentDecompiledLine, showQualifiedNames);
                if (frame != null) {
                    return frame;
                }
                currentDecompiledLine += m.getLineCount();
                continue;
            }
            ++currentDecompiledLine;
        }
        return null;
    }

    public String[][][] getFrameTablesForInsn(int insn, boolean useQualifiedNames) {
        for (int i = 0; i < this.text.size(); ++i) {
            DecompiledMethod m;
            String[][][] frame;
            Object o = this.text.get(i);
            if (!(o instanceof DecompiledMethod) || (frame = (m = (DecompiledMethod)o).getFrameTablesForInsn(insn, useQualifiedNames)) == null) continue;
            return frame;
        }
        return null;
    }

    public String[][][] getFrameTables(int decompiledLine, boolean useQualifiedNames) {
        int currentDecompiledLine = 0;
        for (int i = 0; i < this.text.size(); ++i) {
            Object o = this.text.get(i);
            if (o instanceof DecompiledMethod) {
                DecompiledMethod m = (DecompiledMethod)o;
                String[][][] frame = m.getFrameTables(decompiledLine - currentDecompiledLine, useQualifiedNames);
                if (frame != null) {
                    return frame;
                }
                currentDecompiledLine += m.getLineCount();
                continue;
            }
            ++currentDecompiledLine;
        }
        return null;
    }

    public int getDecompiledLine(int sourceLine) {
        int currentDecompiledLine = 0;
        for (int i = 0; i < this.text.size(); ++i) {
            Object o = this.text.get(i);
            if (o instanceof DecompiledMethod) {
                DecompiledMethod m = (DecompiledMethod)o;
                int l = m.getDecompiledLine(sourceLine);
                if (l != -1) {
                    return l + currentDecompiledLine;
                }
                currentDecompiledLine += m.getLineCount();
                continue;
            }
            ++currentDecompiledLine;
        }
        return -1;
    }

    public int getDecompiledLine(DecompiledMethod m1, int decompiledLine) {
        int currentDecompiledLine = 0;
        for (int i = 0; i < this.text.size(); ++i) {
            Object o = this.text.get(i);
            if (o instanceof DecompiledMethod) {
                if (o == m1) {
                    return currentDecompiledLine + decompiledLine;
                }
                DecompiledMethod m = (DecompiledMethod)o;
                currentDecompiledLine += m.getLineCount();
                continue;
            }
            ++currentDecompiledLine;
        }
        return -1;
    }

    public List<Integer> getErrorLines() {
        ArrayList<Integer> errors = new ArrayList<Integer>();
        int currentDecompiledLine = 0;
        for (int i = 0; i < this.text.size(); ++i) {
            Object o = this.text.get(i);
            if (o instanceof DecompiledMethod) {
                DecompiledMethod m = (DecompiledMethod)o;
                int l = m.getErrorLine();
                if (l != -1) {
                    errors.add(l + currentDecompiledLine);
                }
                currentDecompiledLine += m.getLineCount();
                continue;
            }
            ++currentDecompiledLine;
        }
        return errors;
    }

    public DecompiledMethod getBestDecompiledMatch(int sourceLine) {
        DecompiledMethod bestM = null;
        for (int i = 0; i < this.text.size(); ++i) {
            Object o = this.text.get(i);
            if (!(o instanceof DecompiledMethod)) continue;
            DecompiledMethod m = (DecompiledMethod)o;
            int line = m.getBestDecompiledLine(sourceLine);
            if (line > 0) {
                if (m.isInit()) {
                    if (bestM != null) {
                        int d1 = sourceLine - bestM.getFirstSourceLine();
                        int d2 = sourceLine - m.getFirstSourceLine();
                        if (d2 >= d1) continue;
                        bestM = m;
                        continue;
                    }
                    bestM = m;
                    continue;
                }
                return m;
            }
            if (bestM == null || !bestM.isInit() || bestM.getFirstSourceLine() >= m.getFirstSourceLine() || bestM.getLastSourceLine() <= m.getLastSourceLine()) continue;
            bestM = null;
        }
        return bestM;
    }

    public LineRange getDecompiledRange(ITextSelection sourceRange) {
        int endDecompiledLine;
        int startLine = sourceRange.getStartLine() + 1;
        int endLine = sourceRange.getEndLine() + 1;
        int startDecompiledLine = this.getDecompiledLine(startLine);
        DecompiledMethod m1 = null;
        DecompiledMethod m2 = null;
        if (startDecompiledLine < 0) {
            m1 = this.getBestDecompiledMatch(startLine);
            m2 = this.getBestDecompiledMatch(endLine);
            if (m1 != null && m1.equals(m2)) {
                int methodStartLine = this.getDecompiledLine(m1.getSignature());
                startDecompiledLine = m1.getBestDecompiledLine(startLine);
                startDecompiledLine = startDecompiledLine >= 0 ? methodStartLine + startDecompiledLine : methodStartLine + m1.getLineCount();
            }
        }
        if ((endDecompiledLine = this.getDecompiledLine(endLine)) < 0) {
            if (m2 == null) {
                m2 = this.getBestDecompiledMatch(endLine);
            }
            if (m2 != null && m2.equals(m1)) {
                int methodStartLine = this.getDecompiledLine(m2.getSignature());
                endDecompiledLine = m2.getBestDecompiledLine(endLine);
                endDecompiledLine = endDecompiledLine >= 0 ? methodStartLine + endDecompiledLine : methodStartLine + m2.getLineCount();
                if (endDecompiledLine < startDecompiledLine) {
                    endDecompiledLine = startDecompiledLine + 1;
                }
            }
        }
        return new LineRange(startDecompiledLine, endDecompiledLine);
    }

    public LineRange getSourceRange(LineRange decompiledRange) {
        int startSourceLine = this.getSourceLine(decompiledRange.startLine);
        int endSourceLine = this.getSourceLine(decompiledRange.endLine);
        return new LineRange(startSourceLine, endSourceLine);
    }

    public ClassNode getClassNode() {
        return this.classNode;
    }

    public void setClassSize(int classSize) {
        this.classSize = classSize;
    }

    public int getClassSize() {
        return this.classSize;
    }

    public String getJavaVersion() {
        return this.classInfo.javaVersion;
    }
}

