/*
 * Decompiled with CFR 0.152.
 */
package de.loskutov.bco.preferences;

import de.loskutov.bco.BytecodeOutlinePlugin;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;

public class SupportPanel {
    static void createSupportLinks(Composite defPanel) {
        Group commonPanel = new Group(defPanel, 0);
        GridData gridData = new GridData(4, 4, true, false);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginWidth = 0;
        commonPanel.setLayout((Layout)layout);
        commonPanel.setLayoutData((Object)gridData);
        String pluginName = "BytecodeOutline";
        commonPanel.setText("Support " + pluginName + " plugin and get support too :-)");
        Label label = new Label((Composite)commonPanel, 0);
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        label.setText("Feel free to support " + pluginName + " plugin in the way you like:");
        Font font = JFaceResources.getFontRegistry().getBold(JFaceResources.getDialogFont().getFontData()[0].getName());
        Link link = new Link((Composite)commonPanel, 0);
        link.setFont(font);
        link.setText(" - <a>visit homepage</a>");
        link.setToolTipText("You need just a sense of humor!");
        link.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                SupportPanel.handleUrlClick("http://andrei.gmxhome.de/bytecode");
            }
        });
        link = new Link((Composite)commonPanel, 0);
        link.setFont(font);
        link.setText(" - <a>report issue or feature request</a>");
        link.setToolTipText("You need a valid account at ow2.org!");
        link.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                SupportPanel.handleUrlClick("http://forge.ow2.org/tracker/?group_id=23");
            }
        });
        link = new Link((Composite)commonPanel, 0);
        link.setFont(font);
        link.setText(" - <a>add to your favorites at Eclipse MarketPlace</a>");
        link.setToolTipText("You need a valid bugzilla account at Eclipse.org!");
        link.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                SupportPanel.handleUrlClick("http://marketplace.eclipse.org/content/bytecode-outline");
            }
        });
        link = new Link((Composite)commonPanel, 0);
        link.setFont(font);
        link.setText(" - <a>make a donation to support plugin development</a>");
        link.setToolTipText("You do NOT need a PayPal account!");
        link.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                SupportPanel.handleUrlClick("https://www.paypal.com/cgi-bin/webscr?cmd=_s-xclick&hosted_button_id=R5SHJLNGUXKHU");
            }
        });
    }

    private static void handleUrlClick(String urlStr) {
        try {
            IWorkbenchBrowserSupport support = PlatformUI.getWorkbench().getBrowserSupport();
            IWebBrowser externalBrowser = support.getExternalBrowser();
            if (externalBrowser != null) {
                externalBrowser.openURL(new URL(urlStr));
            } else {
                IWebBrowser browser = support.createBrowser(urlStr);
                if (browser != null) {
                    browser.openURL(new URL(urlStr));
                }
            }
        }
        catch (PartInitException e) {
            BytecodeOutlinePlugin.error("Failed to open url " + urlStr, e);
        }
        catch (MalformedURLException e) {
            BytecodeOutlinePlugin.error("Failed to open url " + urlStr, e);
        }
    }
}

