/*
 * Decompiled with CFR 0.152.
 */
package de.loskutov.bco.ui;

import de.loskutov.bco.BytecodeOutlinePlugin;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;

public class TypeFactory {
    static final char SEPARATOR = '/';
    static final char EXTENSION_SEPARATOR = '.';
    static final char PACKAGE_PART_SEPARATOR = '.';
    private final String[] fProjects = TypeFactory.getProjectList();
    private char[][] enclosingNames;
    private String simpleTypeName;

    private IType getType(IJavaSearchScope searchScope, IJavaElement container) {
        try {
            if (container instanceof ICompilationUnit) {
                return TypeFactory.findTypeInCompilationUnit((ICompilationUnit)container, this.getTypeQualifiedName());
            }
            if (container instanceof IClassFile) {
                return ((IClassFile)container).getType();
            }
            return null;
        }
        catch (JavaModelException e) {
            BytecodeOutlinePlugin.error("getType() fails for: " + this.simpleTypeName, e);
            return null;
        }
    }

    public String getTypeQualifiedName() {
        if (this.enclosingNames != null && this.enclosingNames.length > 0) {
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < this.enclosingNames.length; ++i) {
                buf.append(this.enclosingNames[i]);
                buf.append('.');
            }
            buf.append(this.simpleTypeName);
            return buf.toString();
        }
        return this.simpleTypeName;
    }

    public IType create(char[] packageName, char[] simpleTypeName1, char[][] enclosingName, int modifiers, String path, IJavaSearchScope searchScope) {
        this.enclosingNames = enclosingName;
        this.simpleTypeName = new String(simpleTypeName1);
        String pn = new String(packageName);
        int index = path.indexOf("|");
        IType result = null;
        if (index != -1) {
            result = this.createJarFileEntryTypeInfo(pn, this.simpleTypeName, enclosingName, modifiers, path, index, searchScope);
        } else {
            String project = this.getProject(path);
            if (project != null) {
                result = this.createIFileTypeInfo(pn, this.simpleTypeName, enclosingName, modifiers, path, project, searchScope);
            }
        }
        return result;
    }

    private IType createIFileTypeInfo(String packageName, String typeName, char[][] enclosingName, int modifiers, String path, String project, IJavaSearchScope searchScope) {
        String rest = path.substring(project.length() + 1);
        int index = rest.lastIndexOf(47);
        if (index == -1) {
            return null;
        }
        String middle = rest.substring(0, index);
        rest = rest.substring(index + 1);
        index = rest.lastIndexOf(46);
        String file = null;
        String extension = null;
        if (index == -1) {
            return null;
        }
        file = rest.substring(0, index);
        extension = rest.substring(index + 1);
        String src = null;
        int ml = middle.length();
        int pl = packageName.length();
        if (ml > 0 && ml - 1 > pl) {
            src = middle.substring(1, ml - pl - (pl > 0 ? 1 : 0));
        }
        if (typeName.equals(file)) {
            file = typeName;
        }
        IFileTypeInfo fileTypeInfo = new IFileTypeInfo(packageName, typeName, enclosingName, modifiers, project, src, file, extension);
        IJavaElement container = fileTypeInfo.getContainer(searchScope);
        return this.getType(searchScope, container);
    }

    protected IType createJarFileEntryTypeInfo(String packageName, String typeName, char[][] enclosingName, int modifiers, String path, int index, IJavaSearchScope searchScope) {
        String jar = path.substring(0, index);
        String rest = path.substring(index + 1);
        if ((index = rest.lastIndexOf(47)) != -1) {
            rest = rest.substring(index + 1);
        }
        String file = null;
        String extension = null;
        index = rest.lastIndexOf(46);
        if (index == -1) {
            return null;
        }
        file = rest.substring(0, index);
        extension = rest.substring(index + 1);
        if (typeName.equals(file)) {
            file = typeName;
        }
        JarFileEntryTypeInfo info = new JarFileEntryTypeInfo(packageName, typeName, enclosingName, modifiers, jar, file, extension);
        try {
            IJavaElement container = info.getContainer(searchScope);
            return this.getType(searchScope, container);
        }
        catch (JavaModelException e) {
            BytecodeOutlinePlugin.error("createJarFileEntryTypeInfo() fails for: " + this.simpleTypeName, e);
            return null;
        }
    }

    private String getProject(String path) {
        for (int i = 0; i < this.fProjects.length; ++i) {
            String project = this.fProjects[i];
            if (!path.startsWith(project, 1)) continue;
            return project;
        }
        return null;
    }

    private static String[] getProjectList() {
        String[] result;
        IJavaModel model = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
        try {
            IJavaProject[] projects = model.getJavaProjects();
            result = new String[projects.length];
            for (int i = 0; i < projects.length; ++i) {
                result[i] = projects[i].getElementName();
            }
        }
        catch (JavaModelException e) {
            result = new String[]{};
        }
        Arrays.sort(result, new Comparator(){

            public int compare(Object o1, Object o2) {
                int l2;
                int l1 = ((String)o1).length();
                if (l1 < (l2 = ((String)o2).length())) {
                    return 1;
                }
                if (l2 < l1) {
                    return -1;
                }
                return 0;
            }
        });
        return result;
    }

    private static String getTypeQualifiedName(IType type) {
        try {
            IType declaringType;
            if (type.isBinary() && !type.isAnonymous() && (declaringType = type.getDeclaringType()) != null) {
                return TypeFactory.getTypeQualifiedName(declaringType) + '.' + type.getElementName();
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        return type.getTypeQualifiedName('.');
    }

    private static IType findTypeInCompilationUnit(ICompilationUnit cu, String typeQualifiedName) throws JavaModelException {
        IType[] types = cu.getAllTypes();
        for (int i = 0; i < types.length; ++i) {
            String currName = TypeFactory.getTypeQualifiedName(types[i]);
            if (!typeQualifiedName.equals(currName)) continue;
            return types[i];
        }
        return null;
    }

    private static final class IFileTypeInfo {
        private final String fProject;
        private final String fFolder;
        private final String fFile;
        private final String fExtension;
        private final String pkg;

        public IFileTypeInfo(String pkg, String name, char[][] enclosingTypes, int modifiers, String project, String sourceFolder, String file, String extension) {
            this.pkg = pkg;
            this.fProject = project;
            this.fFolder = sourceFolder;
            this.fFile = file;
            this.fExtension = extension;
        }

        private IJavaElement getContainer(IJavaSearchScope scope) {
            IJavaElement elem;
            Path path;
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IResource resource = root.findMember((IPath)(path = new Path(this.getPath())));
            if (resource != null && (elem = JavaCore.create((IResource)resource)) != null && elem.exists()) {
                return elem;
            }
            return null;
        }

        private String getPath() {
            StringBuffer result = new StringBuffer();
            result.append('/');
            result.append(this.fProject);
            result.append('/');
            if (this.fFolder != null && this.fFolder.length() > 0) {
                result.append(this.fFolder);
                result.append('/');
            }
            if (this.pkg != null && this.pkg.length() > 0) {
                result.append(this.pkg.replace('.', '/'));
                result.append('/');
            }
            result.append(this.fFile);
            result.append('.');
            result.append(this.fExtension);
            return result.toString();
        }
    }

    private static final class JarFileEntryTypeInfo {
        private final String fJar;
        private final String fFileName;
        private final String fExtension;
        private final String pkg;

        public JarFileEntryTypeInfo(String pkg, String name, char[][] enclosingTypes, int modifiers, String jar, String fileName, String extension) {
            this.pkg = pkg;
            this.fJar = jar;
            this.fFileName = fileName;
            this.fExtension = extension;
        }

        private IJavaElement getContainer(IJavaSearchScope scope) throws JavaModelException {
            IJavaModel jmodel = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
            IPath[] enclosedPaths = scope.enclosingProjectsAndJars();
            for (int i = 0; i < enclosedPaths.length; ++i) {
                IJavaProject jproject;
                IPackageFragmentRoot root;
                IPath curr = enclosedPaths[i];
                if (curr.segmentCount() != 1 || !(root = (jproject = jmodel.getJavaProject(curr.segment(0))).getPackageFragmentRoot(this.fJar)).exists()) continue;
                return this.findElementInRoot(root);
            }
            List<IPath> paths = Arrays.asList(enclosedPaths);
            IJavaProject[] projects = jmodel.getJavaProjects();
            for (int i = 0; i < projects.length; ++i) {
                IPackageFragmentRoot root;
                IJavaProject jproject = projects[i];
                if (paths.contains(jproject.getPath()) || !(root = jproject.getPackageFragmentRoot(this.fJar)).exists()) continue;
                return this.findElementInRoot(root);
            }
            return null;
        }

        private IJavaElement findElementInRoot(IPackageFragmentRoot root) {
            IClassFile res;
            IPackageFragment frag = root.getPackageFragment(this.pkg);
            String extension = this.fExtension;
            String fullName = this.fFileName + '.' + extension;
            if ("class".equals(extension)) {
                res = frag.getClassFile(fullName);
            } else if (JavaCore.isJavaLikeFileName((String)fullName)) {
                res = frag.getCompilationUnit(fullName);
            } else {
                return null;
            }
            if (res.exists()) {
                return res;
            }
            return null;
        }
    }
}

