/*
 * Decompiled with CFR 0.152.
 */
package de.loskutov.bco.views;

import de.loskutov.bco.BytecodeOutlinePlugin;
import de.loskutov.bco.asm.DecompiledClass;
import de.loskutov.bco.asm.DecompiledMethod;
import de.loskutov.bco.asm.DecompilerHelper;
import de.loskutov.bco.asm.DecompilerOptions;
import de.loskutov.bco.asm.LineRange;
import de.loskutov.bco.editors.BytecodeClassFileEditor;
import de.loskutov.bco.ui.EclipseUtils;
import de.loskutov.bco.ui.JdtUtils;
import de.loskutov.bco.ui.actions.DefaultToggleAction;
import de.loskutov.bco.views.BCOViewSelectionProvider;
import de.loskutov.bco.views.EditorListener;
import de.loskutov.bco.views.HelpUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.IFileBufferListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.javaeditor.JavaElementHyperlink;
import org.eclipse.jdt.internal.ui.javaeditor.JavaElementHyperlinkDetector;
import org.eclipse.jdt.internal.ui.javaeditor.JavaSourceViewer;
import org.eclipse.jdt.internal.ui.text.JavaWordFinder;
import org.eclipse.jdt.internal.ui.text.java.hover.JavadocBrowserInformationControlInput;
import org.eclipse.jdt.internal.ui.text.java.hover.JavadocHover;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jdt.ui.text.IColorManager;
import org.eclipse.jdt.ui.text.JavaSourceViewerConfiguration;
import org.eclipse.jdt.ui.text.JavaTextTools;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.StatusLineManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.quickassist.IQuickAssistAssistant;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.console.actions.TextViewerAction;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.texteditor.FindReplaceAction;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.IUpdate;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.util.Printer;

public class BytecodeOutlineView
extends ViewPart {
    static final int VIEW_ORIENTATION_VERTICAL = 0;
    static final int VIEW_ORIENTATION_HORIZONTAL = 1;
    static final int VIEW_ORIENTATION_AUTOMATIC = 2;
    int orientation = 2;
    private int currentOrientation;
    protected ToggleOrientationAction[] toggleOrientationActions;
    protected BitSet modes = new BitSet();
    protected boolean inputChanged;
    protected boolean bufferIsDirty;
    private boolean isEnabled;
    private boolean isActive;
    private boolean isVisible;
    protected Composite stackComposite;
    protected StyledText textControl;
    protected JavaSourceViewer textViewer;
    protected SashForm verifyControl;
    protected SashForm stackAndLvt;
    protected Table tableControl;
    protected TableViewer tableControlViewer;
    protected Table stackTable;
    protected Table lvtTable;
    protected ITextEditor javaEditor;
    private IJavaElement javaInput;
    protected IJavaElement lastChildElement;
    protected ITextSelection currentSelection;
    protected EditorListener editorListener;
    protected Action selectionChangedAction;
    protected Action refreshVarsAndStackAction;
    protected DefaultToggleAction linkWithEditorAction;
    protected DefaultToggleAction showSelectedOnlyAction;
    protected DefaultToggleAction setRawModeAction;
    protected DefaultToggleAction toggleASMifierModeAction;
    protected DefaultToggleAction hideLineInfoAction;
    protected DefaultToggleAction hideLocalsAction;
    protected DefaultToggleAction hideStackMapAction;
    protected DefaultToggleAction showHexValuesAction;
    protected DefaultToggleAction expandStackMapAction;
    protected DefaultToggleAction toggleVerifierAction;
    protected StatusLineManager statusLineManager;
    protected BCOViewSelectionProvider viewSelectionProvider;
    protected Color errorColor;
    private DecompiledClass lastDecompiledResult;
    protected Map<String, IAction> globalActions = new HashMap<String, IAction>();
    protected List<String> selectionActions = new ArrayList<String>();
    private MenuManager contextMenuManager;
    protected String currentStatusMessage;
    protected boolean hasAnalyzerError;
    private boolean restoreVerify;
    private static final String NLS_PREFIX = "BytecodeOutlineView.";
    private ITextListener textListener;
    private ISelectionChangedListener textSelectionListener;
    private Control statusControl;
    private BytecodeClassFileEditor dummyEditorForHyperlinks;

    protected void setJavaInput(IJavaElement javaInput) {
        this.javaInput = javaInput;
        this.inputChanged = true;
    }

    protected boolean isLinkedWithEditor() {
        return this.modes.get(0);
    }

    private boolean isEnabled() {
        return this.isEnabled;
    }

    private void setEnabled(boolean on) {
        this.isEnabled = on;
        if (this.tableControl != null && !this.tableControl.isDisposed()) {
            this.tableControl.setEnabled(on);
        }
        if (this.stackTable != null && !this.stackTable.isDisposed()) {
            this.stackTable.setEnabled(on);
        }
        if (this.lvtTable != null && !this.lvtTable.isDisposed()) {
            this.lvtTable.setEnabled(on);
        }
        this.showSelectedOnlyAction.setEnabled(on);
        this.selectionChangedAction.setEnabled(on);
        this.toggleVerifierAction.setEnabled(on);
        this.hideLocalsAction.setEnabled(on);
        this.hideLineInfoAction.setEnabled(on);
        this.hideStackMapAction.setEnabled(on);
        this.showHexValuesAction.setEnabled(on);
        this.toggleASMifierModeAction.setEnabled(on);
        this.expandStackMapAction.setEnabled(on);
        this.setRawModeAction.setEnabled(on && !this.toggleASMifierModeAction.isChecked());
        boolean showAnalyzer = on && this.toggleVerifierAction.isChecked();
        for (int i = 0; i < this.toggleOrientationActions.length; ++i) {
            this.toggleOrientationActions[i].setEnabled(showAnalyzer);
        }
    }

    private boolean isActive() {
        return this.isActive;
    }

    private void setBufferIsDirty(boolean bufferIsDirty) {
        this.bufferIsDirty = bufferIsDirty;
    }

    private void setInput(ITextEditor editor) {
        this.javaEditor = null;
        this.setJavaInput(null);
        this.lastDecompiledResult = null;
        if (editor != null) {
            IJavaElement javaElem = EclipseUtils.getJavaInput((IEditorPart)editor);
            if (javaElem == null) {
                return;
            }
            this.setJavaInput(javaElem);
            this.javaEditor = editor;
            this.checkVerifyMode();
            this.updateSelection(EclipseUtils.getSelection(this.javaEditor.getSelectionProvider()));
            this.setBufferIsDirty(editor.isDirty());
        }
    }

    private void checkVerifyMode() {
        boolean aoi = JdtUtils.isAbstractOrInterface(this.javaInput);
        if (!this.toggleVerifierAction.isChecked()) {
            this.toggleVerifierAction.setEnabled(!aoi);
            this.restoreVerify = false;
        } else if (aoi) {
            this.inputChanged = true;
            this.toggleVerifyMode(this.getViewSite().getActionBars().getMenuManager(), false);
            this.restoreVerify = true;
        } else {
            if (this.restoreVerify) {
                this.inputChanged = true;
                this.toggleVerifierAction.setEnabled(true);
                this.toggleVerifyMode(this.getViewSite().getActionBars().getMenuManager(), true);
            }
            this.restoreVerify = false;
        }
    }

    private boolean updateSelection(ITextSelection sel) {
        if (sel != null && (sel.equals(this.currentSelection) || this.currentSelection != null && sel.getStartLine() == this.currentSelection.getStartLine() && sel.getEndLine() == this.currentSelection.getEndLine())) {
            return false;
        }
        this.currentSelection = sel;
        return true;
    }

    public void init(IViewSite site) {
        super.setSite((IWorkbenchPartSite)site);
        if (this.editorListener == null) {
            this.editorListener = new EditorListener(this);
            this.getSite().getWorkbenchWindow().getPartService().addPartListener((IPartListener2)this.editorListener);
        }
    }

    public void createPartControl(Composite parent) {
        this.errorColor = parent.getDisplay().getSystemColor(3);
        parent.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
            }

            public void controlResized(ControlEvent e) {
                BytecodeOutlineView.this.computeOrientation();
            }
        });
        GridLayout parentLayout = new GridLayout();
        parentLayout.numColumns = 1;
        parentLayout.marginBottom = -5;
        parentLayout.marginTop = -5;
        parentLayout.marginLeft = -5;
        parentLayout.marginRight = -5;
        parent.setLayout((Layout)parentLayout);
        this.stackComposite = new Composite(parent, 0);
        this.stackComposite.setLayoutData((Object)new GridData(1808));
        this.stackComposite.setLayout((Layout)new StackLayout());
        this.statusLineManager = new StatusLineManager();
        this.statusControl = this.statusLineManager.createControl(parent, 0);
        this.statusControl.setLayoutData((Object)new GridData(768));
        this.createTextControl();
        this.createTextContextMenu();
        this.createVerifyControl();
        this.initModes();
        ((StackLayout)this.stackComposite.getLayout()).topControl = this.modes.get(8) ? this.verifyControl : this.textControl;
        this.createSelectionProvider();
        this.createToolbarActions();
        this.setEnabled(false);
    }

    private void initModes() {
        IPreferenceStore store = BytecodeOutlinePlugin.getDefault().getPreferenceStore();
        this.modes.set(0, store.getBoolean("linkViewToEditor"));
        this.modes.set(1, store.getBoolean("showOnlySelectedElement"));
        this.modes.set(3, store.getBoolean("showRawBytecode"));
        this.modes.set(4, store.getBoolean("showLineInfo"));
        this.modes.set(5, store.getBoolean("showVariables"));
        this.modes.set(9, store.getBoolean("showStackmap"));
        this.modes.set(7, store.getBoolean("expandStackmap"));
        this.modes.set(2, store.getBoolean("showASMifierCode"));
        this.modes.set(8, store.getBoolean("showAnalyzer"));
        this.modes.set(10, store.getBoolean("showHexValues"));
    }

    private void createToolbarActions() {
        this.createTextActions();
        IActionBars bars = this.getViewSite().getActionBars();
        IToolBarManager tmanager = bars.getToolBarManager();
        final IMenuManager mmanager = bars.getMenuManager();
        this.selectionChangedAction = new Action(){

            public void run() {
                Point selection = BytecodeOutlineView.this.textControl.getSelection();
                BytecodeOutlineView.this.setSelectionInJavaEditor(selection);
            }
        };
        this.refreshVarsAndStackAction = new Action(){

            public void run() {
                int selectionIndex = BytecodeOutlineView.this.tableControl.getSelectionIndex();
                TableItem[] items = BytecodeOutlineView.this.tableControl.getSelection();
                if (items == null || items.length < 1) {
                    return;
                }
                String line = items[0].getText(0);
                if (line == null || "".equals(line)) {
                    return;
                }
                Integer valueOf = Integer.valueOf(line);
                if (valueOf != null) {
                    BytecodeOutlineView.this.updateVerifierControl4insn(valueOf);
                    BytecodeOutlineView.this.tableControl.setSelection(selectionIndex);
                }
            }
        };
        this.linkWithEditorAction = new DefaultToggleAction("linkViewToEditor"){

            @Override
            public void run(boolean newState) {
                BytecodeOutlineView.this.setMode(0, newState);
                if (BytecodeOutlineView.this.modes.get(0)) {
                    BytecodeOutlineView.this.showSelectedOnlyAction.setEnabled(true);
                    BytecodeOutlineView.this.toggleVerifierAction.setEnabled(true);
                    BytecodeOutlineView.this.hideLineInfoAction.setEnabled(true);
                    BytecodeOutlineView.this.hideLocalsAction.setEnabled(true);
                    BytecodeOutlineView.this.toggleASMifierModeAction.setEnabled(true);
                    if (!BytecodeOutlineView.this.toggleASMifierModeAction.isChecked()) {
                        BytecodeOutlineView.this.setRawModeAction.setEnabled(true);
                    }
                    BytecodeOutlineView.this.activateView();
                    BytecodeOutlineView.this.checkOpenEditors(true);
                    BytecodeOutlineView.this.inputChanged = true;
                    BytecodeOutlineView.this.refreshView();
                }
            }
        };
        this.showSelectedOnlyAction = new DefaultToggleAction("showOnlySelectedElement"){

            @Override
            public void run(boolean newState) {
                BytecodeOutlineView.this.setMode(1, newState);
                BytecodeOutlineView.this.inputChanged = true;
                BytecodeOutlineView.this.refreshView();
            }
        };
        this.setRawModeAction = new DefaultToggleAction("showRawBytecode"){

            @Override
            public void run(boolean newState) {
                BytecodeOutlineView.this.setMode(3, newState);
                BytecodeOutlineView.this.inputChanged = true;
                BytecodeOutlineView.this.refreshView();
            }
        };
        this.hideLineInfoAction = new DefaultToggleAction("showLineInfo"){

            @Override
            public void run(boolean newState) {
                BytecodeOutlineView.this.setMode(4, newState);
                BytecodeOutlineView.this.inputChanged = true;
                BytecodeOutlineView.this.refreshView();
            }
        };
        this.hideLocalsAction = new DefaultToggleAction("showVariables"){

            @Override
            public void run(boolean newState) {
                BytecodeOutlineView.this.setMode(5, newState);
                BytecodeOutlineView.this.inputChanged = true;
                BytecodeOutlineView.this.refreshView();
            }
        };
        this.hideStackMapAction = new DefaultToggleAction("showStackmap"){

            @Override
            public void run(boolean newState) {
                BytecodeOutlineView.this.setMode(9, newState);
                BytecodeOutlineView.this.inputChanged = true;
                BytecodeOutlineView.this.refreshView();
            }
        };
        this.expandStackMapAction = new DefaultToggleAction("expandStackmap"){

            @Override
            public void run(boolean newState) {
                BytecodeOutlineView.this.setMode(7, newState);
                BytecodeOutlineView.this.inputChanged = true;
                BytecodeOutlineView.this.refreshView();
            }
        };
        this.showHexValuesAction = new DefaultToggleAction("showHexValues"){

            @Override
            public void run(boolean newState) {
                BytecodeOutlineView.this.setMode(10, newState);
                BytecodeOutlineView.this.inputChanged = true;
                BytecodeOutlineView.this.refreshView();
            }
        };
        this.toggleASMifierModeAction = new DefaultToggleAction("showASMifierCode"){

            @Override
            public void run(boolean newState) {
                BytecodeOutlineView.this.setMode(2, newState);
                if (newState) {
                    BytecodeOutlineView.this.setMode(3, true);
                    BytecodeOutlineView.this.setRawModeAction.setEnabled(false);
                } else {
                    BytecodeOutlineView.this.setRawModeAction.setEnabled(true);
                }
                BytecodeOutlineView.this.inputChanged = true;
                BytecodeOutlineView.this.refreshView();
            }
        };
        this.toggleVerifierAction = new DefaultToggleAction("showAnalyzer"){

            @Override
            public void run(boolean newState) {
                BytecodeOutlineView.this.toggleVerifyMode(mmanager, newState);
                BytecodeOutlineView.this.inputChanged = true;
                BytecodeOutlineView.this.refreshView();
            }
        };
        mmanager.add((IAction)this.linkWithEditorAction);
        mmanager.add((IAction)this.showSelectedOnlyAction);
        mmanager.add((IAction)this.setRawModeAction);
        mmanager.add((IAction)this.hideLineInfoAction);
        mmanager.add((IAction)this.hideLocalsAction);
        mmanager.add((IAction)this.showHexValuesAction);
        mmanager.add((IAction)this.hideStackMapAction);
        mmanager.add((IAction)this.expandStackMapAction);
        mmanager.add((IAction)this.toggleASMifierModeAction);
        mmanager.add((IAction)this.toggleVerifierAction);
        mmanager.add((IContributionItem)new Separator());
        this.toggleOrientationActions = new ToggleOrientationAction[]{new ToggleOrientationAction(this, 0), new ToggleOrientationAction(this, 1), new ToggleOrientationAction(this, 2)};
        for (int i = 0; i < this.toggleOrientationActions.length; ++i) {
            mmanager.add((IAction)this.toggleOrientationActions[i]);
        }
        tmanager.add((IAction)this.linkWithEditorAction);
        tmanager.add((IAction)this.showSelectedOnlyAction);
        tmanager.add((IAction)this.setRawModeAction);
        tmanager.add((IAction)this.toggleASMifierModeAction);
        tmanager.add((IAction)this.toggleVerifierAction);
    }

    private void createVerifyControl() {
        this.verifyControl = new SashForm(this.stackComposite, 512);
        this.tableControl = new Table((Composite)this.verifyControl, 65540);
        this.tableControlViewer = new TableViewer(this.tableControl);
        TableColumn tc = new TableColumn(this.tableControl, 16384);
        tc.setText("#");
        tc.setToolTipText("ASM instruction offset");
        tc = new TableColumn(this.tableControl, 16384);
        tc.setText(BytecodeOutlinePlugin.getResourceString("BytecodeOutlineView.lvt.header"));
        tc.setToolTipText("Local variables");
        tc = new TableColumn(this.tableControl, 16384);
        tc.setText(BytecodeOutlinePlugin.getResourceString("BytecodeOutlineView.stack.header"));
        tc.setToolTipText("Stack content *before* current instruction is executed");
        new TableColumn(this.tableControl, 16384);
        new TableColumn(this.tableControl, 16384);
        this.tableControl.setLinesVisible(false);
        this.tableControl.setHeaderVisible(true);
        this.stackAndLvt = new SashForm((Composite)this.verifyControl, 256);
        this.lvtTable = new Table((Composite)this.stackAndLvt, 65540);
        this.lvtTable.setLinesVisible(false);
        this.lvtTable.setHeaderVisible(true);
        new TableColumn(this.lvtTable, 16384).setText("#");
        new TableColumn(this.lvtTable, 16384).setText("Var Type");
        new TableColumn(this.lvtTable, 16384).setText("Name");
        this.stackTable = new Table((Composite)this.stackAndLvt, 65540);
        this.stackTable.setLinesVisible(false);
        this.stackTable.setHeaderVisible(true);
        new TableColumn(this.stackTable, 16384).setText("#");
        new TableColumn(this.stackTable, 16384).setText("Stack Type");
        this.stackAndLvt.setWeights(new int[]{50, 50});
        this.verifyControl.setWeights(new int[]{75, 25});
        this.tableControl.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (BytecodeOutlineView.this.modes.get(0)) {
                    BytecodeOutlineView.this.selectionChangedAction.run();
                }
                BytecodeOutlineView.this.refreshVarsAndStackAction.run();
            }
        });
    }

    private void createSelectionProvider() {
        this.viewSelectionProvider = new BCOViewSelectionProvider();
        this.viewSelectionProvider.registerSelectionProvider((IPostSelectionProvider)this.textViewer);
        this.viewSelectionProvider.registerSelectionProvider((IPostSelectionProvider)this.tableControlViewer);
        if (this.modes.get(8)) {
            this.viewSelectionProvider.setCurrentSelectionProvider((IPostSelectionProvider)this.tableControlViewer);
        } else {
            this.viewSelectionProvider.setCurrentSelectionProvider((IPostSelectionProvider)this.textViewer);
        }
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewSelectionProvider);
    }

    private void createTextContextMenu() {
        String id = "de.loskutov.bco.views.BytecodeOutlineView#ContextMenu";
        this.contextMenuManager = new MenuManager("#ContextMenu", id);
        this.contextMenuManager.setRemoveAllWhenShown(true);
        this.contextMenuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager m) {
                BytecodeOutlineView.this.contextMenuAboutToShow(m);
            }
        });
        Menu menu = this.contextMenuManager.createContextMenu((Control)this.textControl);
        this.textControl.setMenu(menu);
        this.getSite().registerContextMenu(id, this.contextMenuManager, (ISelectionProvider)this.textViewer);
    }

    private void createTextControl() {
        IPreferenceStore store = JavaPlugin.getDefault().getCombinedPreferenceStore();
        JavaSourceViewer viewer = new JavaSourceViewer(this.stackComposite, null, null, true, 768, store);
        this.dummyEditorForHyperlinks = new BytecodeClassFileEditor(){

            public IWorkbenchPartSite getSite() {
                return BytecodeOutlineView.this.javaEditor == null ? null : BytecodeOutlineView.this.javaEditor.getEditorSite();
            }

            public IEditorInput getEditorInput() {
                return BytecodeOutlineView.this.javaEditor == null ? null : BytecodeOutlineView.this.javaEditor.getEditorInput();
            }

            public IAction getAction(String actionID) {
                return BytecodeOutlineView.this.javaEditor == null ? null : BytecodeOutlineView.this.javaEditor.getAction(actionID);
            }
        };
        JavaConfiguration configuration = new JavaConfiguration(JavaPlugin.getDefault().getJavaTextTools().getColorManager(), store, (ITextEditor)this.dummyEditorForHyperlinks, "___java_partitioning");
        viewer.configure((SourceViewerConfiguration)configuration);
        viewer.setEditable(false);
        this.textViewer = viewer;
        this.textControl = this.textViewer.getTextWidget();
        Document document = new Document("");
        this.textViewer.setDocument((IDocument)document);
        this.textSelectionListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Iterator<String> iterator = BytecodeOutlineView.this.selectionActions.iterator();
                while (iterator.hasNext()) {
                    BytecodeOutlineView.this.updateAction(iterator.next());
                }
            }
        };
        this.textListener = new ITextListener(){

            public void textChanged(TextEvent event) {
                IUpdate findReplace = (IUpdate)BytecodeOutlineView.this.globalActions.get(ActionFactory.FIND.getId());
                if (findReplace != null) {
                    findReplace.update();
                }
            }
        };
        this.textViewer.getSelectionProvider().addSelectionChangedListener(this.textSelectionListener);
        this.textViewer.addTextListener(this.textListener);
        this.textControl.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (BytecodeOutlineView.this.modes.get(0)) {
                    BytecodeOutlineView.this.selectionChangedAction.run();
                }
            }

            public void mouseUp(MouseEvent e) {
                if (BytecodeOutlineView.this.modes.get(0)) {
                    BytecodeOutlineView.this.selectionChangedAction.run();
                }
            }
        });
        this.textControl.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                if (BytecodeOutlineView.this.modes.get(0)) {
                    BytecodeOutlineView.this.selectionChangedAction.run();
                }
            }
        });
    }

    public void dispose() {
        this.deActivateView();
        if (this.editorListener != null) {
            this.getSite().getWorkbenchWindow().getPartService().removePartListener((IPartListener2)this.editorListener);
            this.getSite().getWorkbenchWindow().getSelectionService().removePostSelectionListener((ISelectionListener)this.editorListener);
            FileBuffers.getTextFileBufferManager().removeFileBufferListener((IFileBufferListener)this.editorListener);
            this.editorListener.dispose();
            this.editorListener = null;
        }
        if (this.contextMenuManager != null) {
            this.contextMenuManager.dispose();
        }
        this.selectionActions.clear();
        this.globalActions.clear();
        this.textViewer.getSelectionProvider().removeSelectionChangedListener(this.textSelectionListener);
        this.textViewer.removeTextListener(this.textListener);
        this.textViewer = null;
        this.viewSelectionProvider = null;
        if (this.textControl != null) {
            this.textControl.dispose();
            this.textControl = null;
        }
        if (this.verifyControl != null) {
            this.verifyControl.dispose();
            this.verifyControl = null;
            this.tableControl = null;
            this.stackTable = null;
            this.lvtTable = null;
            this.tableControlViewer = null;
        }
        this.currentSelection = null;
        this.javaEditor = null;
        this.setJavaInput(null);
        this.lastChildElement = null;
        this.lastDecompiledResult = null;
        this.linkWithEditorAction.dispose();
        this.showSelectedOnlyAction.dispose();
        this.setRawModeAction.dispose();
        this.toggleASMifierModeAction.dispose();
        this.hideLineInfoAction.dispose();
        this.hideLocalsAction.dispose();
        this.hideStackMapAction.dispose();
        this.showHexValuesAction.dispose();
        this.expandStackMapAction.dispose();
        this.toggleVerifierAction.dispose();
        this.linkWithEditorAction = null;
        this.selectionChangedAction = null;
        this.refreshVarsAndStackAction = null;
        this.showSelectedOnlyAction = null;
        this.setRawModeAction = null;
        this.toggleASMifierModeAction = null;
        this.hideLineInfoAction = null;
        this.hideLocalsAction = null;
        this.hideStackMapAction = null;
        this.showHexValuesAction = null;
        this.expandStackMapAction = null;
        this.toggleVerifierAction = null;
        super.dispose();
    }

    protected void contextMenuAboutToShow(IMenuManager menuManager) {
        IDocument doc = this.textViewer.getDocument();
        if (doc == null) {
            return;
        }
        menuManager.add(this.globalActions.get(ActionFactory.COPY.getId()));
        menuManager.add(this.globalActions.get(ActionFactory.SELECT_ALL.getId()));
        menuManager.add((IContributionItem)new Separator("FIND"));
        menuManager.add(this.globalActions.get(ActionFactory.FIND.getId()));
        menuManager.add((IContributionItem)new Separator("additions"));
    }

    public void setFocus() {
        if (!this.modes.get(8)) {
            if (this.textViewer != null) {
                this.textViewer.getTextWidget().setFocus();
            }
        } else if (this.tableControl != null) {
            this.tableControl.setFocus();
        }
    }

    protected void handleBufferIsDirty(boolean isDirty) {
        if (!this.modes.get(0) || !this.isActive()) {
            return;
        }
        if (isDirty) {
            this.setBufferIsDirty(isDirty);
        } else if (!this.bufferIsDirty) {
            this.inputChanged = true;
            this.refreshView();
        } else {
            this.setBufferIsDirty(false);
        }
    }

    protected void handlePartHidden(IWorkbenchPart part) {
        if (!this.modes.get(0)) {
            return;
        }
        if (this == part) {
            this.isVisible = false;
            this.deActivateView();
        } else if (this.isActive() && part instanceof IEditorPart) {
            this.checkOpenEditors(false);
        }
    }

    protected void handlePartVisible(IWorkbenchPart part) {
        if (!this.modes.get(0)) {
            if (this == part) {
                this.isVisible = true;
            }
            return;
        }
        if (this == part) {
            if (this.isVisible) {
                return;
            }
            this.isVisible = true;
            IEditorPart activeEditor = EclipseUtils.getActiveEditor();
            if (!(activeEditor instanceof ITextEditor)) {
                this.activateView();
                return;
            }
            part = activeEditor;
        }
        if (this.isVisible && part instanceof ITextEditor) {
            if (this.isActive() && part == this.javaEditor) {
                return;
            }
            this.activateView();
            this.setEnabled(true);
            this.setInput((ITextEditor)part);
            this.refreshView();
        } else if (part instanceof IEditorPart && this.isActive()) {
            this.deActivateView();
        }
    }

    protected void handleSelectionChanged(IWorkbenchPart part, ISelection selection) {
        if (!(this.modes.get(0) && this.isActive() && this.isVisible && part instanceof IEditorPart)) {
            return;
        }
        if (!(part instanceof ITextEditor)) {
            this.deActivateView();
            return;
        }
        if (!this.isEnabled()) {
            this.setEnabled(true);
        }
        if (part != this.javaEditor) {
            this.setInput((ITextEditor)part);
        } else if (!this.updateSelection((ITextSelection)selection)) {
            return;
        }
        this.refreshView();
    }

    private void activateView() {
        if (this.isActive()) {
            return;
        }
        this.isActive = true;
        this.getSite().getWorkbenchWindow().getSelectionService().addPostSelectionListener((ISelectionListener)this.editorListener);
        FileBuffers.getTextFileBufferManager().addFileBufferListener((IFileBufferListener)this.editorListener);
    }

    private void deActivateView() {
        if (!this.isActive()) {
            return;
        }
        this.setEnabled(false);
        if (this.editorListener != null) {
            ISelectionService service = this.getSite().getWorkbenchWindow().getSelectionService();
            if (service != null) {
                service.removePostSelectionListener((ISelectionListener)this.editorListener);
            }
            FileBuffers.getTextFileBufferManager().removeFileBufferListener((IFileBufferListener)this.editorListener);
        }
        if (this.textViewer != null && this.textViewer.getTextWidget() != null && !this.textViewer.getTextWidget().isDisposed()) {
            Document document = new Document("");
            this.textViewer.setDocument((IDocument)document);
        }
        if (this.tableControl != null && !this.tableControl.isDisposed()) {
            this.setVerifyTableItems(null);
        }
        if (this.stackTable != null && !this.stackTable.isDisposed()) {
            this.stackTable.removeAll();
        }
        if (this.lvtTable != null && !this.lvtTable.isDisposed()) {
            this.lvtTable.removeAll();
        }
        if (this.statusControl != null && !this.statusControl.isDisposed()) {
            this.updateStatus(null, -1, -1);
        }
        this.currentSelection = null;
        this.lastDecompiledResult = null;
        this.javaEditor = null;
        this.setJavaInput(null);
        this.lastChildElement = null;
        this.setBufferIsDirty(false);
        this.isActive = false;
    }

    protected void refreshView() {
        if (!this.isActive()) {
            return;
        }
        IJavaElement childEl = this.getCurrentJavaElement();
        if (childEl == null && this.javaInput == null) {
            this.setInput(this.javaEditor);
            childEl = this.javaInput;
        }
        if (this.javaInput == null) {
            this.deActivateView();
            return;
        }
        boolean clearOutput = false;
        if (this.inputChanged || this.isSelectedElementChanged(childEl)) {
            DecompiledClass result = this.decompileBytecode(childEl);
            if (result == null) {
                clearOutput = true;
            } else {
                boolean hasMethods;
                boolean bl = hasMethods = !result.isAbstractOrInterface() || result.isDefaultMethodPossible();
                if (this.modes.get(8) && hasMethods) {
                    this.refreshVerifyView(result);
                } else {
                    this.toggleVerifierAction.setEnabled(hasMethods);
                    this.refreshTextView(result);
                }
            }
            this.lastDecompiledResult = result;
        } else if (childEl == null && this.modes.get(1)) {
            clearOutput = true;
        }
        this.lastChildElement = childEl;
        if (clearOutput) {
            if (!this.modes.get(8)) {
                Document document = new Document("");
                this.textViewer.setDocument((IDocument)document);
            } else {
                this.setVerifyTableItems(null);
            }
        }
        this.setSelectionInBytecodeView();
        this.inputChanged = false;
    }

    private void refreshTextView(DecompiledClass result) {
        Document document = new Document(result.getText());
        JavaTextTools tools = JavaPlugin.getDefault().getJavaTextTools();
        tools.setupJavaDocumentPartitioner((IDocument)document, "___java_partitioning");
        this.textViewer.setDocument((IDocument)document);
        if (this.modes.get(8)) {
            this.setVerifyTableItems(null);
        }
        this.hasAnalyzerError = false;
    }

    private void refreshVerifyView(DecompiledClass result) {
        this.setVerifyTableItems(result.getTextTable());
        List<Integer> errors = result.getErrorLines();
        if (errors.size() > 0) {
            this.hasAnalyzerError = true;
        }
        for (int i = 0; i < errors.size(); ++i) {
            int l = errors.get(i);
            this.tableControl.getItem(l).setForeground(this.errorColor);
        }
        this.toggleVerifierAction.setEnabled(true);
    }

    private void updateStatus(DecompiledClass result, int bytecodeOffsetStart, int bytecodeOffsetEnd) {
        this.statusLineManager.setErrorMessage(null);
        if (result != null) {
            this.currentStatusMessage = "Java:" + result.getJavaVersion() + " | class size:" + result.getClassSize();
            ClassNode classNode = result.getClassNode();
            if (classNode != null && classNode.name != null) {
                this.setContentDescription(classNode.name);
            }
        } else {
            this.currentStatusMessage = "";
            this.setContentDescription("");
        }
        String selectionInfo = "";
        if (bytecodeOffsetStart >= 0) {
            selectionInfo = " | offset:" + bytecodeOffsetStart;
            if (bytecodeOffsetEnd >= 0) {
                selectionInfo = selectionInfo + "-" + bytecodeOffsetEnd;
            }
        }
        if (this.hasAnalyzerError) {
            this.statusLineManager.setErrorMessage(this.currentStatusMessage + selectionInfo);
        } else {
            this.statusLineManager.setMessage(this.currentStatusMessage + selectionInfo);
        }
    }

    public int getBytecodeInstructionAtLine(int line) {
        if (this.lastDecompiledResult != null) {
            return this.lastDecompiledResult.getBytecodeInsn(line);
        }
        return -1;
    }

    private IJavaElement getCurrentJavaElement() {
        IJavaElement childEl = null;
        try {
            childEl = JdtUtils.getElementAtOffset(this.javaInput, this.currentSelection);
            if (childEl != null) {
                switch (childEl.getElementType()) {
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: {
                        break;
                    }
                    case 14: {
                        childEl = childEl.getAncestor(9);
                        break;
                    }
                    default: {
                        childEl = null;
                    }
                }
            }
        }
        catch (JavaModelException e) {
            BytecodeOutlinePlugin.log(e, 1);
            this.setJavaInput(null);
            this.lastChildElement = null;
        }
        return childEl;
    }

    private void setSelectionInBytecodeView() {
        if (this.lastDecompiledResult == null) {
            return;
        }
        if (this.currentSelection.getStartLine() != this.currentSelection.getEndLine()) {
            this.setMultiLineSelectionInBytecodeView(this.currentSelection);
            return;
        }
        int sourceLine = this.currentSelection.getStartLine() + 1;
        int decompiledLine = this.lastDecompiledResult.getDecompiledLine(sourceLine);
        if (decompiledLine < 0 && !this.modes.get(1) && this.lastChildElement != null) {
            String methodName;
            DecompiledMethod match = this.lastDecompiledResult.getBestDecompiledMatch(sourceLine);
            if (match != null && (decompiledLine = match.getBestDecompiledLine(sourceLine)) > 0) {
                decompiledLine = this.lastDecompiledResult.getDecompiledLine(match, decompiledLine);
            }
            if (decompiledLine < 0 && (methodName = JdtUtils.getMethodSignature(this.lastChildElement)) != null) {
                decompiledLine = this.lastDecompiledResult.getDecompiledLine(methodName) - 1;
            }
        }
        if (decompiledLine > 0) {
            try {
                if (this.modes.get(8)) {
                    this.updateVerifierControl4line(decompiledLine);
                    this.tableControl.setSelection(decompiledLine);
                } else {
                    int lineCount = this.textControl.getLineCount();
                    if (decompiledLine < lineCount) {
                        int offsetAtLine = this.textControl.getOffsetAtLine(decompiledLine);
                        int offsetEnd = this.textControl.getText().indexOf(10, offsetAtLine);
                        this.textControl.setSelection(offsetAtLine, offsetEnd);
                    }
                }
            }
            catch (IllegalArgumentException e) {
                BytecodeOutlinePlugin.error(null, e);
            }
        } else if (this.modes.get(8)) {
            this.lvtTable.removeAll();
            this.stackTable.removeAll();
        }
        int bytecodeOffset = this.lastDecompiledResult.getBytecodeOffset(decompiledLine);
        this.updateStatus(this.lastDecompiledResult, bytecodeOffset, -1);
    }

    private void setMultiLineSelectionInBytecodeView(ITextSelection multiLineSelection) {
        LineRange range = this.lastDecompiledResult.getDecompiledRange(multiLineSelection);
        int firstDecompiledLine = range.startLine;
        if (firstDecompiledLine > 0) {
            try {
                if (this.modes.get(8)) {
                    this.updateVerifierControl4line(firstDecompiledLine);
                    this.tableControl.setSelection(firstDecompiledLine);
                } else {
                    int lineCount = this.textControl.getLineCount();
                    if (firstDecompiledLine < lineCount) {
                        int offsetEnd;
                        int offsetAtLine = this.textControl.getOffsetAtLine(firstDecompiledLine);
                        String text = this.textControl.getText();
                        if (range.endLine > 0 && range.endLine < lineCount) {
                            offsetEnd = this.textControl.getOffsetAtLine(range.endLine);
                            if ((offsetEnd = text.indexOf("LINENUMBER", text.indexOf(10, offsetEnd))) < 0) {
                                offsetEnd = text.indexOf(10, offsetEnd);
                            }
                        } else {
                            offsetEnd = text.indexOf(10, offsetAtLine);
                        }
                        this.textControl.setSelection(offsetAtLine, offsetEnd);
                    }
                }
            }
            catch (IllegalArgumentException e) {
                BytecodeOutlinePlugin.error(null, e);
            }
        } else if (this.modes.get(8)) {
            this.lvtTable.removeAll();
            this.stackTable.removeAll();
        }
        int bytecodeOffsetStart = this.lastDecompiledResult.getBytecodeOffset(firstDecompiledLine);
        int bytecodeOffsetEnd = this.lastDecompiledResult.getBytecodeOffset(range.endLine);
        this.updateStatus(this.lastDecompiledResult, bytecodeOffsetStart, bytecodeOffsetEnd);
    }

    protected void updateVerifierControl4line(int decompiledLine) {
        String[][][] frame = this.lastDecompiledResult.getFrameTables(decompiledLine, !this.modes.get(3));
        this.updateVerifierControl(frame);
    }

    protected void updateVerifierControl4insn(int insn) {
        String[][][] frame = this.lastDecompiledResult.getFrameTablesForInsn(insn, !this.modes.get(3));
        this.updateVerifierControl(frame);
    }

    private void updateVerifierControl(String[][][] frame) {
        int i;
        this.lvtTable.removeAll();
        this.stackTable.removeAll();
        if (frame == null) {
            return;
        }
        for (i = 0; i < frame[0].length; ++i) {
            if (frame[0][i] == null) continue;
            new TableItem(this.lvtTable, 0).setText(frame[0][i]);
        }
        for (i = 0; i < frame[1].length; ++i) {
            if (frame[1][i] == null) continue;
            new TableItem(this.stackTable, 0).setText(frame[1][i]);
        }
        this.lvtTable.getColumn(0).pack();
        this.lvtTable.getColumn(1).pack();
        this.lvtTable.getColumn(2).pack();
        this.stackTable.getColumn(0).pack();
        this.stackTable.getColumn(1).pack();
    }

    protected void setSelectionInJavaEditor(Point selection) {
        int startDecLine;
        if (this.javaEditor != null && this.javaEditor.getEditorInput() == null) {
            this.javaEditor = null;
            this.setJavaInput(null);
        }
        if (this.javaEditor == null || this.lastDecompiledResult == null) {
            this.deActivateView();
            return;
        }
        int endDecLine = -1;
        if (this.modes.get(8)) {
            endDecLine = startDecLine = this.tableControl.getSelectionIndex();
        } else {
            startDecLine = this.textControl.getLineAtOffset(selection.x);
            endDecLine = this.textControl.getLineAtOffset(selection.y);
        }
        int startSourceLine = this.lastDecompiledResult.getSourceLine(startDecLine);
        int endSourceLine = -1;
        if (endDecLine > 0) {
            endSourceLine = this.lastDecompiledResult.getSourceLine(endDecLine);
        }
        if (endSourceLine < startSourceLine) {
            int tmp = startSourceLine;
            startSourceLine = endSourceLine;
            endSourceLine = tmp;
        }
        try {
            if (startSourceLine > 0) {
                IDocument document = this.javaEditor.getDocumentProvider().getDocument((Object)this.javaEditor.getEditorInput());
                try {
                    IRegion lineInfo = document.getLineInformation(startSourceLine - 1);
                    int startOffset = lineInfo.getOffset();
                    int length = lineInfo.getLength();
                    if (endSourceLine > 0) {
                        IRegion region = document.getLineInformation(endSourceLine - 1);
                        length = region.getLength() + (region.getOffset() - startOffset);
                    }
                    EclipseUtils.selectInEditor(this.javaEditor, startOffset, length);
                }
                catch (BadLocationException e) {}
            }
        }
        catch (Exception e) {
            BytecodeOutlinePlugin.log(e, 4);
        }
        int bytecodeOffset = this.lastDecompiledResult.getBytecodeOffset(startDecLine);
        this.updateStatus(this.lastDecompiledResult, bytecodeOffset, -1);
    }

    protected void checkOpenEditors(boolean checkNewSelection) {
        IEditorReference[] editorReferences = this.getSite().getPage().getEditorReferences();
        if (editorReferences == null || editorReferences.length == 0) {
            this.deActivateView();
        } else if (checkNewSelection) {
            IEditorPart activeEditor = EclipseUtils.getActiveEditor();
            if (activeEditor instanceof ITextEditor) {
                ITextSelection selection = EclipseUtils.getSelection(((ITextEditor)activeEditor).getSelectionProvider());
                this.handleSelectionChanged((IWorkbenchPart)activeEditor, (ISelection)selection);
            } else {
                this.deActivateView();
            }
        }
    }

    private boolean isSelectedElementChanged(IJavaElement childEl) {
        if (this.lastChildElement == null && childEl == null) {
            return false;
        }
        if (this.modes.get(1) && (this.lastChildElement == null || this.lastChildElement != null && !this.lastChildElement.equals(childEl))) {
            return true;
        }
        if (this.lastChildElement != null && childEl != null) {
            IType newEnclosingType = JdtUtils.getEnclosingType(childEl);
            IType oldEnclosingType = JdtUtils.getEnclosingType(this.lastChildElement);
            return newEnclosingType == null || !newEnclosingType.equals(oldEnclosingType);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DecompiledClass decompileBytecode(IJavaElement childEl) {
        int available;
        DecompiledClass decompiledClass;
        block26: {
            IType type = JdtUtils.getEnclosingType(childEl);
            if (type == null) {
                type = this.javaInput;
            }
            if (type == null) {
                return null;
            }
            InputStream is = JdtUtils.createInputStream((IJavaElement)type);
            if (is == null) {
                return null;
            }
            decompiledClass = null;
            available = 0;
            try {
                ClassLoader cl = null;
                if (this.modes.get(8)) {
                    cl = JdtUtils.getClassLoader((IJavaElement)type);
                }
                String fieldName = null;
                String methodName = null;
                if (this.modes.get(1) && childEl != null) {
                    if (childEl.getElementType() == 8) {
                        fieldName = childEl.getElementName();
                    } else {
                        methodName = JdtUtils.getMethodSignature(childEl);
                    }
                }
                available = is.available();
                decompiledClass = DecompilerHelper.getDecompiledClass(is, new DecompilerOptions(fieldName, methodName, this.modes, cl));
            }
            catch (Exception e) {
                try {
                    if (type.isStructureKnown()) {
                        BytecodeOutlinePlugin.error("Cannot decompile: " + type, e);
                        break block26;
                    }
                    BytecodeOutlinePlugin.log(e, 4);
                }
                catch (JavaModelException e1) {
                    BytecodeOutlinePlugin.log(e1, 2);
                }
            }
            catch (UnsupportedClassVersionError e) {
                BytecodeOutlinePlugin.error("Cannot decompile: " + type + ". Error was caused by attempt to " + "load a class compiled with the Java version which is not " + "supported by the current JVM. ", e);
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException e) {
                    BytecodeOutlinePlugin.log(e, 2);
                }
            }
        }
        if (decompiledClass != null) {
            decompiledClass.setClassSize(available);
        }
        return decompiledClass;
    }

    private void setVerifyTableItems(String[][] items) {
        this.tableControl.removeAll();
        if (items != null) {
            for (int i = 0; i < items.length; ++i) {
                TableItem item = new TableItem(this.tableControl, 0);
                for (int j = 0; j < items[i].length; ++j) {
                    String s = items[i][j];
                    if (s.endsWith("\n")) {
                        s = s.substring(0, s.length() - 1);
                        item.setData((Object)i);
                    }
                    item.setText(j, s);
                }
            }
            this.tableControl.getColumn(0).pack();
            this.tableControl.getColumn(1).pack();
            this.tableControl.getColumn(2).pack();
            this.tableControl.getColumn(3).pack();
            this.tableControl.getColumn(4).pack();
        }
    }

    public Object getAdapter(Class adapter) {
        if (IFindReplaceTarget.class.equals((Object)adapter)) {
            return this.textViewer.getFindReplaceTarget();
        }
        if (Widget.class.equals((Object)adapter)) {
            return this.textViewer.getTextWidget();
        }
        if (TextViewer.class.equals((Object)adapter)) {
            return this.textViewer;
        }
        return super.getAdapter(adapter);
    }

    protected void setGlobalAction(IActionBars actionBars, String actionID, IAction action) {
        this.globalActions.put(actionID, action);
        actionBars.setGlobalActionHandler(actionID, action);
    }

    protected void updateAction(String actionId) {
        IAction action = this.globalActions.get(actionId);
        if (action instanceof IUpdate) {
            ((IUpdate)action).update();
        }
    }

    protected void createTextActions() {
        IActionBars actionBars = this.getViewSite().getActionBars();
        TextViewerAction action = new TextViewerAction((ITextViewer)this.textViewer, 7);
        action.configureAction(BytecodeOutlinePlugin.getResourceString("BytecodeOutlineView.select_all.label"), BytecodeOutlinePlugin.getResourceString("BytecodeOutlineView.select_all.tooltip"), BytecodeOutlinePlugin.getResourceString("BytecodeOutlineView.select_all.description"));
        this.setGlobalAction(actionBars, ActionFactory.SELECT_ALL.getId(), (IAction)action);
        action = new TextViewerAction((ITextViewer)this.textViewer, 4);
        action.configureAction(BytecodeOutlinePlugin.getResourceString("BytecodeOutlineView.copy.label"), BytecodeOutlinePlugin.getResourceString("BytecodeOutlineView.copy.tooltip"), BytecodeOutlinePlugin.getResourceString("BytecodeOutlineView.copy.description"));
        action.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_COPY"));
        action.setActionDefinitionId("org.eclipse.ui.edit.copy");
        this.setGlobalAction(actionBars, ActionFactory.COPY.getId(), (IAction)action);
        ResourceBundle bundle = BytecodeOutlinePlugin.getDefault().getResourceBundle();
        this.setGlobalAction(actionBars, ActionFactory.FIND.getId(), (IAction)new FindReplaceAction(bundle, "BytecodeOutlineView.find_replace.", (IWorkbenchPart)this));
        this.selectionActions.add(ActionFactory.COPY.getId());
        this.selectionActions.add(ActionFactory.FIND.getId());
        actionBars.updateActionBars();
    }

    private void setOrientation(int orientation) {
        if (this.verifyControl == null || this.verifyControl.isDisposed()) {
            return;
        }
        boolean horizontal = orientation == 1;
        this.verifyControl.setOrientation(horizontal ? 256 : 512);
        for (int i = 0; i < this.toggleOrientationActions.length; ++i) {
            this.toggleOrientationActions[i].setChecked(orientation == this.toggleOrientationActions[i].getOrientation());
        }
        this.currentOrientation = orientation;
        this.stackComposite.getParent().layout();
    }

    protected void computeOrientation() {
        if (this.orientation != 2) {
            this.currentOrientation = this.orientation;
            this.setOrientation(this.currentOrientation);
        } else {
            Point size = this.stackComposite.getParent().getSize();
            if (size.x != 0 && size.y != 0) {
                this.setOrientation(size.x > size.y ? 1 : 0);
            }
        }
    }

    protected void setMode(int bitIndex, boolean value) {
        this.modes.set(bitIndex, value);
    }

    protected void toggleVerifyMode(IMenuManager mmanager, boolean showAnalyzer) {
        this.setMode(8, showAnalyzer);
        if (this.modes.get(8)) {
            ((StackLayout)this.stackComposite.getLayout()).topControl = this.verifyControl;
            this.viewSelectionProvider.setCurrentSelectionProvider((IPostSelectionProvider)this.tableControlViewer);
        } else {
            ((StackLayout)this.stackComposite.getLayout()).topControl = this.textControl;
            this.viewSelectionProvider.setCurrentSelectionProvider((IPostSelectionProvider)this.textViewer);
        }
        this.stackComposite.layout();
        for (int i = 0; i < this.toggleOrientationActions.length; ++i) {
            this.toggleOrientationActions[i].setEnabled(showAnalyzer);
        }
        mmanager.markDirty();
        mmanager.update();
    }

    protected IJavaElement[] guessTypesFromSelectionInView(IRegion wordRegion) throws JavaModelException {
        String typeName;
        if (wordRegion == null || wordRegion.getLength() == 0 || this.javaInput == null) {
            return null;
        }
        try {
            typeName = this.textViewer.getDocument().get(wordRegion.getOffset(), wordRegion.getLength());
        }
        catch (BadLocationException e) {
            return null;
        }
        if (typeName.isEmpty()) {
            return null;
        }
        if (typeName.contains("$")) {
            typeName = typeName.substring(typeName.lastIndexOf(36) + 1);
        }
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{this.javaInput.getJavaProject()});
        return JdtUtils.getTypeForName(typeName, scope, null);
    }

    private final class JavadocHoverExtension
    extends JavadocHover {
        private final Set<String> OPCODES = new HashSet<String>(Arrays.asList(Printer.OPCODES));

        private JavadocHoverExtension() {
        }

        protected IJavaElement[] getJavaElementsAt(ITextViewer textViewer1, IRegion hoverRegion) {
            try {
                return BytecodeOutlineView.this.guessTypesFromSelectionInView(hoverRegion);
            }
            catch (JavaModelException e) {
                return null;
            }
        }

        public Object getHoverInfo2(ITextViewer viewer, IRegion region) {
            int line;
            String typeName;
            IDocument document = viewer.getDocument();
            try {
                typeName = document.get(region.getOffset(), region.getLength());
            }
            catch (BadLocationException e) {
                return null;
            }
            if (!this.OPCODES.contains(typeName)) {
                return super.getHoverInfo2(viewer, region);
            }
            try {
                line = document.getLineOfOffset(region.getOffset());
            }
            catch (BadLocationException e) {
                return null;
            }
            StringBuilder sb = HelpUtils.getOpcodeHelpFor(BytecodeOutlineView.this.getBytecodeInstructionAtLine(line));
            if (sb.length() > 0) {
                JavadocBrowserInformationControlInput input = new JavadocBrowserInformationControlInput(null, null, sb.toString(), 0);
                return input;
            }
            return null;
        }
    }

    private final class JavaConfiguration
    extends JavaSourceViewerConfiguration {
        private JavaConfiguration(IColorManager colorManager, IPreferenceStore preferenceStore, ITextEditor editor, String partitioning) {
            super(colorManager, preferenceStore, editor, partitioning);
        }

        public IHyperlinkDetector[] getHyperlinkDetectors(ISourceViewer sourceViewer) {
            JavaElementHyperlinkDetectorInView det = new JavaElementHyperlinkDetectorInView();
            return new IHyperlinkDetector[]{det};
        }

        public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType, int stateMask) {
            JavadocHoverExtension javadocHover = new JavadocHoverExtension();
            return javadocHover;
        }

        public IQuickAssistAssistant getQuickAssistAssistant(ISourceViewer sourceViewer) {
            return null;
        }
    }

    private class JavaElementHyperlinkDetectorInView
    extends JavaElementHyperlinkDetector {
        private JavaElementHyperlinkDetectorInView() {
        }

        public IHyperlink[] detectHyperlinks(ITextViewer textViewer1, IRegion region, boolean canShowMultipleHyperlinks) {
            IJavaElement[] elements;
            if (region == null || BytecodeOutlineView.this.dummyEditorForHyperlinks == null || BytecodeOutlineView.this.javaInput == null) {
                return null;
            }
            IAction openAction = BytecodeOutlineView.this.dummyEditorForHyperlinks.getAction("OpenEditor");
            if (!(openAction instanceof SelectionDispatchAction)) {
                return null;
            }
            int offset = region.getOffset();
            IDocument document = textViewer1.getDocument();
            IRegion wordRegion = JavaWordFinder.findWord((IDocument)document, (int)offset);
            ArrayList<IHyperlink> links = new ArrayList<IHyperlink>();
            try {
                elements = BytecodeOutlineView.this.guessTypesFromSelectionInView(wordRegion);
            }
            catch (JavaModelException e) {
                return null;
            }
            if (elements == null) {
                return null;
            }
            if ((elements = JdtUtils.selectOpenableElements(elements)).length == 0) {
                return null;
            }
            for (int i = 0; i < elements.length; ++i) {
                if (elements[i] == null) continue;
                this.addHyperlinks2(links, wordRegion, (SelectionDispatchAction)openAction, elements[i], elements.length > 1, (JavaEditor)BytecodeOutlineView.this.dummyEditorForHyperlinks);
            }
            if (links.size() == 0) {
                return null;
            }
            return links.toArray(new IHyperlink[links.size()]);
        }

        protected void addHyperlinks2(List<IHyperlink> hyperlinksCollector, IRegion wordRegion, SelectionDispatchAction openAction, IJavaElement element, boolean qualify, JavaEditor editor) {
            hyperlinksCollector.add((IHyperlink)new JavaElementHyperlink(wordRegion, openAction, element, qualify));
        }
    }

    private class ToggleOrientationAction
    extends Action {
        private final int actionOrientation;

        public ToggleOrientationAction(BytecodeOutlineView v, int orientation) {
            super("", 8);
            String symbolicName = BytecodeOutlinePlugin.getDefault().getBundle().getSymbolicName();
            if (orientation == 1) {
                this.setText(BytecodeOutlinePlugin.getResourceString("BytecodeOutlineView.toggle.horizontal.label"));
                this.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)symbolicName, (String)"icons/th_horizontal.gif"));
            } else if (orientation == 0) {
                this.setText(BytecodeOutlinePlugin.getResourceString("BytecodeOutlineView.toggle.vertical.label"));
                this.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)symbolicName, (String)"icons/th_vertical.gif"));
            } else if (orientation == 2) {
                this.setText(BytecodeOutlinePlugin.getResourceString("BytecodeOutlineView.toggle.automatic.label"));
                this.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)symbolicName, (String)"icons/th_automatic.gif"));
            }
            this.actionOrientation = orientation;
        }

        public int getOrientation() {
            return this.actionOrientation;
        }

        public void run() {
            if (this.isChecked()) {
                BytecodeOutlineView.this.orientation = this.actionOrientation;
                BytecodeOutlineView.this.computeOrientation();
            }
        }
    }
}

