/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.site;

import java.util.Locale;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.internal.core.isite.ISiteFeature;
import org.eclipse.pde.internal.core.isite.ISiteModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.FormEntryAdapter;
import org.eclipse.pde.internal.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.PDESection;
import org.eclipse.pde.internal.ui.editor.feature.Choice;
import org.eclipse.pde.internal.ui.editor.feature.PortabilityChoicesDialog;
import org.eclipse.pde.internal.ui.editor.site.SiteFeatureAdapter;
import org.eclipse.pde.internal.ui.parts.FormEntry;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.RTFTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.IPartSelectionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class PortabilitySection
extends PDESection
implements IPartSelectionListener {
    private FormEntry fArchText;
    private ISiteFeature fCurrentSiteFeature;
    private FormEntry fNlText;
    private FormEntry fOsText;
    private FormEntry fWsText;

    public static Choice[] getArchChoices() {
        return PortabilitySection.getKnownChoices(Platform.knownOSArchValues());
    }

    private static Choice[] getKnownChoices(String[] values) {
        Choice[] choices = new Choice[values.length];
        int i = 0;
        while (i < choices.length) {
            choices[i] = new Choice(values[i], values[i]);
            ++i;
        }
        return choices;
    }

    public static Choice[] getNLChoices() {
        Locale[] locales = Locale.getAvailableLocales();
        Choice[] choices = new Choice[locales.length];
        int i = 0;
        while (i < locales.length) {
            Locale locale = locales[i];
            choices[i] = new Choice(locale.toString(), String.valueOf(locale.toString()) + " - " + locale.getDisplayName());
            ++i;
        }
        return choices;
    }

    public static Choice[] getOSChoices() {
        return PortabilitySection.getKnownChoices(Platform.knownOSValues());
    }

    public static Choice[] getWSChoices() {
        return PortabilitySection.getKnownChoices(Platform.knownWSValues());
    }

    public PortabilitySection(PDEFormPage page, Composite parent) {
        this(page, parent, PDEUIMessages.SiteEditor_PortabilitySection_title, PDEUIMessages.SiteEditor_PortabilitySection_desc, 0);
    }

    public PortabilitySection(PDEFormPage page, Composite parent, String title, String desc, int toggleStyle) {
        super(page, parent, 0x80 | toggleStyle);
        this.getSection().setText(title);
        this.getSection().setDescription(desc);
        this.createClient(this.getSection(), page.getManagedForm().getToolkit());
    }

    private void applyValue(String property, String value) throws CoreException {
        if (this.fCurrentSiteFeature == null) {
            return;
        }
        if (property.equals("nl")) {
            this.fCurrentSiteFeature.setNL(value);
        } else if (property.equals("os")) {
            this.fCurrentSiteFeature.setOS(value);
        } else if (property.equals("ws")) {
            this.fCurrentSiteFeature.setWS(value);
        } else if (property.equals("arch")) {
            this.fCurrentSiteFeature.setArch(value);
        }
    }

    @Override
    public void cancelEdit() {
        this.fOsText.cancelEdit();
        this.fWsText.cancelEdit();
        this.fNlText.cancelEdit();
        this.fArchText.cancelEdit();
        super.cancelEdit();
    }

    @Override
    public boolean canPaste(Clipboard clipboard) {
        TransferData[] types = clipboard.getAvailableTypes();
        Transfer[] transfers = new Transfer[]{TextTransfer.getInstance(), RTFTransfer.getInstance()};
        int i = 0;
        while (i < types.length) {
            int j = 0;
            while (j < transfers.length) {
                if (transfers[j].isSupportedType(types[i])) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    private void clearField(String property) {
        if (property.equals("os")) {
            this.fOsText.setValue(null, true);
        } else if (property.equals("ws")) {
            this.fWsText.setValue(null, true);
        } else if (property.equals("arch")) {
            this.fArchText.setValue(null, true);
        }
    }

    private void clearFields() {
        this.fOsText.setValue(null, true);
        this.fWsText.setValue(null, true);
        if (this.fNlText != null) {
            this.fNlText.setValue(null, true);
        }
        this.fArchText.setValue(null, true);
    }

    public void commit(boolean onSave) {
        this.fOsText.commit();
        this.fWsText.commit();
        if (this.fNlText != null) {
            this.fNlText.commit();
        }
        this.fArchText.commit();
        super.commit(onSave);
    }

    @Override
    public void createClient(Section section, FormToolkit toolkit) {
        section.setLayout((Layout)FormLayoutFactory.createClearGridLayout(false, 1));
        Composite container = toolkit.createComposite((Composite)section);
        container.setLayout((Layout)FormLayoutFactory.createSectionClientGridLayout(false, 3));
        container.setLayoutData((Object)new GridData(768));
        GridData data = new GridData(1808);
        section.setLayoutData((Object)data);
        String editLabel = PDEUIMessages.SiteEditor_PortabilitySection_edit;
        this.fOsText = new FormEntry(container, toolkit, PDEUIMessages.SiteEditor_PortabilitySection_os, editLabel, false);
        this.fOsText.setFormEntryListener(new FormEntryAdapter(this){

            @Override
            public void browseButtonSelected(FormEntry entry) {
                BusyIndicator.showWhile((Display)PortabilitySection.this.fOsText.getText().getDisplay(), (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        Choice[] choices = PortabilitySection.getOSChoices();
                        PortabilitySection.this.openPortabilityChoiceDialog("os", PortabilitySection.this.fOsText, choices);
                    }
                });
            }

            @Override
            public void textValueChanged(FormEntry text) {
                try {
                    PortabilitySection.this.applyValue("os", text.getValue());
                }
                catch (CoreException e) {
                    PDEPlugin.logException(e);
                }
            }
        });
        this.limitTextWidth(this.fOsText);
        this.fOsText.setEditable(this.isEditable());
        this.fWsText = new FormEntry(container, toolkit, PDEUIMessages.SiteEditor_PortabilitySection_ws, editLabel, false);
        this.fWsText.setFormEntryListener(new FormEntryAdapter(this){

            @Override
            public void browseButtonSelected(FormEntry entry) {
                BusyIndicator.showWhile((Display)PortabilitySection.this.fWsText.getText().getDisplay(), (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        Choice[] choices = PortabilitySection.getWSChoices();
                        PortabilitySection.this.openPortabilityChoiceDialog("ws", PortabilitySection.this.fWsText, choices);
                    }
                });
            }

            @Override
            public void textValueChanged(FormEntry text) {
                try {
                    PortabilitySection.this.applyValue("ws", text.getValue());
                }
                catch (CoreException e) {
                    PDEPlugin.logException(e);
                }
            }
        });
        this.limitTextWidth(this.fWsText);
        this.fWsText.setEditable(this.isEditable());
        this.fNlText = new FormEntry(container, toolkit, PDEUIMessages.SiteEditor_PortabilitySection_nl, editLabel, false);
        this.fNlText.setFormEntryListener(new FormEntryAdapter(this){

            @Override
            public void browseButtonSelected(FormEntry entry) {
                BusyIndicator.showWhile((Display)PortabilitySection.this.fNlText.getText().getDisplay(), (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        Choice[] choices = PortabilitySection.getNLChoices();
                        PortabilitySection.this.openPortabilityChoiceDialog("nl", PortabilitySection.this.fNlText, choices);
                    }
                });
            }

            @Override
            public void textValueChanged(FormEntry text) {
                try {
                    PortabilitySection.this.applyValue("nl", text.getValue());
                }
                catch (CoreException e) {
                    PDEPlugin.logException(e);
                }
            }
        });
        this.limitTextWidth(this.fNlText);
        this.fNlText.setEditable(this.isEditable());
        this.fArchText = new FormEntry(container, toolkit, PDEUIMessages.SiteEditor_PortabilitySection_arch, editLabel, false);
        this.fArchText.setFormEntryListener(new FormEntryAdapter(this){

            @Override
            public void browseButtonSelected(FormEntry entry) {
                BusyIndicator.showWhile((Display)PortabilitySection.this.fArchText.getText().getDisplay(), (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        Choice[] choices = PortabilitySection.getArchChoices();
                        PortabilitySection.this.openPortabilityChoiceDialog("arch", PortabilitySection.this.fArchText, choices);
                    }
                });
            }

            @Override
            public void textValueChanged(FormEntry text) {
                try {
                    PortabilitySection.this.applyValue("arch", text.getValue());
                }
                catch (CoreException e) {
                    PDEPlugin.logException(e);
                }
            }
        });
        this.limitTextWidth(this.fArchText);
        this.fArchText.setEditable(this.isEditable());
        toolkit.paintBordersFor(container);
        section.setClient((Control)container);
    }

    public void dispose() {
        ISiteModel model = (ISiteModel)this.getPage().getModel();
        if (model != null) {
            model.removeModelChangedListener((IModelChangedListener)this);
        }
        super.dispose();
    }

    public void initialize(IManagedForm form) {
        ISiteModel model = (ISiteModel)this.getPage().getModel();
        if (model != null) {
            model.addModelChangedListener((IModelChangedListener)this);
        }
        super.initialize(form);
    }

    private void limitTextWidth(FormEntry entry) {
        GridData gd = (GridData)entry.getText().getLayoutData();
        gd.widthHint = 30;
    }

    @Override
    public void modelChanged(IModelChangedEvent e) {
        this.markStale();
    }

    private void openPortabilityChoiceDialog(String property, FormEntry text, Choice[] choices) {
        String value = text.getValue();
        PortabilityChoicesDialog dialog = new PortabilityChoicesDialog(PDEPlugin.getActiveWorkbenchShell(), choices, value);
        dialog.create();
        dialog.getShell().setText(PDEUIMessages.SiteEditor_PortabilityChoicesDialog_title);
        int result = dialog.open();
        if (result == 0) {
            value = dialog.getValue();
            text.setValue(value);
            try {
                this.applyValue(property, value);
            }
            catch (CoreException e) {
                PDEPlugin.logException(e);
            }
        }
    }

    public void refresh() {
        if (this.fCurrentSiteFeature == null) {
            this.clearFields();
            super.refresh();
            return;
        }
        this.setValue("os");
        this.setValue("ws");
        this.setValue("arch");
        this.setValue("nl");
        super.refresh();
    }

    public void selectionChanged(IFormPart part, ISelection selection) {
        Object o;
        this.fCurrentSiteFeature = selection instanceof IStructuredSelection && !selection.isEmpty() ? ((o = ((IStructuredSelection)selection).getFirstElement()) instanceof SiteFeatureAdapter ? ((SiteFeatureAdapter)o).feature : null) : null;
        this.refresh();
    }

    public void setFocus() {
        if (this.fOsText != null) {
            this.fOsText.getText().setFocus();
        }
    }

    private void setValue(String property) {
        if (this.fCurrentSiteFeature == null) {
            this.clearField(property);
        } else if (property.equals("nl")) {
            this.fNlText.setValue(this.fCurrentSiteFeature.getNL(), true);
        } else if (property.equals("os")) {
            this.fOsText.setValue(this.fCurrentSiteFeature.getOS(), true);
        } else if (property.equals("ws")) {
            this.fWsText.setValue(this.fCurrentSiteFeature.getWS(), true);
        } else if (property.equals("arch")) {
            this.fArchText.setValue(this.fCurrentSiteFeature.getArch(), true);
        }
    }
}

