/*
 * Decompiled with CFR 0.152.
 */
package org.epic.core.model;

import org.epic.core.model.IMultilineElement;
import org.epic.core.model.IPackageElement;
import org.epic.core.model.Package;
import org.epic.core.parser.CurlyToken;
import org.epic.core.parser.PerlToken;

public class Subroutine
implements IMultilineElement,
IPackageElement {
    private final Package parent;
    private final int index;
    private final PerlToken subKeyword;
    private final PerlToken name;
    private final CurlyToken openCurly;
    private CurlyToken closeCurly;

    public Subroutine(Package parent, int index, PerlToken subKeyword, PerlToken name, CurlyToken openCurly) {
        assert (parent != null);
        assert (index >= 0);
        assert (subKeyword != null);
        assert (name != null);
        assert (openCurly != null);
        this.parent = parent;
        this.index = index;
        this.subKeyword = subKeyword;
        this.name = name;
        this.openCurly = openCurly;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Subroutine)) {
            return false;
        }
        Subroutine sub = (Subroutine)obj;
        return this.index == sub.index && this.parent.equals(sub.parent);
    }

    public int getBlockLevel() {
        return this.openCurly.getLevel();
    }

    public CurlyToken getCloseCurly() {
        return this.closeCurly;
    }

    @Override
    public int getLength() {
        return this.name.getLength();
    }

    @Override
    public String getName() {
        return this.name.getText();
    }

    public PerlToken getNameToken() {
        return this.name;
    }

    @Override
    public int getOffset() {
        return this.name.getOffset();
    }

    public CurlyToken getOpenCurly() {
        return this.openCurly;
    }

    @Override
    public Package getParent() {
        return this.parent;
    }

    public PerlToken getSubKeyword() {
        return this.subKeyword;
    }

    @Override
    public int getEndLine() {
        return this.closeCurly != null ? this.closeCurly.getLine() - 1 : this.getStartLine();
    }

    @Override
    public int getStartLine() {
        return this.subKeyword.getLine() - 1;
    }

    public int hashCode() {
        return this.parent.hashCode() * 37 + this.index;
    }

    public void setCloseCurly(CurlyToken curly) {
        assert (this.closeCurly == null);
        assert (curly.getLevel() == this.openCurly.getLevel());
        this.closeCurly = curly;
    }

    public String toString() {
        return "sub #" + this.index + " " + this.getName() + " @" + this.getOffset();
    }
}

