/*
 * Decompiled with CFR 0.152.
 */
package org.epic.core.util;

import java.util.ArrayList;
import java.util.List;

public class CommandLineTokenizer {
    private CommandLineTokenizer() {
    }

    public static List tokenize(String commandLine) {
        String token;
        ArrayList<String> tokens = new ArrayList<String>();
        int[] pos = new int[1];
        while ((token = CommandLineTokenizer.readToken(commandLine, pos)) != null) {
            tokens.add(token);
        }
        return tokens;
    }

    private static String readToken(String line, int[] posInOut) {
        int pos = posInOut[0];
        while (pos < line.length() && Character.isWhitespace(line.charAt(pos))) {
            ++pos;
        }
        if (pos == line.length()) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        boolean escape = false;
        boolean inQuote = false;
        while (pos < line.length()) {
            char c = line.charAt(pos);
            if (escape) {
                if (c == '\"') {
                    buf.append('\"');
                } else if (c == '\\') {
                    buf.append('\\');
                } else {
                    buf.append('\\');
                    buf.append(c);
                }
                escape = false;
            } else if (inQuote) {
                if (c == '\\') {
                    escape = true;
                } else if (c == '\"') {
                    inQuote = false;
                } else {
                    buf.append(c);
                }
            } else if (c == '\"') {
                inQuote = true;
            } else if (c == '\\') {
                escape = true;
            } else {
                if (Character.isWhitespace(c)) break;
                buf.append(c);
            }
            ++pos;
        }
        if (escape) {
            buf.append('\\');
        }
        posInOut[0] = pos;
        return buf.toString();
    }
}

