/*
 * Decompiled with CFR 0.152.
 */
package org.epic.perleditor.templates.textmanipulation;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.epic.perleditor.templates.textmanipulation.TextBufferEditor;
import org.epic.perleditor.templates.textmanipulation.TextEdit;
import org.epic.perleditor.templates.textmanipulation.TextRange;

public class MultiTextEdit {
    private List fChildren;

    public MultiTextEdit() {
        this.fChildren = new ArrayList(3);
    }

    protected MultiTextEdit(List children) throws CoreException {
        this.fChildren = new ArrayList(children.size());
        Iterator iter = children.iterator();
        while (iter.hasNext()) {
            this.fChildren.add(((TextEdit)iter.next()).copy());
        }
    }

    protected List getChildren() {
        return this.fChildren;
    }

    public void add(MultiTextEdit edit) {
        assert (edit != null);
        this.fChildren.add(edit);
    }

    public void add(TextEdit edit) {
        assert (edit != null);
        this.fChildren.add(edit);
    }

    public Iterator iterator() {
        return this.fChildren.iterator();
    }

    public void connect(TextBufferEditor editor) throws CoreException {
        for (Object element : this.fChildren) {
            if (element instanceof TextEdit) {
                editor.add((TextEdit)element);
                continue;
            }
            editor.add((MultiTextEdit)element);
        }
    }

    public MultiTextEdit copy() throws CoreException {
        return new MultiTextEdit(this.fChildren);
    }

    public TextRange getTextRange() {
        int size = this.fChildren.size();
        if (size == 0) {
            return new TextRange(0, 0);
        }
        TextRange range = ((TextEdit)this.fChildren.get(0)).getTextRange();
        int start = range.getOffset();
        int end = range.getInclusiveEnd();
        int i = 1;
        while (i < size) {
            range = ((TextEdit)this.fChildren.get(i)).getTextRange();
            start = Math.min(start, range.getOffset());
            end = Math.max(end, range.getInclusiveEnd());
            ++i;
        }
        return new TextRange(start, end - start + 1);
    }

    public Object getModifiedElement() {
        return null;
    }
}

